/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.Splash;
import uk.ac.sanger.artemis.components.StickyFileChooser;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.DocumentEntryFactory;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class EntryFileDialog
extends StickyFileChooser {
    private JFrame owner = null;

    public EntryFileDialog(JFrame owner, boolean show_sequence_only) {
        this.owner = owner;
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(false);
        final StringVector sequence_suffixes = Options.getOptions().getOptionValues("sequence_file_suffixes");
        final StringVector feature_suffixes = Options.getOptions().getOptionValues("feature_file_suffixes");
        FileFilter artemis_filter = new FileFilter(){

            public boolean accept(File file) {
                String this_suffix;
                int i;
                if (file.isDirectory()) {
                    return true;
                }
                for (i = 0; i < sequence_suffixes.size(); ++i) {
                    this_suffix = sequence_suffixes.elementAt(i);
                    if (!file.getName().endsWith("." + this_suffix) && !file.getName().endsWith("." + this_suffix + ".gz")) continue;
                    return true;
                }
                for (i = 0; i < feature_suffixes.size(); ++i) {
                    this_suffix = feature_suffixes.elementAt(i);
                    if (!file.getName().endsWith("." + this_suffix) && !file.getName().endsWith("." + this_suffix + ".gz")) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Artemis files";
            }
        };
        FileFilter feature_filter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < feature_suffixes.size(); ++i) {
                    String this_suffix = feature_suffixes.elementAt(i);
                    if (!file.getName().endsWith("." + this_suffix) && !file.getName().endsWith("." + this_suffix + ".gz")) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Feature files";
            }
        };
        FileFilter sequence_filter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < sequence_suffixes.size(); ++i) {
                    String this_suffix = sequence_suffixes.elementAt(i);
                    if (!file.getName().endsWith("." + this_suffix) && !file.getName().endsWith("." + this_suffix + ".gz")) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Sequence files";
            }
        };
        this.addChoosableFileFilter(artemis_filter);
        this.addChoosableFileFilter(feature_filter);
        this.addChoosableFileFilter(sequence_filter);
        if (show_sequence_only) {
            this.setFileFilter(sequence_filter);
        } else {
            this.setFileFilter(artemis_filter);
        }
    }

    public uk.ac.sanger.artemis.io.Entry getEntry(EntryInformation entry_information, InputStreamProgressListener listener, ProgressThread progress_thread, boolean show_progress) {
        this.setDialogTitle("Select a file ...");
        this.setDialogType(0);
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(null);
        int status = this.showOpenDialog(this.owner);
        System.setSecurityManager(sm);
        if (status != 0 || this.getSelectedFile() == null) {
            return null;
        }
        if (progress_thread != null) {
            progress_thread.start();
        }
        File file = new File(this.getCurrentDirectory(), this.getSelectedFile().getName());
        return EntryFileDialog.getEntryFromFile(this.owner, new FileDocument(file), entry_information, show_progress);
    }

    private static uk.ac.sanger.artemis.io.Entry getEntryFromFileHelper(JFrame frame, Document file_document, EntryInformation entry_information) throws ReadFormatException, IOException {
        YesNoDialog yes_no_dialog;
        DocumentEntry new_entry;
        LogReadListener read_event_logger = new LogReadListener(file_document.getName());
        try {
            new_entry = DocumentEntryFactory.makeDocumentEntry(entry_information, file_document, read_event_logger);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        if (read_event_logger.seenMessage() && (yes_no_dialog = new YesNoDialog(frame, "there were warnings while reading - view now?")).getResult()) {
            Splash.showLog();
        }
        return new_entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static uk.ac.sanger.artemis.io.Entry getEntryFromFile(JFrame frame, Document entry_document, EntryInformation entry_information, boolean show_progress) {
        Object progress_dialog = null;
        if (show_progress) {
            // empty if block
        }
        try {
            return EntryFileDialog.getEntryFromFileHelper(frame, entry_document, entry_information);
        }
        catch (ReadFormatException e) {
            String message = "failed to open " + entry_document.getName() + ": " + e.getMessage() + (e.getLineNumber() > 1 ? " at line: " + e.getLineNumber() : "");
            System.out.println(message);
            new MessageDialog(frame, message);
            return null;
        }
        catch (FileNotFoundException e) {
            String message = "failed to open " + entry_document.getName() + ": file not found";
            new MessageDialog(frame, message);
            return null;
        }
        catch (IOException e) {
            String message = "failed to open " + entry_document.getName() + ": " + e.getMessage();
            new MessageDialog(frame, message);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveEntry(Entry entry, boolean include_diana_extensions, boolean ask_for_name, boolean keep_new_name, int destination_type) {
        block31: {
            try {
                if (ask_for_name || entry.getName() == null) {
                    File file;
                    block30: {
                        YesNoDialog yes_no_dialog;
                        int status;
                        JCheckBox emblHeader = new JCheckBox("Add EMBL Header", false);
                        emblHeader.setSelected(false);
                        this.setDialogTitle("Save to ...");
                        this.setDialogType(1);
                        if (!(destination_type != 1 || entry.getHeaderText() != null && this.isHeaderEMBL(entry.getHeaderText()))) {
                            this.setAccessory(emblHeader);
                        }
                        if ((status = this.showSaveDialog(this.owner)) != 0 || this.getSelectedFile() == null) {
                            return;
                        }
                        if (emblHeader.isSelected()) {
                            Box bdown = Box.createVerticalBox();
                            JTextField idField = new JTextField("");
                            bdown.add(idField);
                            int n = JOptionPane.showConfirmDialog(null, bdown, "Enter the entry ID", 2, 3);
                            if (n != 2 && !idField.getText().trim().equals("")) {
                                String header = "ID   " + idField.getText().trim();
                                if (entry.getFeatureCount() > 0) {
                                    header = header.concat("\nFH   Key             Location/Qualifiers\nFH\n");
                                }
                                entry.setHeaderText(header);
                            }
                        }
                        if ((file = new File(this.getCurrentDirectory(), this.getSelectedFile().getName())).exists() && !(yes_no_dialog = new YesNoDialog(this.owner, "this file exists: " + file.getName() + " overwrite it?")).getResult()) {
                            return;
                        }
                        MessageDialog message = new MessageDialog(this.owner, "saving to " + file.getName() + " ...", false);
                        try {
                            if (include_diana_extensions) {
                                entry.save(file, destination_type, false);
                            } else {
                                entry.saveStandardOnly(file, destination_type, true);
                            }
                        }
                        catch (EntryInformationException e) {
                            YesNoDialog yes_no_dialog2 = new YesNoDialog(this.owner, "destination format can't handle all keys/qualifiers - continue?");
                            if (yes_no_dialog2.getResult()) {
                                try {
                                    if (include_diana_extensions) {
                                        entry.save(file, destination_type, true);
                                    } else {
                                        entry.saveStandardOnly(file, destination_type, true);
                                    }
                                    break block30;
                                }
                                catch (EntryInformationException e2) {
                                    throw new Error("internal error - unexpected exception: " + e);
                                }
                            }
                            return;
                        }
                        finally {
                            if (message != null) {
                                message.dispose();
                            }
                        }
                    }
                    if (keep_new_name) {
                        entry.setName(file.getName());
                    }
                    break block31;
                }
                MessageDialog message = new MessageDialog(this.owner, "saving to " + entry.getName() + " ...", false);
                try {
                    if (include_diana_extensions) {
                        entry.save(destination_type);
                    } else {
                        entry.saveStandardOnly(destination_type);
                    }
                }
                finally {
                    message.dispose();
                }
            }
            catch (ReadOnlyException e) {
                new MessageDialog(this.owner, "this entry is read only");
                return;
            }
            catch (IOException e) {
                new MessageDialog(this.owner, "error while saving: " + e);
                return;
            }
            catch (EntryInformationException e) {
                new MessageDialog(this.owner, "error while saving: " + e);
                return;
            }
        }
    }

    private boolean isHeaderEMBL(String header) {
        StringReader reader = new StringReader(header);
        BufferedReader buff_reader = new BufferedReader(reader);
        try {
            if (!buff_reader.readLine().startsWith("ID")) {
                return false;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return true;
    }
}

