/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.DisplayComponent;
import uk.ac.sanger.artemis.components.EntryGroupPanel;
import uk.ac.sanger.artemis.components.FeatureEdit;
import uk.ac.sanger.artemis.components.FeaturePopup;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.StreamQualifier;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.util.StringVector;

public class FeatureList
extends EntryGroupPanel
implements EntryGroupChangeListener,
EntryChangeListener,
FeatureChangeListener,
SelectionChangeListener,
DisplayComponent {
    private boolean show_correlation_scores = false;
    private JScrollBar scrollbar = null;
    private JScrollBar horiz_scrollbar = null;
    private int first_index;
    private boolean selection_changed_flag = false;
    private Color background_colour = Color.white;
    private boolean show_gene_names = false;
    private boolean show_products = false;
    private boolean show_qualifiers = false;
    private int max_base_pos_width;
    private boolean need_to_fix_horiz_scrollbar = true;

    public FeatureList(EntryGroup entry_group, Selection selection, GotoEventSource goto_event_source, BasePlotGroup base_plot_group) {
        super(entry_group, selection, goto_event_source, base_plot_group);
        this.getCanvas().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (FeatureList.this.isMenuTrigger(event)) {
                    FeaturePopup popup = new FeaturePopup(FeatureList.this, FeatureList.this.getEntryGroup(), FeatureList.this.getSelection(), FeatureList.this.getGotoEventSource(), FeatureList.this.getBasePlotGroup());
                    JComponent parent = (JComponent)event.getSource();
                    popup.show(parent, event.getX(), event.getY());
                } else {
                    FeatureList.this.handleCanvasMousePress(event);
                }
            }
        });
        this.createScrollbars();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                FeatureList.this.repaintCanvas();
            }

            public void componentResized(ComponentEvent e) {
                FeatureList.this.repaintCanvas();
            }
        });
        this.getSelection().addSelectionChangeListener(this);
        this.getEntryGroup().addEntryGroupChangeListener(this);
        this.getEntryGroup().addEntryChangeListener(this);
        this.getEntryGroup().addFeatureChangeListener(this);
        int sequence_length = this.getEntryGroup().getSequenceLength();
        this.max_base_pos_width = (int)(Math.log(sequence_length) / Math.log(10.0)) + 1;
        if (this.max_base_pos_width < 4) {
            this.max_base_pos_width = 4;
        }
        this.repaintCanvas();
    }

    void stopListening() {
        this.getSelection().removeSelectionChangeListener(this);
        this.getEntryGroup().removeEntryGroupChangeListener(this);
        this.getEntryGroup().removeEntryChangeListener(this);
        this.getEntryGroup().removeFeatureChangeListener(this);
    }

    public void setCorrelationScores(boolean show_correlation_scores) {
        if (this.show_correlation_scores != show_correlation_scores) {
            this.show_correlation_scores = show_correlation_scores;
            this.repaintCanvas();
        }
    }

    public boolean getCorrelationScores() {
        return this.show_correlation_scores;
    }

    public void setShowGenes(boolean show_gene_names) {
        if (this.show_gene_names != show_gene_names) {
            this.show_gene_names = show_gene_names;
            this.repaintCanvas();
        }
    }

    public boolean getShowGenes() {
        return this.show_gene_names;
    }

    public void setShowQualifiers(boolean show_qualifiers) {
        if (this.show_qualifiers != show_qualifiers) {
            this.show_qualifiers = show_qualifiers;
            this.repaintCanvas();
        }
    }

    public boolean getShowQualifiers() {
        return this.show_qualifiers;
    }

    public void setShowProducts(boolean show_products) {
        if (this.show_products != show_products) {
            this.show_products = show_products;
            this.repaintCanvas();
        }
    }

    public boolean getShowProducts() {
        return this.show_products;
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.repaintCanvas();
            }
        }
    }

    public void featureChanged(FeatureChangeEvent event) {
        if (!this.isVisible()) {
            return;
        }
        this.repaintCanvas();
    }

    public void entryChanged(EntryChangeEvent event) {
        if (!this.isVisible()) {
            return;
        }
        this.repaintCanvas();
    }

    public void selectionChanged(SelectionChangeEvent event) {
        if (!this.isVisible()) {
            return;
        }
        if (event.getSource() == this) {
            return;
        }
        if (this.getSelection().getMarkerRange() != null && event.getType() == 3) {
            return;
        }
        this.selection_changed_flag = true;
        this.repaintCanvas();
    }

    public StringVector getListStrings() {
        StringVector return_vector = new StringVector();
        FeatureEnumeration test_enumerator = this.getEntryGroup().features();
        while (test_enumerator.hasMoreFeatures()) {
            Feature this_feature = test_enumerator.nextFeature();
            return_vector.add(this.makeFeatureString(this_feature, true));
        }
        return return_vector;
    }

    private void createScrollbars() {
        this.scrollbar = new JScrollBar(1);
        this.scrollbar.setValues(0, 1, 0, this.getEntryGroup().getAllFeaturesCount());
        this.scrollbar.setUnitIncrement(1);
        this.scrollbar.setBlockIncrement(1);
        this.scrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                FeatureList.this.setFirstIndex(e.getValue());
            }
        });
        this.horiz_scrollbar = new JScrollBar(0);
        this.horiz_scrollbar.setValues(0, 1, 0, this.getEntryGroup().getAllFeaturesCount() - 1);
        this.horiz_scrollbar.setUnitIncrement(this.getFontWidth());
        this.horiz_scrollbar.setBlockIncrement(100);
        this.horiz_scrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                FeatureList.this.repaintCanvas();
            }
        });
        this.getMidPanel().add((Component)this.horiz_scrollbar, "South");
        this.add((Component)this.scrollbar, "East");
    }

    private void fixHorizScrollBar(int max_width) {
        int old_value = this.horiz_scrollbar.getValue();
        this.horiz_scrollbar.setValues(this.horiz_scrollbar.getValue(), this.getCanvas().getSize().width, 0, max_width * this.getFontWidth());
        this.horiz_scrollbar.setBlockIncrement(this.getCanvas().getSize().width);
    }

    public void setFirstIndex(int first_index) {
        this.first_index = first_index;
        this.need_to_fix_horiz_scrollbar = true;
        this.repaintCanvas();
    }

    private void handleCanvasMousePress(MouseEvent event) {
        int clicked_feature_index;
        if (event.getID() != 501) {
            return;
        }
        this.getCanvas().requestFocus();
        if (!event.isShiftDown()) {
            this.getSelection().clear();
        }
        if ((clicked_feature_index = this.scrollbar.getValue() + event.getY() / this.getLineHeight()) < this.getEntryGroup().getAllFeaturesCount()) {
            Feature clicked_feature;
            FeatureVector selected_features = this.getSelection().getAllFeatures();
            if (selected_features.contains(clicked_feature = this.getEntryGroup().featureAt(clicked_feature_index))) {
                this.getSelection().remove(clicked_feature);
                this.getSelection().removeSegmentsOf(clicked_feature);
            } else {
                this.getSelection().add(clicked_feature);
            }
            if (event.getClickCount() == 2) {
                this.makeSelectionVisible();
                if (((event.getModifiers() & 8) != 0 || event.isAltDown()) && Options.readWritePossible()) {
                    new FeatureEdit(clicked_feature, this.getEntryGroup(), this.getSelection(), this.getGotoEventSource()).show();
                }
            }
        }
    }

    protected void paintCanvas(Graphics g) {
        int feature_count;
        this.refresh();
        if (!this.isVisible()) {
            return;
        }
        if (this.selection_changed_flag) {
            this.selection_changed_flag = false;
            FeatureVector selected_features = this.getSelection().getAllFeatures();
            if (selected_features.size() > 0) {
                boolean a_selected_feature_is_visible = false;
                int first_line_in_view = this.scrollbar.getValue();
                if (first_line_in_view == -1) {
                    first_line_in_view = 0;
                }
                feature_count = this.getEntryGroup().getAllFeaturesCount();
                for (int i = first_line_in_view; i < feature_count && i < first_line_in_view + this.linesInView(); ++i) {
                    Feature this_feature = this.getEntryGroup().featureAt(i);
                    if (!selected_features.contains(this_feature)) continue;
                    a_selected_feature_is_visible = true;
                    break;
                }
                if (!a_selected_feature_is_visible) {
                    Feature first_selected_feature = selected_features.elementAt(0);
                    int index_of_first_selected_feature = this.getEntryGroup().indexOf(first_selected_feature);
                    if (index_of_first_selected_feature < this.scrollbar.getValue() || index_of_first_selected_feature >= this.scrollbar.getValue() + this.linesInView()) {
                        this.scrollbar.setValue(index_of_first_selected_feature);
                    }
                }
            }
        }
        g.setColor(this.background_colour);
        g.fillRect(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
        g.setColor(Color.black);
        int all_feature_count = this.getEntryGroup().getAllFeaturesCount();
        if (all_feature_count == 0) {
            this.fixHorizScrollBar(0);
        } else {
            int lines_in_view = this.linesInView();
            int first_index_in_view = this.scrollbar.getValue();
            if (first_index_in_view == -1) {
                first_index_in_view = 0;
            }
            int last_index_in_view = lines_in_view < (feature_count = this.getEntryGroup().getAllFeaturesCount()) - first_index_in_view ? first_index_in_view + lines_in_view : feature_count - 1;
            FeatureVector features_in_view = this.getEntryGroup().getFeaturesInIndexRange(first_index_in_view, last_index_in_view);
            int max_width = -1;
            for (int i = 0; i <= last_index_in_view - first_index_in_view; ++i) {
                Feature this_feature = features_in_view.elementAt(i);
                String feature_string = this.makeFeatureString(this_feature, false);
                this.drawFeatureLine(g, this_feature, feature_string, i);
                if (feature_string.length() <= max_width) continue;
                max_width = feature_string.length();
            }
            if (this.need_to_fix_horiz_scrollbar) {
                this.fixHorizScrollBar(max_width);
            }
        }
    }

    private int linesInView() {
        return this.getCanvas().getSize().height / this.getLineHeight();
    }

    private void refresh() {
        this.scrollbar.setMaximum(this.getEntryGroup().getAllFeaturesCount());
        int lines_in_view = this.linesInView();
        this.scrollbar.setBlockIncrement(lines_in_view > 0 ? lines_in_view : 1);
        this.scrollbar.setUnitIncrement(1);
        this.scrollbar.setVisibleAmount(this.linesInView());
    }

    private void drawFeatureLine(Graphics g, Feature feature, String feature_string, int line) {
        int y_pos = line * this.getLineHeight();
        int BOX_WIDTH = this.getLineHeight();
        Color feature_colour = feature.getColour();
        if (feature_colour == null) {
            g.setColor(Color.white);
        } else {
            g.setColor(feature_colour);
        }
        g.fillRect(1 - this.horiz_scrollbar.getValue(), y_pos + 1, BOX_WIDTH, this.getLineHeight() - 1);
        if (this.getSelection().contains(feature)) {
            g.setColor(Color.black);
            g.fillRect(BOX_WIDTH + 4 - this.horiz_scrollbar.getValue(), y_pos, this.getCanvas().getSize().width + this.horiz_scrollbar.getValue(), this.getLineHeight());
            g.setColor(this.background_colour);
        } else {
            g.setColor(Color.black);
        }
        g.setFont(this.getFont());
        g.drawString(feature_string, BOX_WIDTH + 5 - this.horiz_scrollbar.getValue(), y_pos + this.getFontAscent());
        g.setPaintMode();
    }

    private int indexOf(Feature feature) {
        return this.getEntryGroup().indexOf(feature);
    }

    private String makeFeatureString(Feature feature, boolean dont_truncate) {
        String high_pos;
        String low_pos;
        String key_string;
        int KEY_FIELD_WIDTH = 15;
        if (this.show_gene_names) {
            key_string = feature.getIDString();
            if (key_string.length() > 15 && !dont_truncate) {
                key_string = key_string.substring(0, 15);
            }
        } else {
            key_string = feature.getKey().toString();
        }
        Marker low_marker = feature.getFirstBaseMarker();
        Marker high_marker = feature.getLastBaseMarker();
        StringBuffer description_string_buffer = new StringBuffer();
        if (this.show_products) {
            String product_string = feature.getProductString();
            if (product_string == null) {
                if (feature.isCDS()) {
                    description_string_buffer.append("[no /product]");
                }
            } else {
                description_string_buffer.append(product_string);
            }
        } else {
            String note = feature.getNote();
            if (note != null && note.length() != 0) {
                int QUALIFIER_COLUMN = 10;
                String note_string = this.padRightWithSpaces(feature.getNote(), 10);
                description_string_buffer.append(note_string);
                description_string_buffer.append("   ");
            }
            if (this.show_qualifiers) {
                description_string_buffer.append(this.getQualifierString(feature));
            }
        }
        if (low_marker == null || high_marker == null) {
            low_pos = "unknown";
            high_pos = "unknown";
        } else if (low_marker.getRawPosition() < high_marker.getRawPosition()) {
            low_pos = String.valueOf(low_marker.getRawPosition());
            high_pos = String.valueOf(high_marker.getRawPosition());
        } else {
            low_pos = String.valueOf(high_marker.getRawPosition());
            high_pos = String.valueOf(low_marker.getRawPosition());
        }
        StringBuffer new_list_line = new StringBuffer();
        new_list_line.append(this.padRightWithSpaces(key_string, 15));
        new_list_line.append(" ");
        new_list_line.append(this.padLeftWithSpaces(low_pos, this.max_base_pos_width));
        new_list_line.append(" ");
        new_list_line.append(this.padLeftWithSpaces(high_pos, this.max_base_pos_width));
        new_list_line.append(" ");
        if (feature.isForwardFeature()) {
            new_list_line.append("   ");
        } else {
            new_list_line.append("c  ");
        }
        if (this.show_correlation_scores) {
            if (feature.isCDS()) {
                new_list_line.append(this.getScoresString(feature));
                new_list_line.append("  ");
            } else {
                new_list_line.append("                         ");
                if (this.getBasePlotGroup().getCodonUsageAlgorithm() != null) {
                    new_list_line.append("      ");
                }
            }
        }
        new_list_line.append(description_string_buffer.toString());
        return new_list_line.toString();
    }

    private int getWidthInChars() {
        return this.getCanvas().getSize().width / this.getFontWidth();
    }

    private String formatQualifier(String qualifier_name, Feature feature, int start_index) {
        StringBuffer buffer = new StringBuffer();
        try {
            Qualifier qualifier = feature.getQualifierByName(qualifier_name);
            if (qualifier != null) {
                EntryInformation entry_information = feature.getEntry().getEntryInformation();
                QualifierInfo qualifier_info = entry_information.getQualifierInfo(qualifier_name);
                StringVector qualifier_strings = StreamQualifier.toStringVector(qualifier_info, qualifier);
                for (int i = start_index; i < qualifier_strings.size(); ++i) {
                    String qualifier_string = qualifier_strings.elementAt(i);
                    buffer.append(qualifier_string + " ");
                }
            }
        }
        catch (InvalidRelationException e) {
            // empty catch block
        }
        return buffer.toString();
    }

    private String getQualifierString(Feature feature) {
        Qualifier similarity_qualifier;
        StringBuffer buffer = new StringBuffer();
        QualifierVector qualifiers = feature.getQualifiers();
        Qualifier note_qualifier = qualifiers.getQualifierByName("note");
        if (note_qualifier != null && note_qualifier.getValues().size() > 1) {
            buffer.append(this.formatQualifier("note", feature, 1));
            buffer.append(" ");
        }
        if ((similarity_qualifier = qualifiers.getQualifierByName("similarity")) != null) {
            buffer.append(this.formatQualifier("similarity", feature, 0));
            buffer.append(" ");
        }
        for (int i = 0; i < qualifiers.size(); ++i) {
            Qualifier this_qualifier = qualifiers.elementAt(i);
            String this_qualifier_name = this_qualifier.getName();
            if (this_qualifier_name.equals("note") || this_qualifier_name.equals("similarity")) continue;
            buffer.append(this.formatQualifier(this_qualifier_name, feature, 0));
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public String getScoresString(Feature feature) {
        int base_total = feature.getTranslationBases().length();
        int c_total = feature.getBaseCount(Bases.getIndexOfBase('c'));
        int g_total = feature.getBaseCount(Bases.getIndexOfBase('g'));
        int g1_count = feature.getPositionalBaseCount(0, Bases.getIndexOfBase('g'));
        int c3_count = feature.getPositionalBaseCount(2, Bases.getIndexOfBase('c'));
        int g3_count = feature.getPositionalBaseCount(2, Bases.getIndexOfBase('g'));
        double c3_score = 100.0 * (double)(3 * c3_count - c_total) / (double)c_total;
        double g1_score = 100.0 * (double)(3 * g1_count - g_total) / (double)g_total;
        double g3_score = 100.0 * (double)(3 * g3_count - g_total) / (double)g_total;
        double cor1_2_score = feature.get12CorrelationScore();
        NumberFormat number_format = NumberFormat.getNumberInstance();
        number_format.setMaximumFractionDigits(1);
        number_format.setMinimumFractionDigits(1);
        String cor1_2_score_string = number_format.format(cor1_2_score);
        String c3_score_string = c_total == 0 ? "ALL" : number_format.format(c3_score);
        String g1_score_string = g_total == 0 ? "ALL" : number_format.format(g1_score);
        String g3_score_string = g_total == 0 ? "ALL" : number_format.format(g3_score);
        String codon_usage_score_string = "";
        CodonUsageAlgorithm codon_usage_alg = this.getBasePlotGroup().getCodonUsageAlgorithm();
        if (codon_usage_alg != null) {
            number_format.setMaximumFractionDigits(3);
            number_format.setMinimumFractionDigits(3);
            codon_usage_score_string = number_format.format(codon_usage_alg.getFeatureScore(feature)) + " ";
        }
        return codon_usage_score_string + this.padRightWithSpaces(cor1_2_score_string, 5) + " " + this.padRightWithSpaces(c3_score_string, 5) + " " + this.padRightWithSpaces(g1_score_string, 5) + " " + this.padRightWithSpaces(g3_score_string, 5);
    }

    private String padRightWithSpaces(String string, int width) {
        if (string.length() == width) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(string);
        for (int i = 0; i < width - string.length(); ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private String padLeftWithSpaces(String string, int width) {
        if (string.length() == width) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < width - string.length(); ++i) {
            buffer.append(' ');
        }
        buffer.append(string);
        return buffer.toString();
    }

    private int getLineHeight() {
        return this.getFontAscent() + 2;
    }
}

