/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.AddMenu;
import uk.ac.sanger.artemis.components.ArtemisCheckboxMenuItem;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.DisplayComponent;
import uk.ac.sanger.artemis.components.EditMenu;
import uk.ac.sanger.artemis.components.EntryGroupMenu;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.FeatureList;
import uk.ac.sanger.artemis.components.GotoMenu;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.RunMenu;
import uk.ac.sanger.artemis.components.ScoreChangeEvent;
import uk.ac.sanger.artemis.components.ScoreChangeListener;
import uk.ac.sanger.artemis.components.ScoreChanger;
import uk.ac.sanger.artemis.components.SelectMenu;
import uk.ac.sanger.artemis.components.StickyFileChooser;
import uk.ac.sanger.artemis.components.ViewMenu;
import uk.ac.sanger.artemis.components.WriteMenu;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.util.StringVector;

public class FeaturePopup
extends JPopupMenu {
    private EntryGroup entry_group;
    private final Selection selection;
    private GotoEventSource goto_event_source;
    private DisplayComponent owner;
    private FeatureDisplay feature_display = null;
    private FeatureList feature_list = null;
    private FeatureVector selection_features;
    private FeatureSegmentVector selection_segments;
    private JCheckBoxMenuItem show_labels_item = null;
    private JCheckBoxMenuItem one_line_per_entry_item = null;
    private JCheckBoxMenuItem show_forward_frame_lines_item = null;
    private JCheckBoxMenuItem show_reverse_frame_lines_item = null;
    private JCheckBoxMenuItem show_start_codons_item = null;
    private JCheckBoxMenuItem show_stop_codons_item = null;
    private JCheckBoxMenuItem show_feature_arrows_item = null;
    private JCheckBoxMenuItem show_feature_borders_item = null;
    private JCheckBoxMenuItem frame_features_item = null;
    private JCheckBoxMenuItem source_features_item = null;
    private JCheckBoxMenuItem rev_comp_display_item = null;
    private JCheckBoxMenuItem base_colours_item = null;
    private JCheckBoxMenuItem correlation_scores_item = null;
    private JCheckBoxMenuItem show_genes_item = null;
    private JCheckBoxMenuItem show_products_item = null;
    private JCheckBoxMenuItem show_qualifiers_item = null;
    private JMenuItem entry_group_menu_item = null;
    private JMenuItem select_menu_item = null;
    private JMenuItem add_menu_item = null;
    private JMenuItem view_menu_item = null;
    private JMenuItem edit_menu_item = null;
    private JMenuItem goto_menu_item = null;
    private JMenuItem write_menu_item = null;
    private JMenuItem run_menu_item = null;
    private JMenuItem broadcast_item = null;
    private JMenuItem raise_feature_item = null;
    private JMenuItem lower_feature_item = null;
    private JMenuItem smallest_to_front_item = null;
    private JMenuItem zoom_to_selection_item = null;
    private JMenuItem score_cutoffs_item = null;
    private JMenuItem select_visible_range = null;
    private JMenuItem save_feature_list_item = null;
    private JMenuItem select_visible_features = null;
    private BasePlotGroup base_plot_group = null;

    public FeaturePopup(DisplayComponent owner, EntryGroup entry_group, Selection selection, GotoEventSource goto_event_source, BasePlotGroup base_plot_group) {
        super(FeaturePopup.getMenuName(owner));
        this.owner = owner;
        this.entry_group = entry_group;
        this.selection = selection;
        this.goto_event_source = goto_event_source;
        this.base_plot_group = base_plot_group;
        this.selection_features = selection.getSelectedFeatures();
        this.selection_segments = selection.getSelectedSegments();
        this.makeSubMenus();
        this.addGenericItems();
        if (owner instanceof FeatureDisplay) {
            this.feature_display = (FeatureDisplay)owner;
            this.addFeatureDisplayItems();
        } else {
            this.feature_list = (FeatureList)owner;
            this.addFeatureListItems();
        }
        this.maybeAdd(this.raise_feature_item);
        this.maybeAdd(this.lower_feature_item);
        this.maybeAdd(this.smallest_to_front_item);
        this.maybeAdd(this.zoom_to_selection_item);
        this.maybeAdd(this.select_visible_range);
        this.maybeAdd(this.select_visible_features);
        this.maybeAdd(this.score_cutoffs_item);
        this.maybeAdd(this.save_feature_list_item);
        this.addSeparator();
        this.maybeAdd(this.entry_group_menu_item);
        this.maybeAdd(this.select_menu_item);
        this.maybeAdd(this.goto_menu_item);
        this.maybeAdd(this.view_menu_item);
        this.maybeAdd(this.edit_menu_item);
        this.maybeAdd(this.add_menu_item);
        this.maybeAdd(this.write_menu_item);
        this.maybeAdd(this.run_menu_item);
        this.addSeparator();
        this.maybeAdd(this.show_labels_item);
        this.maybeAdd(this.one_line_per_entry_item);
        this.maybeAdd(this.show_forward_frame_lines_item);
        this.maybeAdd(this.show_reverse_frame_lines_item);
        this.maybeAdd(this.show_start_codons_item);
        this.maybeAdd(this.show_stop_codons_item);
        this.maybeAdd(this.show_feature_arrows_item);
        this.maybeAdd(this.show_feature_borders_item);
        this.maybeAdd(this.frame_features_item);
        this.maybeAdd(this.source_features_item);
        this.maybeAdd(this.rev_comp_display_item);
        this.maybeAdd(this.base_colours_item);
        this.maybeAdd(this.correlation_scores_item);
        this.maybeAdd(this.show_genes_item);
        this.maybeAdd(this.show_qualifiers_item);
        this.maybeAdd(this.show_products_item);
        this.addSeparator();
        this.maybeAdd(this.broadcast_item);
    }

    private static String getMenuName(DisplayComponent owner) {
        if (owner instanceof FeatureDisplay) {
            return "Feature Viewer JMenu";
        }
        return "Feature List JMenu";
    }

    private void maybeAdd(JMenuItem item) {
        if (item != null) {
            this.add(item);
        }
    }

    private void addGenericItems() {
        if (this.selection_features.size() > 0 || this.selection_segments.size() > 0) {
            // empty if block
        }
    }

    public void makeSubMenus() {
        JFrame frame = this.owner.getParentFrame();
        this.entry_group_menu_item = new EntryGroupMenu(frame, this.getEntryGroup());
        this.select_menu_item = new SelectMenu(frame, this.selection, this.getGotoEventSource(), this.getEntryGroup(), this.base_plot_group);
        this.view_menu_item = new ViewMenu(frame, this.selection, this.getGotoEventSource(), this.getEntryGroup(), this.base_plot_group);
        this.goto_menu_item = new GotoMenu(frame, this.selection, this.getGotoEventSource(), this.getEntryGroup());
        if (Options.readWritePossible()) {
            this.edit_menu_item = new EditMenu(frame, this.selection, this.getGotoEventSource(), this.getEntryGroup(), this.base_plot_group);
            if (this.entry_group instanceof SimpleEntryGroup) {
                this.add_menu_item = new AddMenu(frame, this.selection, this.getEntryGroup(), this.getGotoEventSource(), this.base_plot_group);
            }
            this.write_menu_item = new WriteMenu(frame, this.selection, this.getEntryGroup());
            if (Options.isUnixHost()) {
                this.run_menu_item = new RunMenu(frame, this.selection);
            }
        }
    }

    private void addFeatureDisplayItems() {
        this.show_start_codons_item = new JCheckBoxMenuItem("Start Codons");
        this.show_start_codons_item.setState(this.feature_display.getShowStartCodons());
        this.show_start_codons_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                FeaturePopup.this.feature_display.setShowStartCodons(FeaturePopup.this.show_start_codons_item.getState());
            }
        });
        this.show_stop_codons_item = new JCheckBoxMenuItem("Stop Codons");
        this.show_stop_codons_item.setState(this.feature_display.getShowStopCodons());
        this.show_stop_codons_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                FeaturePopup.this.feature_display.setShowStopCodons(FeaturePopup.this.show_stop_codons_item.getState());
            }
        });
        this.show_feature_arrows_item = new JCheckBoxMenuItem("Feature Arrows");
        this.show_feature_arrows_item.setState(this.feature_display.getShowFeatureArrows());
        this.show_feature_arrows_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                FeaturePopup.this.feature_display.setShowFeatureArrows(FeaturePopup.this.show_feature_arrows_item.getState());
            }
        });
        this.show_feature_borders_item = new JCheckBoxMenuItem("Feature Borders");
        this.show_feature_borders_item.setState(this.feature_display.getShowFeatureBorders());
        this.show_feature_borders_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                FeaturePopup.this.feature_display.setShowFeatureBorders(FeaturePopup.this.show_feature_borders_item.getState());
            }
        });
        this.show_labels_item = new JCheckBoxMenuItem("Feature Labels");
        this.show_labels_item.setState(this.feature_display.getShowLabels());
        this.show_labels_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_display.setShowLabels(FeaturePopup.this.show_labels_item.getState());
            }
        });
        this.one_line_per_entry_item = new JCheckBoxMenuItem("One Line Per Entry");
        this.one_line_per_entry_item.setState(this.feature_display.getOneLinePerEntryFlag());
        this.one_line_per_entry_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean new_state = FeaturePopup.this.one_line_per_entry_item.getState();
                if (new_state && FeaturePopup.this.getEntryGroup().size() > 8) {
                    FeaturePopup.this.feature_display.setShowLabels(false);
                }
                FeaturePopup.this.feature_display.setOneLinePerEntry(new_state);
            }
        });
        this.show_forward_frame_lines_item = new JCheckBoxMenuItem("Forward Frame Lines");
        this.show_forward_frame_lines_item.setState(this.feature_display.getShowForwardFrameLines());
        this.show_forward_frame_lines_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_display.setShowForwardFrameLines(FeaturePopup.this.show_forward_frame_lines_item.getState());
            }
        });
        this.show_reverse_frame_lines_item = new JCheckBoxMenuItem("Reverse Frame Lines");
        this.show_reverse_frame_lines_item.setState(this.feature_display.getShowReverseFrameLines());
        this.show_reverse_frame_lines_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_display.setShowReverseFrameLines(FeaturePopup.this.show_reverse_frame_lines_item.getState());
            }
        });
        this.frame_features_item = new JCheckBoxMenuItem("All Features On Frame Lines");
        this.frame_features_item.setState(this.feature_display.getFrameFeaturesFlag());
        this.frame_features_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_display.setFrameFeaturesFlag(FeaturePopup.this.frame_features_item.getState());
            }
        });
        this.source_features_item = new JCheckBoxMenuItem("Show Source Features");
        this.source_features_item.setState(this.feature_display.getShowSourceFeatures());
        this.source_features_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_display.setShowSourceFeatures(FeaturePopup.this.source_features_item.getState());
            }
        });
        this.rev_comp_display_item = new JCheckBoxMenuItem("Flip Display");
        this.rev_comp_display_item.setState(this.feature_display.isRevCompDisplay());
        this.rev_comp_display_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_display.setRevCompDisplay(FeaturePopup.this.rev_comp_display_item.getState());
            }
        });
        this.base_colours_item = new JCheckBoxMenuItem("Colourise Bases");
        this.base_colours_item.setState(this.feature_display.getShowBaseColours());
        this.base_colours_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_display.setShowBaseColours(FeaturePopup.this.base_colours_item.getState());
            }
        });
        this.smallest_to_front_item = new JMenuItem("Smallest Features In Front");
        this.smallest_to_front_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeaturePopup.this.selection.clear();
                FeaturePopup.this.feature_display.smallestToFront();
            }
        });
        this.score_cutoffs_item = new JMenuItem("Set Score Cutoffs ...");
        this.score_cutoffs_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScoreChangeListener minimum_listener = new ScoreChangeListener(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void scoreChanged(ScoreChangeEvent event) {
                        FeaturePopup.access$100(14.access$1500(this.this$1)).setMinimumScore(event.getValue());
                    }
                };
                ScoreChangeListener maximum_listener = new ScoreChangeListener(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void scoreChanged(ScoreChangeEvent event) {
                        FeaturePopup.access$100(14.access$1500(this.this$1)).setMaximumScore(event.getValue());
                    }
                };
                ScoreChanger score_changer = new ScoreChanger("Score Cutoffs", minimum_listener, maximum_listener, 0, 100);
                ((Component)score_changer).setVisible(true);
            }

            static /* synthetic */ FeaturePopup access$1500(14 x0) {
                return x0.FeaturePopup.this;
            }
        });
        if (this.selection_features.size() > 0 || this.selection_segments.size() > 0) {
            this.raise_feature_item = new JMenuItem("Raise Selected Features");
            this.raise_feature_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    FeaturePopup.this.raiseSelection();
                }
            });
            this.lower_feature_item = new JMenuItem("Lower Selected Features");
            this.lower_feature_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    FeaturePopup.this.lowerSelection();
                }
            });
        }
        if (!this.selection.isEmpty()) {
            this.zoom_to_selection_item = new JMenuItem("Zoom to Selection");
            this.zoom_to_selection_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    FeaturePopup.zoomToSelection((FeatureDisplay)FeaturePopup.this.owner);
                }
            });
        }
        this.select_visible_range = new JMenuItem("Select Visible Range");
        this.select_visible_range.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeaturePopup.this.selection.setMarkerRange(FeaturePopup.this.feature_display.getVisibleMarkerRange());
            }
        });
        this.select_visible_features = new JMenuItem("Select Visible Features");
        this.select_visible_features.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeaturePopup.this.selection.set(FeaturePopup.this.feature_display.getCurrentVisibleFeatures());
            }
        });
    }

    private void addFeatureListItems() {
        Options.getOptions();
        if (Options.readWritePossible()) {
            this.save_feature_list_item = new JMenuItem("Save List To File ...");
            this.save_feature_list_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FeaturePopup.this.saveFeatureList();
                }
            });
        }
        this.correlation_scores_item = new JCheckBoxMenuItem("Show Correlation Scores");
        this.correlation_scores_item.setState(this.feature_list.getCorrelationScores());
        this.correlation_scores_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_list.setCorrelationScores(FeaturePopup.this.correlation_scores_item.getState());
            }
        });
        this.show_genes_item = new JCheckBoxMenuItem("Show Gene Names");
        this.show_genes_item.setState(this.feature_list.getShowGenes());
        this.show_genes_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_list.setShowGenes(FeaturePopup.this.show_genes_item.getState());
            }
        });
        this.show_products_item = new JCheckBoxMenuItem("Show Products");
        this.show_products_item.setState(this.feature_list.getShowProducts());
        this.show_products_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (FeaturePopup.this.show_products_item.getState()) {
                    FeaturePopup.this.feature_list.setShowQualifiers(false);
                }
                FeaturePopup.this.feature_list.setShowProducts(FeaturePopup.this.show_products_item.getState());
            }
        });
        this.show_qualifiers_item = new JCheckBoxMenuItem("Show Qualifiers");
        this.show_qualifiers_item.setState(this.feature_list.getShowQualifiers());
        this.show_qualifiers_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePopup.this.feature_list.setShowQualifiers(FeaturePopup.this.show_qualifiers_item.getState());
                if (FeaturePopup.this.show_qualifiers_item.getState()) {
                    FeaturePopup.this.feature_list.setShowProducts(false);
                }
            }
        });
    }

    private void saveFeatureList() {
        YesNoDialog yes_no_dialog;
        JFrame frame = this.owner.getParentFrame();
        StickyFileChooser file_dialog = new StickyFileChooser();
        file_dialog.setDialogTitle("Choose save file ...");
        file_dialog.setDialogType(1);
        int status = file_dialog.showOpenDialog(frame);
        if (status != 0 || file_dialog.getSelectedFile() == null) {
            return;
        }
        File write_file = new File(file_dialog.getCurrentDirectory(), file_dialog.getSelectedFile().getName());
        if (write_file.exists() && !(yes_no_dialog = new YesNoDialog(frame, "this file exists: " + write_file + " overwrite it?")).getResult()) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(write_file));
            StringVector list_strings = this.feature_list.getListStrings();
            for (int i = 0; i < list_strings.size(); ++i) {
                writer.println(list_strings.elementAt(i));
            }
            writer.close();
        }
        catch (IOException e) {
            new MessageDialog(frame, "error while writing: " + e.getMessage());
        }
    }

    private void raiseSelection() {
        FeatureVector features_to_raise = this.selection.getAllFeatures();
        for (int i = 0; i < features_to_raise.size(); ++i) {
            Feature selection_feature = features_to_raise.elementAt(i);
            this.feature_display.raiseFeature(selection_feature);
        }
    }

    private void lowerSelection() {
        FeatureVector features_to_lower = this.selection.getAllFeatures();
        for (int i = 0; i < features_to_lower.size(); ++i) {
            Feature selection_feature = features_to_lower.elementAt(i);
            this.feature_display.lowerFeature(selection_feature);
        }
    }

    static void zoomToSelection(FeatureDisplay feature_display) {
        int last_base;
        int first_base;
        Selection selection = feature_display.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (feature_display.getEntryGroup().getSequenceLength() < 1000) {
            return;
        }
        FeatureSegmentVector segments = selection.getSelectedSegments();
        if (segments.size() == 1) {
            first_base = segments.elementAt(0).getFeature().getRawFirstBase();
            last_base = segments.elementAt(0).getFeature().getRawLastBase();
        } else {
            first_base = selection.getLowestBaseOfSelection().getRawPosition();
            last_base = selection.getHighestBaseOfSelection().getRawPosition();
        }
        first_base = first_base < 250 ? 250 : (first_base -= 250);
        feature_display.setFirstAndLastBase(first_base, last_base += 250);
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }

    public GotoEventSource getGotoEventSource() {
        return this.goto_event_source;
    }

    private MenuItem makeCheckboxMenuItem(String item_name) {
        if (Options.getOptions().isBuggyLinuxVM() && Options.getOptions().getPropertyTruthValue("buggy_linux_vm_fix")) {
            return new ArtemisCheckboxMenuItem(item_name);
        }
        return new CheckboxMenuItem(item_name);
    }

    private void addMenuItemListener(MenuItem menu_item, ItemListener listener) {
        if (menu_item instanceof ArtemisCheckboxMenuItem) {
            ((ArtemisCheckboxMenuItem)menu_item).addItemListener(listener);
        } else {
            ((CheckboxMenuItem)menu_item).addItemListener(listener);
        }
    }

    private void setCheckboxMenuItemState(MenuItem menu_item, boolean state) {
        if (menu_item instanceof ArtemisCheckboxMenuItem) {
            ((ArtemisCheckboxMenuItem)menu_item).setState(state);
        } else {
            ((CheckboxMenuItem)menu_item).setState(state);
        }
    }

    private boolean getCheckboxMenuItemState(MenuItem menu_item) {
        if (menu_item instanceof ArtemisCheckboxMenuItem) {
            return ((ArtemisCheckboxMenuItem)menu_item).getState();
        }
        return ((CheckboxMenuItem)menu_item).getState();
    }
}

