/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.FileFilter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.FileTree;
import uk.ac.sanger.artemis.util.StringVector;

public class FileManager
extends JFrame {
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);

    public FileManager(JFrame frame) {
        this(frame, FileManager.getArtemisFilter());
    }

    public FileManager(JFrame frame, FileFilter filter) {
        super("File Manager");
        FileTree ftree = new FileTree(new File(System.getProperty("user.dir")), frame, filter);
        JScrollPane jsp = new JScrollPane(ftree);
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)jsp, "Center");
        this.setJMenuBar(this.makeMenuBar(pane, ftree));
        pane.add((Component)this.getFileFileterComboBox(ftree), "South");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        jsp.setPreferredSize(new Dimension(210, (int)(screen.getHeight() / 2.0)));
        this.pack();
        int yloc = (int)((screen.getHeight() - (double)this.getHeight()) / 2.0);
        ((Component)this).setLocation(0, yloc);
        ((Component)this).setVisible(true);
    }

    protected JComboBox getFileFileterComboBox(final FileTree ftree) {
        String[] filters = new String[]{"Artemis Files", "Sequence Files", "Feature Files", "All Files"};
        final JComboBox<String> comboFilter = new JComboBox<String>(filters);
        comboFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String select = (String)comboFilter.getSelectedItem();
                if (select.equals("Artemis Files")) {
                    ftree.setFilter(FileManager.getArtemisFilter());
                } else if (select.equals("Sequence Files")) {
                    ftree.setFilter(FileManager.getSequenceFilter());
                } else if (select.equals("Feature Files")) {
                    ftree.setFilter(FileManager.getFeatureFilter());
                } else if (select.equals("All Files")) {
                    ftree.setFilter(new FileFilter(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean accept(File pathname) {
                            return !pathname.getName().startsWith(".");
                        }
                    });
                }
            }
        });
        return comboFilter;
    }

    protected static FileFilter getArtemisFilter() {
        final StringVector sequence_suffixes = Options.getOptions().getOptionValues("sequence_file_suffixes");
        final StringVector feature_suffixes = Options.getOptions().getOptionValues("feature_file_suffixes");
        FileFilter artemis_filter = new FileFilter(){

            public boolean accept(File pathname) {
                String suffix;
                int i;
                if (pathname.isDirectory() && !pathname.getName().startsWith(".")) {
                    return true;
                }
                for (i = 0; i < sequence_suffixes.size(); ++i) {
                    suffix = sequence_suffixes.elementAt(i);
                    if (!pathname.getName().endsWith("." + suffix) && !pathname.getName().endsWith("." + suffix + ".gz")) continue;
                    return true;
                }
                for (i = 0; i < feature_suffixes.size(); ++i) {
                    suffix = feature_suffixes.elementAt(i);
                    if (!pathname.getName().endsWith("." + suffix) && !pathname.getName().endsWith("." + suffix + ".gz")) continue;
                    return true;
                }
                return false;
            }
        };
        return artemis_filter;
    }

    protected static FileFilter getFeatureFilter() {
        final StringVector feature_suffixes = Options.getOptions().getOptionValues("feature_file_suffixes");
        FileFilter feature_filter = new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.getName().startsWith(".")) {
                    return true;
                }
                for (int i = 0; i < feature_suffixes.size(); ++i) {
                    String suffix = feature_suffixes.elementAt(i);
                    if (!pathname.getName().endsWith("." + suffix) && !pathname.getName().endsWith("." + suffix + ".gz")) continue;
                    return true;
                }
                return false;
            }
        };
        return feature_filter;
    }

    protected static FileFilter getSequenceFilter() {
        final StringVector sequence_suffixes = Options.getOptions().getOptionValues("sequence_file_suffixes");
        FileFilter seq_filter = new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.getName().startsWith(".")) {
                    return true;
                }
                for (int i = 0; i < sequence_suffixes.size(); ++i) {
                    String suffix = sequence_suffixes.elementAt(i);
                    if (!pathname.getName().endsWith("." + suffix) && !pathname.getName().endsWith("." + suffix + ".gz")) continue;
                    return true;
                }
                return false;
            }
        };
        return seq_filter;
    }

    private JMenuBar makeMenuBar(JPanel pane, final FileTree ftree) {
        JMenuBar mBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        mBar.add(fileMenu);
        JMenuItem fileMenuGoto = new JMenuItem("Go to Directory ...");
        fileMenuGoto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dir = ftree.getRoot().getAbsolutePath();
                String newDir = JOptionPane.showInputDialog(FileManager.this, "Go to Directory:", dir);
                if (newDir == null) {
                    return;
                }
                File newDirFile = new File(newDir = newDir.trim());
                if (newDirFile.exists() && newDirFile.canRead() && !newDir.equals(dir)) {
                    ftree.newRoot(newDir);
                } else {
                    String error = null;
                    if (!newDirFile.exists()) {
                        error = new String(newDir + " doesn't exist!");
                    } else if (!newDirFile.canRead()) {
                        error = new String(newDir + " cannot be read!");
                    } else if (newDir.equals(dir)) {
                        error = new String("Same directory!");
                    }
                    if (error != null) {
                        JOptionPane.showMessageDialog(FileManager.this, error, "Warning", 2);
                    }
                }
            }
        });
        fileMenu.add(fileMenuGoto);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuClose = new JMenuItem("Close");
        fileMenuClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)FileManager.this).setVisible(false);
            }
        });
        fileMenu.add(fileMenuClose);
        JToolBar toolBar = new JToolBar();
        Dimension buttonSize = new Dimension(22, 24);
        JButton upBt = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(0, 128, 0));
                float[][] loc1 = new float[][]{{11.0f, 18.0f}, {7.0f, 18.0f}, {7.0f, 14.0f}, {3.0f, 14.0f}, {11.0f, 4.0f}};
                g2.fill(FileManager.makeShape(loc1));
                g2.setColor(Color.green);
                float[][] loc2 = new float[][]{{11.0f, 18.0f}, {15.0f, 18.0f}, {15.0f, 14.0f}, {19.0f, 14.0f}, {11.0f, 4.0f}};
                g2.fill(FileManager.makeShape(loc2));
                this.setSize(22, 24);
            }
        };
        upBt.setPreferredSize(buttonSize);
        upBt.setMinimumSize(buttonSize);
        upBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileManager.this.setCursor(FileManager.this.cbusy);
                File root = ftree.getRoot();
                String parent = root.getParent();
                if (parent != null) {
                    ftree.newRoot(parent);
                }
                FileManager.this.setCursor(FileManager.this.cdone);
            }
        });
        toolBar.add(upBt);
        JButton shortCut1 = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                Font font = new Font("Monospaced", 1, 14);
                g2.setFont(font);
                g2.setColor(Color.black);
                g2.drawString("Y", 4, 18);
                g2.setColor(Color.red);
                g2.drawString("P", 10, 15);
                this.setSize(22, 24);
            }
        };
        shortCut1.setPreferredSize(buttonSize);
        shortCut1.setMinimumSize(buttonSize);
        shortCut1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ftree.newRoot("/nfs/disk222/yeastpub");
            }
        });
        if (new File("/nfs/disk222/yeastpub").exists()) {
            toolBar.add(shortCut1);
        }
        JButton shortCut2 = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                Font font = new Font("Monospaced", 1, 14);
                g2.setFont(font);
                g2.setColor(Color.black);
                g2.drawString("P", 4, 18);
                g2.setColor(Color.red);
                g2.drawString("D", 10, 15);
                this.setSize(22, 24);
            }
        };
        shortCut2.setPreferredSize(buttonSize);
        shortCut2.setMinimumSize(buttonSize);
        shortCut2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ftree.newRoot("/nfs/pathdata/");
            }
        });
        if (new File("/nfs/pathdata/").exists()) {
            toolBar.add(shortCut2);
        }
        JButton homeBt = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.blue);
                float[][] loc1 = new float[][]{{3.0f, 14.0f}, {11.0f, 3.0f}, {19.0f, 14.0f}, {17.0f, 14.0f}, {17.0f, 18.0f}, {5.0f, 18.0f}, {5.0f, 14.0f}};
                g2.fill(FileManager.makeShape(loc1));
                this.setSize(22, 24);
            }
        };
        homeBt.setPreferredSize(buttonSize);
        homeBt.setMinimumSize(buttonSize);
        homeBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ftree.newRoot(System.getProperty("user.home"));
            }
        });
        toolBar.add(homeBt);
        toolBar.add(Box.createVerticalStrut(35));
        pane.add((Component)toolBar, "North");
        return mBar;
    }

    public static GeneralPath makeShape(float[][] loc) {
        GeneralPath path = new GeneralPath(1);
        path.moveTo(loc[0][0], loc[0][1]);
        for (int i = 1; i < loc.length; ++i) {
            path.lineTo(loc[i][0], loc[i][1]);
        }
        return path;
    }
}

