/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Font;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;

public class KeyChoice
extends JPanel {
    private Key default_key = null;
    private JComboBox key_chooser = null;
    private JCheckBox common_keys_checkbox = null;
    private EntryInformation entry_information = null;

    public KeyChoice(EntryInformation entry_information) {
        this(entry_information, Key.CDS);
    }

    public KeyChoice(EntryInformation entry_information, Key default_key) {
        this.entry_information = entry_information;
        this.default_key = default_key;
        Font font = Options.getOptions().getFont();
        this.setFont(font);
        this.key_chooser = new JComboBox();
        int MAX_VISIBLE_ROWS = 30;
        this.key_chooser.setMaximumRowCount(30);
        this.updateChoice();
    }

    public Key getSelectedItem() {
        Key key = new Key((String)this.key_chooser.getSelectedItem());
        return key;
    }

    public void setKey(Key new_key) {
        int key_index = this.keyIndex(new_key);
        if (key_index == -1) {
            this.key_chooser.addItem(new_key.toString());
            this.key_chooser.setSelectedItem(new_key.toString());
        } else {
            this.key_chooser.setSelectedIndex(key_index);
        }
    }

    public void addItemListener(ItemListener l) {
        this.key_chooser.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.key_chooser.removeItemListener(l);
    }

    private void updateChoice() {
        this.removeAll();
        Font font = Options.getOptions().getFont();
        this.key_chooser.setFont(font);
        this.add(this.key_chooser);
        KeyVector keys = this.getSortedKeys();
        if (keys == null) {
            keys = new KeyVector();
            keys.add(Key.CDS);
        }
        for (int i = 0; i < keys.size(); ++i) {
            this.key_chooser.addItem(keys.elementAt(i).toString());
        }
        if (this.keyIndex(this.default_key) != -1) {
            this.setKey(this.default_key);
        }
        this.validate();
        if (this.getParent() != null) {
            this.getParent().validate();
            if (this.getParent().getParent() != null) {
                this.getParent().getParent().validate();
            }
        }
    }

    private KeyVector getSortedKeys() {
        return this.entry_information.getSortedValidKeys();
    }

    private int keyIndex(Key key) {
        for (int i = 0; i < this.key_chooser.getItemCount(); ++i) {
            if (!key.toString().equals((String)this.key_chooser.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }
}

