/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import uk.ac.sanger.artemis.ExternalProgram;
import uk.ac.sanger.artemis.ExternalProgramException;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.FileViewer;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProcessWatcher;
import uk.ac.sanger.artemis.util.Document;

public class SearchResultViewer
extends FileViewer {
    public SearchResultViewer(String label, final Document document) throws IOException {
        super(label);
        try {
            this.readFile(document.getReader());
        }
        catch (IOException e) {
            System.out.println("error while reading results: " + e);
            this.dispose();
            throw e;
        }
        if (!Options.getOptions().getPropertyTruthValue("sanger_options")) {
            return;
        }
        JButton to_browser = new JButton("Send to browser");
        this.getButtonPanel().add(to_browser);
        to_browser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    SearchResultViewer.sendToBrowser(document.toString());
                }
                catch (IOException e) {
                    System.out.println("error while reading results: " + e);
                    new MessageDialog((JFrame)SearchResultViewer.this, "Message", "Send to browser failed: " + e);
                }
                catch (ExternalProgramException e) {
                    System.out.println("error while reading results: " + e);
                    new MessageDialog((JFrame)SearchResultViewer.this, "Message", "Send to browser failed: " + e);
                }
            }
        });
    }

    public static void sendToBrowser(String file_name) throws IOException, ExternalProgramException {
        String[] arguments = new String[]{file_name};
        Process process = ExternalProgram.startProgram("../etc/results_to_netscape", arguments);
        new ProcessWatcher(process, "results_to_netscape", false);
    }
}

