/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureKeyPredicate;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.ChoiceFrame;
import uk.ac.sanger.artemis.components.KeyChooser;
import uk.ac.sanger.artemis.components.MarkerRangeRequester;
import uk.ac.sanger.artemis.components.MarkerRangeRequesterEvent;
import uk.ac.sanger.artemis.components.MarkerRangeRequesterListener;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.SelectionMenu;
import uk.ac.sanger.artemis.components.Selector;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.StringVector;

public class SelectMenu
extends SelectionMenu {
    static final KeyStroke SELECT_ALL_KEY = KeyStroke.getKeyStroke(65, 2);
    static final KeyStroke SELECT_NONE_KEY = KeyStroke.getKeyStroke(78, 2);
    private final int MAX_FEATURE_TO_SELECT_COUNT = 10000;
    private EntryGroup entry_group;
    private GotoEventSource goto_event_source;
    private JMenuItem selector_item = null;
    private JMenuItem all_item = null;
    private JMenuItem all_bases_item = null;
    private JMenuItem none_item = null;
    private JMenuItem selection_toggle_item = null;
    private JMenuItem select_same_type_item = null;
    private JMenuItem select_matching_qualifiers_item = null;
    private JMenuItem select_features_in_range_item = null;
    private JMenuItem select_base_range_item = null;
    private JMenuItem select_aa_range_in_feature_item = null;
    private JMenuItem select_orf_item = null;
    private JMenuItem select_by_key_item = null;
    private JMenuItem select_non_pseudo_cds_item = null;
    private JMenuItem select_all_cds_item = null;

    public SelectMenu(JFrame frame, final Selection selection, final GotoEventSource goto_event_source, EntryGroup entry_group, final BasePlotGroup base_plot_group, String menu_name) {
        super(frame, menu_name, selection);
        this.entry_group = entry_group;
        this.goto_event_source = goto_event_source;
        this.selector_item = new JMenuItem("Feature Selector ...");
        this.selector_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new Selector(selection, goto_event_source, SelectMenu.this.getEntryGroup(), base_plot_group);
            }
        });
        this.add(this.selector_item);
        this.addSeparator();
        this.all_item = new JMenuItem("All");
        this.all_item.setAccelerator(SELECT_ALL_KEY);
        this.all_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectAll();
            }
        });
        this.add(this.all_item);
        this.all_bases_item = new JMenuItem("All Bases");
        this.all_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectAllBases();
            }
        });
        this.add(this.all_bases_item);
        this.none_item = new JMenuItem("None");
        this.none_item.setAccelerator(SELECT_NONE_KEY);
        this.none_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.clearSelection();
            }
        });
        this.add(this.none_item);
        this.select_by_key_item = new JMenuItem("By Key");
        this.select_by_key_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectByKeyPopup();
            }
        });
        this.add(this.select_by_key_item);
        this.select_non_pseudo_cds_item = new JMenuItem("CDS Features without /pseudo");
        this.select_non_pseudo_cds_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FeatureKeyQualifierPredicate predicate = new FeatureKeyQualifierPredicate(Key.CDS, "pseudo", false);
                SelectMenu.this.clearSelection();
                SelectMenu.this.selectFeaturesByPredicate(predicate);
            }
        });
        this.add(this.select_non_pseudo_cds_item);
        this.select_all_cds_item = new JMenuItem("All CDS Features");
        this.select_all_cds_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FeatureKeyPredicate predicate = new FeatureKeyPredicate(Key.CDS);
                SelectMenu.this.clearSelection();
                SelectMenu.this.selectFeaturesByPredicate(predicate);
            }
        });
        this.add(this.select_all_cds_item);
        this.select_same_type_item = new JMenuItem("Same Key");
        this.select_same_type_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectSameKey();
            }
        });
        this.add(this.select_same_type_item);
        this.select_matching_qualifiers_item = new JMenuItem("Features Matching Qualifier");
        this.select_matching_qualifiers_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectMatchingQualifiers();
            }
        });
        this.add(this.select_matching_qualifiers_item);
        this.select_orf_item = new JMenuItem("Open Reading Frame");
        this.select_orf_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectOrf();
            }
        });
        this.add(this.select_orf_item);
        this.select_features_in_range_item = new JMenuItem("Features Overlapping Selection");
        this.select_features_in_range_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectOverlappingFeatures();
            }
        });
        this.add(this.select_features_in_range_item);
        this.select_base_range_item = new JMenuItem("Base Range ...");
        this.select_base_range_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectBaseRange();
            }
        });
        this.add(this.select_base_range_item);
        this.select_aa_range_in_feature_item = new JMenuItem("Feature AA Range ...");
        this.select_aa_range_in_feature_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.selectFeatureAARange();
            }
        });
        this.add(this.select_aa_range_in_feature_item);
        this.addSeparator();
        this.selection_toggle_item = new JMenuItem("Toggle Selection");
        this.selection_toggle_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectMenu.this.toggleSelection();
            }
        });
        this.add(this.selection_toggle_item);
    }

    public SelectMenu(JFrame frame, Selection selection, GotoEventSource goto_event_source, EntryGroup entry_group, BasePlotGroup base_plot_group) {
        this(frame, selection, goto_event_source, entry_group, base_plot_group, "Select");
    }

    private void selectAll() {
        YesNoDialog dialog;
        if (this.getEntryGroup().getAllFeaturesCount() > 10000 && !(dialog = new YesNoDialog(this.getParentFrame(), "Are you sure you want to select " + this.getEntryGroup().getAllFeaturesCount() + " features?")).getResult()) {
            return;
        }
        FeatureVector all_features = this.getEntryGroup().getAllFeatures();
        if (this.getEntryGroup() instanceof SimpleEntryGroup) {
            this.getSelection().set(all_features);
        } else {
            this.clearSelection();
            this.getSelection().add(all_features);
        }
    }

    private void selectAllBases() {
        try {
            Strand strand = this.getEntryGroup().getBases().getForwardStrand();
            MarkerRange new_range = strand.makeMarkerRangeFromPositions(1, strand.getSequenceLength());
            this.getSelection().setMarkerRange(new_range);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    private void clearSelection() {
        if (this.getEntryGroup() instanceof SimpleEntryGroup) {
            this.getSelection().clear();
        } else {
            this.getSelection().setMarkerRange(null);
            FeatureEnumeration test_enumerator = this.getEntryGroup().features();
            while (test_enumerator.hasMoreFeatures()) {
                Feature this_feature = test_enumerator.nextFeature();
                this.getSelection().remove(this_feature);
                this.getSelection().removeSegmentsOf(this_feature);
            }
        }
    }

    private void toggleSelection() {
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        FeatureVector all_features = this.getEntryGroup().getAllFeatures();
        FeatureVector new_selection = new FeatureVector();
        for (int i = 0; i < all_features.size(); ++i) {
            Feature this_feature = all_features.elementAt(i);
            if (selected_features.contains(this_feature)) continue;
            new_selection.add(this_feature);
        }
        this.clearSelection();
        this.getSelection().add(new_selection);
    }

    private void selectByKeyPopup() {
        EntryInformation default_entry_information = Options.getArtemisEntryInformation();
        final KeyChooser key_chooser = new KeyChooser(default_entry_information, new Key("misc_feature"));
        key_chooser.getKeyChoice().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                SelectMenu.this.selectByKey(key_chooser.getKeyChoice().getSelectedItem());
                ((Component)key_chooser).setVisible(false);
                key_chooser.dispose();
            }
        });
        key_chooser.getOKButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                SelectMenu.this.selectByKey(key_chooser.getKeyChoice().getSelectedItem());
                ((Component)key_chooser).setVisible(false);
                key_chooser.dispose();
            }
        });
        ((Component)key_chooser).setVisible(true);
    }

    private void selectByKey(Key key) {
        FeatureKeyPredicate predicate = new FeatureKeyPredicate(key);
        this.selectFeaturesByPredicate(predicate);
    }

    private void selectByQualifier(Key key, String name, String value) {
        FeatureKeyQualifierPredicate predicate = new FeatureKeyQualifierPredicate(key, name, value);
        this.selectFeaturesByPredicate(predicate);
    }

    private void selectSameKey() {
        int i;
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        KeyVector seen_keys = new KeyVector();
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        for (i = 0; i < selected_features.size(); ++i) {
            Feature current_feature = selected_features.elementAt(i);
            if (seen_keys.contains(current_feature.getKey())) continue;
            seen_keys.add(current_feature.getKey());
        }
        this.clearSelection();
        for (i = 0; i < seen_keys.size(); ++i) {
            this.selectByKey(seen_keys.elementAt(i));
        }
    }

    private void selectMatchingQualifiers() {
        if (!SelectionMenu.checkForSelectionFeatures(this.getParentFrame(), this.getSelection())) {
            return;
        }
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        if (selected_features.size() > 1) {
            new MessageDialog(this.getParentFrame(), "select only one feature");
            return;
        }
        Feature selected_feature = selected_features.elementAt(0);
        StringVector qualifier_names = Feature.getAllQualifierNames(selected_features);
        if (qualifier_names.size() == 0) {
            new MessageDialog(this.getParentFrame(), "feature has no qualifiers");
            return;
        }
        ChoiceFrame name_choice_frame = new ChoiceFrame("Select a qualifier name ...", qualifier_names);
        JComboBox name_choice = name_choice_frame.getChoice();
        class SelectListener
        implements ActionListener,
        ItemListener {
            private final /* synthetic */ Feature val$selected_feature;
            private final /* synthetic */ JComboBox val$name_choice;
            private final /* synthetic */ ChoiceFrame val$name_choice_frame;

            SelectListener(Feature val$selected_feature, JComboBox val$name_choice, ChoiceFrame val$name_choice_frame) {
                this.val$selected_feature = val$selected_feature;
                this.val$name_choice = val$name_choice;
                this.val$name_choice_frame = val$name_choice_frame;
            }

            public void doStuff() {
                SelectMenu.this.selectMatchingQualifiersHelper(this.val$selected_feature, (String)this.val$name_choice.getSelectedItem());
                ((Component)this.val$name_choice_frame).setVisible(false);
                this.val$name_choice_frame.dispose();
            }

            public void itemStateChanged(ItemEvent _) {
                this.doStuff();
                this.val$name_choice.removeItemListener(this);
            }

            public void actionPerformed(ActionEvent _) {
                this.doStuff();
                this.val$name_choice_frame.getOKButton().removeActionListener(this);
            }
        }
        SelectListener listener = new SelectListener(selected_feature, name_choice, name_choice_frame);
        name_choice.addItemListener(listener);
        name_choice_frame.getOKButton().addActionListener(listener);
        ((Component)name_choice_frame).setVisible(true);
    }

    private void selectMatchingQualifiersHelper(Feature feature, final String name) {
        Qualifier qualifier;
        try {
            qualifier = feature.getQualifierByName(name);
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        if (qualifier == null) {
            throw new Error("internal error - unexpected null reference");
        }
        StringVector qualifier_values = qualifier.getValues();
        if (qualifier_values.size() == 0) {
            new MessageDialog(this.getParentFrame(), "qualifier " + name + " has no values in ");
            return;
        }
        if (qualifier_values.size() == 1) {
            this.selectByQualifier(null, name, qualifier_values.elementAt(0));
        } else {
            final ChoiceFrame value_choice_frame = new ChoiceFrame("Select a qualifier value", qualifier_values);
            final JComboBox value_choice = value_choice_frame.getChoice();
            value_choice.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent _) {
                    SelectMenu.this.selectByQualifier(null, name, (String)value_choice.getSelectedItem());
                    ((Component)value_choice_frame).setVisible(false);
                    value_choice_frame.dispose();
                }
            });
            value_choice_frame.getOKButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent _) {
                    SelectMenu.this.selectByQualifier(null, name, (String)value_choice.getSelectedItem());
                    ((Component)value_choice_frame).setVisible(false);
                    value_choice_frame.dispose();
                }
            });
            ((Component)value_choice_frame).setVisible(true);
        }
    }

    private void selectFeaturesByPredicate(FeaturePredicate predicate) {
        FeatureVector new_selection_features = new FeatureVector();
        FeatureEnumeration feature_enum = this.getEntryGroup().features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            if (!predicate.testPredicate(current_feature)) continue;
            new_selection_features.add(current_feature);
        }
        this.clearSelection();
        this.getSelection().add(new_selection_features);
    }

    private void selectOrf() {
        Marker end_marker;
        if (!this.checkForSelectionRange()) {
            return;
        }
        MarkerRange range = this.getSelection().getMarkerRange();
        Strand strand = this.getEntryGroup().getBases().getForwardStrand();
        MarkerRange start_orf_range = Strand.getORFAroundMarker(range.getStart(), true);
        try {
            int start_end_diff = range.getCount() - 1;
            int mod_length = start_end_diff - start_end_diff % 3;
            end_marker = range.getStart().moveBy(mod_length);
        }
        catch (OutOfRangeException e) {
            end_marker = range.getStart();
        }
        MarkerRange end_orf_range = Strand.getORFAroundMarker(end_marker, true);
        MarkerRange new_range = range;
        if (start_orf_range != null) {
            new_range = new_range.extendRange(start_orf_range);
        }
        if (end_orf_range != null) {
            new_range = new_range.extendRange(end_orf_range);
        }
        if (start_orf_range == null && end_orf_range == null && range.getCount() <= 6) {
            new MessageDialog(this.getParentFrame(), "there is no open reading frame at the selected bases");
            return;
        }
        this.getSelection().setMarkerRange(new_range);
    }

    private void selectBaseRange() {
        MarkerRangeRequester range_requester = new MarkerRangeRequester("enter a range of bases (eg. 100..200):", 18, "");
        MarkerRangeRequesterListener listener = new MarkerRangeRequesterListener(){

            public void actionPerformed(MarkerRangeRequesterEvent event) {
                MarkerRange marker_range = event.getMarkerRange(SelectMenu.this.getEntryGroup().getBases());
                SelectMenu.this.getSelection().setMarkerRange(marker_range);
                SelectMenu.this.makeBaseVisible(SelectMenu.this.getSelection().getStartBaseOfSelection());
            }
        };
        range_requester.addMarkerRangeRequesterListener(listener);
        ((Component)range_requester).setVisible(true);
    }

    private void selectFeatureAARange() {
        if (!SelectionMenu.checkForSelectionFeatures(this.getParentFrame(), this.getSelection())) {
            return;
        }
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        if (selected_features.size() > 1) {
            new MessageDialog(this.getParentFrame(), "select only one feature");
            return;
        }
        final Feature selected_feature = selected_features.elementAt(0);
        MarkerRangeRequester range_requester = new MarkerRangeRequester("enter a range of amino acids (eg. 100..200):", 18, "");
        MarkerRangeRequesterListener listener = new MarkerRangeRequesterListener(){

            public void actionPerformed(MarkerRangeRequesterEvent event) {
                Range range = event.getRawRange();
                if (range == null) {
                    return;
                }
                int start_position = range.getStart();
                int end_position = range.getEnd();
                int start_pos_in_feature = (start_position - 1) * 3 + 1;
                int end_pos_in_feature = (end_position - 1) * 3 + 3;
                try {
                    Marker start_marker = selected_feature.getPositionInSequence(start_pos_in_feature);
                    Marker end_marker = selected_feature.getPositionInSequence(end_pos_in_feature);
                    MarkerRange marker_range = new MarkerRange(start_marker.getStrand(), start_marker.getPosition(), end_marker.getPosition());
                    SelectMenu.this.getSelection().setMarkerRange(marker_range);
                    SelectMenu.this.makeBaseVisible(SelectMenu.this.getSelection().getStartBaseOfSelection());
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(SelectMenu.this.getParentFrame(), "amino acid range is out of range for this feature");
                }
            }
        };
        range_requester.addMarkerRangeRequesterListener(listener);
        ((Component)range_requester).setVisible(true);
    }

    private void selectOverlappingFeatures() {
        MarkerRange selected_marker_range = this.getSelection().getMarkerRange();
        if (selected_marker_range == null) {
            int i;
            FeatureVector selected_features = this.getSelection().getAllFeatures();
            if (selected_features.size() == 0) {
                new MessageDialog(this.getParentFrame(), "nothing selected");
                return;
            }
            FeatureVector new_selection = new FeatureVector();
            for (i = 0; i < selected_features.size(); ++i) {
                Feature this_feature = selected_features.elementAt(i);
                Range this_feature_raw_range = this_feature.getMaxRawRange();
                try {
                    FeatureVector overlapping_features = this.getEntryGroup().getFeaturesInRange(this_feature_raw_range);
                    for (int overlapping_feature_index = 0; overlapping_feature_index < overlapping_features.size(); ++overlapping_feature_index) {
                        Feature overlapping_feature = overlapping_features.elementAt(overlapping_feature_index);
                        if (new_selection.contains(overlapping_feature)) continue;
                        new_selection.add(overlapping_feature);
                    }
                    continue;
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
            for (i = 0; i < selected_features.size(); ++i) {
                new_selection.remove(selected_features.elementAt(i));
            }
            this.getSelection().set(new_selection);
        } else {
            try {
                Range raw_range = selected_marker_range.getRawRange();
                this.getSelection().set(this.getEntryGroup().getFeaturesInRange(raw_range));
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
    }

    private void makeBaseVisible(Marker base_marker) {
        this.goto_event_source.gotoBase(base_marker);
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }
}

