/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.components.FileViewer;
import uk.ac.sanger.artemis.components.SelectionInfoDisplay;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.util.StringVector;

public class SelectionViewer
implements SelectionChangeListener,
EntryGroupChangeListener {
    private final Selection selection;
    private final FileViewer file_viewer = new FileViewer("Artemis Selection View");
    final EntryGroup entry_group;

    public SelectionViewer(Selection selection, EntryGroup entry_group) {
        this.selection = selection;
        this.entry_group = entry_group;
        this.readSelection();
        selection.addSelectionChangeListener(this);
        this.file_viewer.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                SelectionViewer.this.stopListening();
            }
        });
        entry_group.addEntryGroupChangeListener(this);
    }

    public void stopListening() {
        this.selection.removeSelectionChangeListener(this);
        this.entry_group.removeEntryGroupChangeListener(this);
    }

    public void selectionChanged(SelectionChangeEvent event) {
        this.readSelection();
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 6: {
                this.entry_group.removeEntryGroupChangeListener(this);
                this.file_viewer.dispose();
            }
        }
    }

    public void readSelection() {
        int display_residues_count;
        int display_base_count;
        String base_selection_text = SelectionInfoDisplay.markerRangeText(this.selection, this.entry_group);
        FeatureVector selection_features = this.selection.getAllFeatures();
        StringBuffer buffer = new StringBuffer();
        int MAX_FEATURES = 50;
        if (selection_features.size() > 50) {
            buffer.append("first 50 features:\n\n");
        }
        for (int i = 0; i < selection_features.size() && i < 50; ++i) {
            buffer.append(selection_features.elementAt(i).toString());
        }
        if (selection_features.size() > 0) {
            buffer.append("\n");
        }
        if (base_selection_text != null && base_selection_text.length() > 0) {
            buffer.append(base_selection_text).append("\n\n");
        }
        if (selection_features.size() == 0) {
            display_base_count = 2000;
            display_residues_count = 1000;
        } else {
            display_base_count = 600;
            display_residues_count = 300;
        }
        String selection_bases = this.selection.getSelectedBases();
        if (selection_bases != null && selection_bases.length() > 0) {
            StringVector base_summary = SelectionViewer.getBaseSummary(selection_bases);
            for (int i = 0; i < base_summary.size(); ++i) {
                buffer.append(base_summary.elementAt(i)).append("\n");
            }
        }
        if (selection_features.size() == 1) {
            double score = selection_features.elementAt(0).get12CorrelationScore();
            score = (double)Math.round(score * 100.0) / 100.0;
            buffer.append("\nCorrelation score of the selected feature: " + score + "\n");
        }
        buffer.append("\n");
        if (selection_features.size() > 1) {
            double correlation_score_total = 0.0;
            double max_gc_content = -999.0;
            double min_gc_content = 999.0;
            double max_correlation_score = -999999.0;
            double min_correlation_score = 999999.0;
            for (int i = 0; i < selection_features.size(); ++i) {
                Feature this_feature = selection_features.elementAt(i);
                double correlation_score = this_feature.get12CorrelationScore();
                double gc_content = this_feature.getPercentGC();
                correlation_score_total += correlation_score;
                if (min_correlation_score > correlation_score) {
                    min_correlation_score = correlation_score;
                }
                if (max_correlation_score < correlation_score) {
                    max_correlation_score = correlation_score;
                }
                if (min_gc_content > gc_content) {
                    min_gc_content = gc_content;
                }
                if (!(max_gc_content < gc_content)) continue;
                max_gc_content = gc_content;
            }
            min_gc_content = (double)Math.round(min_gc_content * 100.0) / 100.0;
            max_gc_content = (double)Math.round(max_gc_content * 100.0) / 100.0;
            min_correlation_score = (double)Math.round(min_correlation_score * 100.0) / 100.0;
            max_correlation_score = (double)Math.round(max_correlation_score * 100.0) / 100.0;
            double correlation_score_average = (double)Math.round(correlation_score_total / (double)selection_features.size() * 100.0) / 100.0;
            buffer.append("Average correlation score of the selected features: " + correlation_score_average + "\n\n");
            buffer.append("Min GC percentage of the selected features: " + min_gc_content + "\n");
            buffer.append("Max GC percentage of the selected features: " + max_gc_content + "\n");
            buffer.append("\n");
            buffer.append("Min correlation score of the selected features: " + min_correlation_score + "\n");
            buffer.append("Max correlation score of the selected features: " + max_correlation_score + "\n");
            buffer.append("\n");
        }
        if (selection_bases.length() > 0 && selection_features.size() <= 1) {
            if (selection_bases.length() > display_base_count) {
                buffer.append("first " + display_base_count / 2 + " bases of selection:\n");
                String start_sub_string = selection_bases.substring(0, display_base_count / 2);
                buffer.append(start_sub_string).append("\n\n");
                buffer.append("last " + display_base_count / 2 + " bases of selection:\n");
                String sub_string = selection_bases.substring(selection_bases.length() - display_base_count / 2);
                buffer.append(sub_string).append("\n\n");
            } else {
                buffer.append("bases of selection:\n");
                buffer.append(selection_bases).append("\n\n");
            }
            if (selection_bases.length() >= 3) {
                int residues_to_display;
                if (selection_bases.length() / 3 < display_residues_count) {
                    residues_to_display = selection_bases.length() / 3;
                    buffer.append("translation of the selected bases:\n");
                } else {
                    residues_to_display = display_residues_count;
                    buffer.append("translation of the first " + display_residues_count * 3 + " selected bases:\n");
                }
                String residue_bases = selection_bases.substring(0, residues_to_display * 3);
                String residues = AminoAcidSequence.getTranslation(residue_bases, true).toString();
                buffer.append(residues.toUpperCase()).append("\n\n");
            }
        }
        this.file_viewer.setText(buffer.toString());
    }

    public static StringVector getBaseSummary(String bases) {
        int i;
        if (bases == null || bases.length() == 0) {
            return null;
        }
        StringVector return_vector = new StringVector();
        long[] counts = new long[257];
        for (i = 0; i < bases.length(); ++i) {
            char this_char = bases.charAt(i);
            if (this_char > '\u00ff') {
                counts[256] = counts[256] + 1L;
                continue;
            }
            char c = this_char;
            counts[c] = counts[c] + 1L;
        }
        for (i = 0; i < 256; ++i) {
            if (counts[i] <= 0L) continue;
            return_vector.add(new String(Character.toUpperCase((char)i) + " content: " + counts[i] + "  (" + (double)(10000L * counts[i] / (long)bases.length()) / 100.0 + "%)"));
        }
        long non_ambiguous_base_count = counts[103] + counts[99] + counts[97] + counts[116];
        if (non_ambiguous_base_count == (long)bases.length()) {
            return_vector.add("(no ambiguous bases)");
        }
        return_vector.add("");
        return_vector.add(new String("GC percentage: " + (double)Math.round(100.0 * (double)(counts[103] + counts[99]) / (double)bases.length() * 100.0) / 100.0));
        if (non_ambiguous_base_count > 0L && non_ambiguous_base_count < (long)bases.length()) {
            return_vector.add(new String("GC percentage of non-ambiguous bases: " + (double)Math.round(100.0 * (double)(counts[103] + counts[99]) / (double)non_ambiguous_base_count * 100.0) / 100.0));
        }
        return return_vector;
    }
}

