/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.ExternalProgram;
import uk.ac.sanger.artemis.ExternalProgramException;
import uk.ac.sanger.artemis.ExternalProgramVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureKeyPredicate;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.EntryGroupInfoDisplay;
import uk.ac.sanger.artemis.components.FeatureAminoAcidViewer;
import uk.ac.sanger.artemis.components.FeatureBaseViewer;
import uk.ac.sanger.artemis.components.FeatureInfo;
import uk.ac.sanger.artemis.components.FeatureListFrame;
import uk.ac.sanger.artemis.components.FeaturePlotGroup;
import uk.ac.sanger.artemis.components.FeatureViewer;
import uk.ac.sanger.artemis.components.KeyChooser;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.SearchResultViewer;
import uk.ac.sanger.artemis.components.SelectionMenu;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.components.SequenceViewer;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.StringVector;

public class ViewMenu
extends SelectionMenu {
    static final KeyStroke PLOT_FEATURES_KEY = KeyStroke.getKeyStroke(87, 2);
    public static final int PLOT_FEATURES_KEY_CODE = 87;
    static final KeyStroke VIEW_FEATURES_KEY = KeyStroke.getKeyStroke(86, 2);
    public static final int VIEW_FEATURES_KEY_CODE = 86;
    static final KeyStroke OVERVIEW_KEY = KeyStroke.getKeyStroke(79, 2);
    public static final int OVERVIEW_KEY_CODE = 79;
    static final KeyStroke FASTA_IN_BROWSER_KEY = KeyStroke.getKeyStroke(70, 2);
    public static final int FASTA_IN_BROWSER_KEY_CODE = 70;
    static final KeyStroke VIEW_FASTA_KEY = KeyStroke.getKeyStroke(82, 2);
    public static final int VIEW_FASTA_KEY_CODE = 82;
    static final KeyStroke BLASTP_IN_BROWSER_KEY = KeyStroke.getKeyStroke(66, 2);
    public static final int BLASTP_IN_BROWSER_KEY_CODE = 66;
    static final KeyStroke VIEW_BLASTP_KEY = KeyStroke.getKeyStroke(192, 2);
    public static final int VIEW_BLASTP_KEY_CODE = 192;
    static final KeyStroke VIEW_HTH_KEY = KeyStroke.getKeyStroke(72, 2);
    public static final int VIEW_HTH_KEY_CODE = 72;
    private static final int MAXIMUM_SELECTED_FEATURES = 25;
    private JMenuItem feature_info_item = null;
    private JMenuItem plot_features_item = null;
    private JMenuItem view_feature_item = null;
    private JMenuItem view_selection_item = null;
    private JMenuItem view_fasta_item = null;
    private JMenuItem view_bases_item = null;
    private JMenuItem view_bases_as_fasta_item = null;
    private JMenuItem view_aa_item = null;
    private JMenuItem view_aa_as_fasta_item = null;
    private JMenuItem overview_item = null;
    private JMenuItem forward_overview_item = null;
    private JMenuItem reverse_overview_item = null;
    private JMenuItem view_cds_item = null;
    private EntryGroup entry_group = null;
    private Selection selection = null;
    private GotoEventSource goto_event_source = null;
    private BasePlotGroup base_plot_group;

    public ViewMenu(JFrame frame, final Selection selection, final GotoEventSource goto_event_source, final EntryGroup entry_group, final BasePlotGroup base_plot_group, String menu_name) {
        super(frame, menu_name, selection);
        JMenuItem new_menu;
        String external_program_name;
        int i;
        this.entry_group = entry_group;
        this.selection = selection;
        this.goto_event_source = goto_event_source;
        this.base_plot_group = base_plot_group;
        this.plot_features_item = new JMenuItem("Show Feature Plots");
        this.plot_features_item.setAccelerator(PLOT_FEATURES_KEY);
        this.plot_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.plotSelectedFeatures(ViewMenu.this.getParentFrame(), ViewMenu.this.getSelection());
            }
        });
        this.view_feature_item = new JMenuItem("View Selected Features");
        this.view_feature_item.setAccelerator(VIEW_FEATURES_KEY);
        this.view_feature_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.viewSelectedFeatures(ViewMenu.this.getParentFrame(), ViewMenu.this.getSelection());
            }
        });
        this.view_selection_item = new JMenuItem("View Selection");
        this.view_selection_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new SelectionViewer(ViewMenu.this.getSelection(), entry_group);
            }
        });
        this.feature_info_item = new JMenuItem("Show Feature Statistics");
        this.feature_info_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.viewSelectedFeatureInfo();
            }
        });
        this.view_bases_item = new JMenuItem("View Bases Of Selection");
        this.view_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.viewSelectedBases(true);
            }
        });
        this.view_bases_as_fasta_item = new JMenuItem("View Bases Of Selection As FASTA");
        this.view_bases_as_fasta_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.viewSelectedBases(false);
            }
        });
        this.view_aa_item = new JMenuItem("View Amino Acids Of Selection");
        this.view_aa_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.viewSelectedAminoAcids(true);
            }
        });
        this.view_aa_as_fasta_item = new JMenuItem("View Amino Acids Of Selection As FASTA");
        this.view_aa_as_fasta_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.viewSelectedAminoAcids(false);
            }
        });
        this.overview_item = new JMenuItem("Show Overview");
        this.overview_item.setAccelerator(OVERVIEW_KEY);
        this.overview_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new EntryGroupInfoDisplay(ViewMenu.this.getParentFrame(), entry_group);
            }
        });
        this.forward_overview_item = new JMenuItem("Show Forward Strand Overview");
        this.forward_overview_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new EntryGroupInfoDisplay(ViewMenu.this.getParentFrame(), entry_group, 1);
            }
        });
        this.reverse_overview_item = new JMenuItem("Show Reverse Strand Overview");
        this.reverse_overview_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new EntryGroupInfoDisplay(ViewMenu.this.getParentFrame(), entry_group, 2);
            }
        });
        this.view_cds_item = new JMenuItem("Show CDS Genes And Products");
        this.view_cds_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FeatureKeyPredicate feature_predicate = new FeatureKeyPredicate(Key.CDS);
                String filter_name = "CDS features (filtered from: " + ViewMenu.this.getParentFrame().getTitle() + ")";
                FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
                FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_event_source, filtered_entry_group, base_plot_group);
                feature_list_frame.getFeatureList().setShowGenes(true);
                feature_list_frame.getFeatureList().setShowProducts(true);
                ((Component)feature_list_frame).setVisible(true);
            }
        });
        JMenu search_results_menu = null;
        search_results_menu = new JMenu("Search Results");
        boolean sanger_options = Options.getOptions().getPropertyTruthValue("sanger_options");
        ExternalProgramVector external_programs = Options.getOptions().getExternalPrograms();
        StringVector external_program_names = new StringVector();
        for (i = 0; i < external_programs.size(); ++i) {
            ExternalProgram external_program = external_programs.elementAt(i);
            String new_name = external_program.getName();
            if (external_program_names.contains(new_name)) continue;
            external_program_names.add(new_name);
        }
        for (i = 0; i < external_program_names.size(); ++i) {
            external_program_name = external_program_names.elementAt(i);
            new_menu = this.makeSearchResultsMenu(external_program_name, false, sanger_options);
            search_results_menu.add(new_menu);
        }
        if (sanger_options) {
            search_results_menu.addSeparator();
            for (i = 0; i < external_program_names.size(); ++i) {
                external_program_name = external_program_names.elementAt(i);
                new_menu = this.makeSearchResultsMenu(external_program_name, true, sanger_options);
                search_results_menu.add(new_menu);
            }
        }
        int MAX_FILTER_FEATURE_COUNT = 10000;
        JMenu feature_filters_menu = new JMenu("Feature Filters");
        JMenuItem bad_start_codons_item = new JMenuItem("Suspicious Start Codons ...");
        bad_start_codons_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showBadStartCodons(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem bad_stop_codons_item = new JMenuItem("Suspicious Stop Codons ...");
        bad_stop_codons_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showBadStopCodons(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem stop_codons_in_translation = new JMenuItem("Stop Codons In Translation ...");
        stop_codons_in_translation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showStopsInTranslation(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem bad_feature_keys_item = new JMenuItem("Non EMBL Keys ...");
        bad_feature_keys_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showNonEMBLKeys(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem duplicated_keys_item = new JMenuItem("Duplicated Features ...");
        duplicated_keys_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showDuplicatedFeatures(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem overlapping_cds_features_item = new JMenuItem("Overlapping CDS Features ...");
        overlapping_cds_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showOverlappingCDSs(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem same_stop_cds_features_item = new JMenuItem("CDSs Sharing Stop Codons ...");
        same_stop_cds_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showFeaturesWithSameStopCodons(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem missing_qualifier_features_item = new JMenuItem("Features Missing Required Qualifiers ...");
        missing_qualifier_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showMissingQualifierFeatures(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem filter_by_key_item = new JMenuItem("Filter By Key ...");
        filter_by_key_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ViewMenu.this.checkEntryGroupSize(10000)) {
                    ViewMenu.showFilterByKey(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
                }
            }
        });
        JMenuItem filter_by_selection_item = new JMenuItem("Selected Features ...");
        filter_by_selection_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.showFilterBySelection(ViewMenu.this.getParentFrame(), selection, entry_group, goto_event_source, base_plot_group);
            }
        });
        feature_filters_menu.add(bad_start_codons_item);
        feature_filters_menu.add(bad_stop_codons_item);
        feature_filters_menu.add(stop_codons_in_translation);
        feature_filters_menu.add(bad_feature_keys_item);
        feature_filters_menu.add(duplicated_keys_item);
        feature_filters_menu.add(overlapping_cds_features_item);
        feature_filters_menu.add(same_stop_cds_features_item);
        feature_filters_menu.add(missing_qualifier_features_item);
        feature_filters_menu.addSeparator();
        feature_filters_menu.add(filter_by_key_item);
        feature_filters_menu.add(filter_by_selection_item);
        this.add(this.view_feature_item);
        this.add(this.view_selection_item);
        this.addSeparator();
        if (search_results_menu != null) {
            this.add(search_results_menu);
        }
        this.add(this.view_cds_item);
        this.add(feature_filters_menu);
        this.addSeparator();
        this.add(this.overview_item);
        this.add(this.forward_overview_item);
        this.add(this.reverse_overview_item);
        this.addSeparator();
        this.add(this.view_bases_item);
        this.add(this.view_bases_as_fasta_item);
        this.add(this.view_aa_item);
        this.add(this.view_aa_as_fasta_item);
        this.addSeparator();
        this.add(this.feature_info_item);
        this.add(this.plot_features_item);
    }

    public ViewMenu(JFrame frame, Selection selection, GotoEventSource goto_event_source, EntryGroup entry_group, BasePlotGroup base_plot_group) {
        this(frame, selection, goto_event_source, entry_group, base_plot_group, "View");
    }

    private JMenuItem makeSearchResultsMenu(final String program_name, final boolean send_to_browser, boolean sanger_options) {
        JMenuItem new_menu;
        String new_menu_name = send_to_browser ? program_name + " results (in browser)" : program_name + " results";
        if ((sanger_options && send_to_browser || !sanger_options) && program_name.equals("fasta")) {
            new_menu = new JMenuItem(new_menu_name);
            new_menu.setAccelerator(FASTA_IN_BROWSER_KEY);
        } else if ((sanger_options && send_to_browser || !sanger_options) && program_name.equals("blastp")) {
            new_menu = new JMenuItem(new_menu_name);
            new_menu.setAccelerator(BLASTP_IN_BROWSER_KEY);
        } else if (program_name.equals("fasta")) {
            new_menu = new JMenuItem(new_menu_name);
            new_menu.setAccelerator(VIEW_FASTA_KEY);
        } else if (program_name.equals("blastp")) {
            new_menu = new JMenuItem(new_menu_name);
            new_menu.setAccelerator(VIEW_BLASTP_KEY);
        } else if (program_name.equals("hth")) {
            new_menu = new JMenuItem(new_menu_name);
            new_menu.setAccelerator(VIEW_HTH_KEY);
        } else {
            new_menu = new JMenuItem(new_menu_name);
        }
        new_menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewMenu.viewExternalResults(ViewMenu.this.getParentFrame(), ViewMenu.this.getSelection(), program_name, send_to_browser);
            }
        });
        return new_menu;
    }

    public static void showBadStartCodons(JFrame parent_frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        final FeatureKeyQualifierPredicate cds_predicate = new FeatureKeyQualifierPredicate(Key.CDS, "pseudo", false);
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                if (!cds_predicate.testPredicate(feature)) {
                    return false;
                }
                return !feature.hasValidStartCodon();
            }
        };
        String filter_name = "CDS features with suspicious start codons (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showBadStopCodons(JFrame parent_frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        final FeatureKeyQualifierPredicate cds_predicate = new FeatureKeyQualifierPredicate(Key.CDS, "pseudo", false);
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                if (!cds_predicate.testPredicate(feature)) {
                    return false;
                }
                return !feature.hasValidStopCodon();
            }
        };
        String filter_name = "CDS features with suspicious stop codons (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showStopsInTranslation(Frame parent_frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        final FeatureKeyQualifierPredicate cds_predicate = new FeatureKeyQualifierPredicate(Key.CDS, "pseudo", false);
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                if (!cds_predicate.testPredicate(feature)) {
                    return false;
                }
                AminoAcidSequence amino_acids = feature.getTranslation();
                return amino_acids.containsStopCodon();
            }
        };
        String filter_name = "CDS features with stop codon(s) in translation (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showNonEMBLKeys(JFrame parent_frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                return !feature.hasValidEMBLKey();
            }
        };
        String filter_name = "features with a non-EMBL key (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showDuplicatedFeatures(JFrame parent_frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                Entry feature_entry = feature.getEntry();
                int feature_index = feature_entry.indexOf(feature);
                if (feature_index + 1 == feature_entry.getFeatureCount()) {
                    return false;
                }
                Feature next_feature = feature_entry.getFeature(feature_index + 1);
                return feature.getKey().equals(next_feature.getKey()) && feature.getLocation().equals(next_feature.getLocation());
            }
        };
        String filter_name = "duplicated Features (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showOverlappingCDSs(JFrame parent_frame, Selection selection, final EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        final FeatureKeyPredicate cds_predicate = new FeatureKeyPredicate(Key.CDS);
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature test_feature) {
                FeatureVector overlapping_features;
                if (!cds_predicate.testPredicate(test_feature)) {
                    return false;
                }
                Range feature_range = test_feature.getMaxRawRange();
                try {
                    overlapping_features = entry_group.getFeaturesInRange(feature_range);
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                for (int i = 0; i < overlapping_features.size(); ++i) {
                    Feature current_feature = overlapping_features.elementAt(i);
                    if (current_feature == test_feature || !cds_predicate.testPredicate(current_feature)) continue;
                    return true;
                }
                return false;
            }
        };
        String filter_name = "overlapping CDS features (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showFeaturesWithSameStopCodons(JFrame parent_frame, Selection selection, final EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        final FeatureKeyPredicate cds_predicate = new FeatureKeyPredicate(Key.CDS);
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature test_feature) {
                FeatureVector overlapping_features;
                if (!cds_predicate.testPredicate(test_feature)) {
                    return false;
                }
                Range feature_range = test_feature.getMaxRawRange();
                try {
                    overlapping_features = entry_group.getFeaturesInRange(feature_range);
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                for (int i = 0; i < overlapping_features.size(); ++i) {
                    Feature current_feature = overlapping_features.elementAt(i);
                    if (current_feature == test_feature || current_feature == test_feature || !cds_predicate.testPredicate(current_feature) || current_feature.getLastBase() != test_feature.getLastBase() || current_feature.getSegments().lastElement().getFrameID() != test_feature.getSegments().lastElement().getFrameID()) continue;
                    return true;
                }
                return false;
            }
        };
        String filter_name = "CDS features with the same stop codon as another (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showMissingQualifierFeatures(JFrame parent_frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        FeaturePredicate feature_predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                return !feature.hasRequiredQualifiers();
            }
        };
        String filter_name = "features that are missing a required EMBL qualifier (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, feature_predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showFilterByKey(final JFrame parent_frame, final Selection selection, final EntryGroup entry_group, final GotoEventSource goto_source, final BasePlotGroup base_plot_group) {
        final KeyChooser key_chooser = new KeyChooser(Options.getArtemisEntryInformation(), new Key("misc_feature"));
        key_chooser.getKeyChoice().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ViewMenu.showFilterByKeyHelper(parent_frame, key_chooser.getKeyChoice().getSelectedItem(), selection, entry_group, goto_source, base_plot_group);
                    ((Component)key_chooser).setVisible(false);
                    key_chooser.dispose();
                }
            }
        });
        key_chooser.getOKButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                ViewMenu.showFilterByKeyHelper(parent_frame, key_chooser.getKeyChoice().getSelectedItem(), selection, entry_group, goto_source, base_plot_group);
                ((Component)key_chooser).setVisible(false);
                key_chooser.dispose();
            }
        });
        ((Component)key_chooser).setVisible(true);
    }

    public static void showFilterByKeyHelper(JFrame parent_frame, Key key, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        String filter_name = "features with key: " + key + " (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, new FeatureKeyPredicate(key), filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    public static void showFilterBySelection(JFrame parent_frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_source, BasePlotGroup base_plot_group) {
        FeatureFromVectorPredicate predicate = new FeatureFromVectorPredicate(selection.getAllFeatures());
        String filter_name = "features from the selection (filtered from: " + parent_frame.getTitle() + ")";
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, predicate, filter_name);
        FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, selection, goto_source, filtered_entry_group, base_plot_group);
        ((Component)feature_list_frame).setVisible(true);
    }

    static void viewSelectedFeatures(JFrame frame, Selection selection) {
        FeatureVector features_to_view = selection.getAllFeatures();
        if (features_to_view.size() > 25) {
            new MessageDialog(frame, "warning: only viewing the first 25 selected features");
        }
        for (int i = 0; i < features_to_view.size() && i < 25; ++i) {
            Feature selection_feature = features_to_view.elementAt(i);
            new FeatureViewer(selection_feature);
        }
    }

    static void plotSelectedFeatures(JFrame frame, Selection selection) {
        FeatureVector features_to_plot = selection.getAllFeatures();
        if (features_to_plot.size() > 25) {
            new MessageDialog(frame, "warning: only showing plots for the first 25 selected features");
        }
        for (int i = 0; i < features_to_plot.size() && i < 25; ++i) {
            Feature selection_feature = features_to_plot.elementAt(i);
            new FeaturePlotGroup(selection_feature);
        }
    }

    static void viewExternalResults(JFrame frame, Selection selection, String program_name, boolean send_to_browser) {
        FeatureVector features_to_view = selection.getAllFeatures();
        if (features_to_view.size() > 25) {
            new MessageDialog(frame, "warning: only viewing results from the first 25 selected features");
        }
        for (int i = 0; i < features_to_view.size() && i < 25; ++i) {
            Document root_document;
            String qualifier_value;
            Feature this_feature = features_to_view.elementAt(i);
            try {
                qualifier_value = this_feature.getValueOfQualifier(program_name + "_file");
            }
            catch (InvalidRelationException e) {
                qualifier_value = null;
            }
            String file_name = qualifier_value;
            if (file_name == null || file_name.length() == 0) {
                new MessageDialog(frame, "Message", "No " + program_name + " results for " + this_feature.getIDString());
                continue;
            }
            if (file_name.startsWith(program_name + File.separatorChar)) {
                file_name = file_name.substring(program_name.length() + 1);
            }
            if ((root_document = this_feature.getEntry().getRootDocument()) == null) {
                root_document = new FileDocument(new File("."));
            }
            try {
                Document document = null;
                File dir_name = new File(program_name);
                Document[] possible_documents = new Document[]{root_document.append(program_name).append(file_name), root_document.append(file_name), new FileDocument(new File(file_name)), new FileDocument(dir_name).append(file_name)};
                for (int possible_document_index = 0; possible_document_index < possible_documents.length; ++possible_document_index) {
                    Document this_document = possible_documents[possible_document_index];
                    if (this_document.readable()) {
                        document = this_document;
                        break;
                    }
                    File gzip_file = new File(this_document.toString() + ".gz");
                    FileDocument gzip_document = new FileDocument(gzip_file);
                    if (!((Document)gzip_document).readable()) continue;
                    document = gzip_document;
                    break;
                }
                if (document == null) {
                    String message_string = "No " + program_name + " results for " + this_feature.getIDString() + " (file not found: " + qualifier_value + ")";
                    new MessageDialog(frame, message_string);
                    continue;
                }
                if (send_to_browser) {
                    SearchResultViewer.sendToBrowser(document.toString());
                    continue;
                }
                new SearchResultViewer(program_name + " results for " + this_feature.getIDString() + " from " + document, document);
                continue;
            }
            catch (ExternalProgramException e) {
                new MessageDialog(frame, "error while open results file: " + e);
                continue;
            }
            catch (IOException e) {
                new MessageDialog(frame, "error while open results file: " + e);
            }
        }
    }

    private void viewSelectedFeatureInfo() {
        FeatureVector features_to_view = this.getSelection().getAllFeatures();
        if (features_to_view.size() > 25) {
            new MessageDialog(this.getParentFrame(), "warning: only viewing the statistics for the first 25 selected features");
        }
        for (int i = 0; i < features_to_view.size() && i < 25; ++i) {
            Feature selection_feature = features_to_view.elementAt(i);
            new FeatureInfo(selection_feature, this.base_plot_group.getCodonUsageAlgorithm());
        }
    }

    private void viewSelectedBases(boolean include_numbers) {
        if (this.getSelection().isEmpty()) {
            new MessageDialog(this.getParentFrame(), "Nothing selected");
            return;
        }
        MarkerRange range = this.selection.getMarkerRange();
        if (range == null) {
            FeatureVector features_to_view = this.getSelection().getAllFeatures();
            if (features_to_view.size() > 25) {
                new MessageDialog(this.getParentFrame(), "waning: only viewing bases for the first 25 selected features");
            }
            for (int i = 0; i < features_to_view.size() && i < 25; ++i) {
                Feature this_feature = features_to_view.elementAt(i);
                new FeatureBaseViewer(this_feature, include_numbers);
            }
        } else {
            SequenceViewer sequence_viewer = new SequenceViewer("Selected bases", include_numbers);
            String bases = this.getSelection().getSelectionText();
            sequence_viewer.setSequence(null, bases);
        }
    }

    private void viewSelectedAminoAcids(boolean include_numbers) {
        if (this.getSelection().isEmpty()) {
            new MessageDialog(this.getParentFrame(), "Nothing selected");
            return;
        }
        MarkerRange range = this.selection.getMarkerRange();
        if (range == null) {
            FeatureVector features_to_view = this.getSelection().getAllFeatures();
            if (features_to_view.size() > 25) {
                new MessageDialog(this.getParentFrame(), "warning: only viewing amino acids for the first 25 selected features");
            }
            for (int i = 0; i < features_to_view.size() && i < 25; ++i) {
                Feature this_feature = features_to_view.elementAt(i);
                new FeatureAminoAcidViewer(this_feature, include_numbers);
            }
        } else {
            SequenceViewer sequence_viewer = new SequenceViewer("Selected bases (translated)", include_numbers);
            String bases = this.getSelection().getSelectionText();
            AminoAcidSequence amino_acids = AminoAcidSequence.getTranslation(bases, true);
            sequence_viewer.setSequence(null, amino_acids.toString());
        }
    }

    private boolean checkEntryGroupSize(int max_size) {
        int feature_count = this.getEntryGroup().getAllFeaturesCount();
        if (feature_count < max_size) {
            return true;
        }
        YesNoDialog dialog = new YesNoDialog(this.getParentFrame(), "there are " + feature_count + " features in the " + "active entries - continue?");
        return dialog.getResult();
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }
}

