/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class FastaStreamSequence
extends RawStreamSequence {
    private String header = null;

    public FastaStreamSequence(LinePushBackReader in_stream) throws IOException {
        super(in_stream);
    }

    public FastaStreamSequence(Sequence sequence) {
        super(sequence);
    }

    public FastaStreamSequence(String sequence_string, String header) {
        super(sequence_string);
        this.header = header;
    }

    public FastaStreamSequence(String sequence_string) {
        this(sequence_string, "");
    }

    public StreamSequence copy() {
        return new FastaStreamSequence(this);
    }

    public int getFormatType() {
        return 4;
    }

    public void writeToStream(Writer writer) throws IOException {
        if (this.getHeader() != null) {
            writer.write(">" + this.getHeader() + "\n");
        }
        super.writeToStream(writer);
    }

    private String getHeader() {
        return this.header;
    }
}

