/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.util.Comparator;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureComparator;
import uk.ac.sanger.artemis.io.FeatureEnumeration;
import uk.ac.sanger.artemis.io.FeatureTree;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Range;

abstract class FeatureTable
extends LineGroup {
    private Feature cached_feature = null;
    private int cached_feature_index = -999;
    private final FeatureTree features = new FeatureTree((Comparator)new FeatureComparator());

    FeatureTable() {
    }

    private FeatureTree getFeatures() {
        return this.features;
    }

    int getFeatureCount() {
        return this.getFeatures().size();
    }

    FeatureVector getFeaturesInRange(Range range) {
        return this.getFeatures().getFeaturesInRange(range);
    }

    FeatureVector getAllFeatures() {
        FeatureVector return_features = new FeatureVector();
        FeatureEnumeration enumerator = this.features();
        while (enumerator.hasMoreFeatures()) {
            Feature this_feature = enumerator.nextFeature();
            return_features.add(this_feature);
        }
        return return_features;
    }

    void add(Feature new_feature) {
        this.cached_feature = null;
        this.cached_feature_index = -999;
        this.features.add(new_feature);
    }

    Feature remove(Feature feature) {
        this.cached_feature = null;
        this.cached_feature_index = -999;
        if (this.getFeatures().contains(feature)) {
            this.getFeatures().remove(feature);
            return feature;
        }
        return null;
    }

    Feature getFeatureAtIndex(int arg_index) {
        if (this.cached_feature != null) {
            if (arg_index == this.cached_feature_index) {
                return this.cached_feature;
            }
            if (arg_index == this.cached_feature_index + 1) {
                Feature next_feature = this.getFeatures().getNextFeature(this.cached_feature);
                if (next_feature == null) {
                    throw new ArrayIndexOutOfBoundsException(arg_index);
                }
                this.cached_feature_index = arg_index;
                this.cached_feature = next_feature;
                return this.cached_feature;
            }
        }
        FeatureEnumeration enumerator = this.features();
        int i = 0;
        while (enumerator.hasMoreFeatures()) {
            Feature this_feature = enumerator.nextFeature();
            if (i == arg_index) {
                this.cached_feature = this_feature;
                this.cached_feature_index = i;
                return this_feature;
            }
            ++i;
        }
        return null;
    }

    public boolean contains(Feature feature) {
        return this.getFeatures().contains(feature);
    }

    int indexOf(Feature feature) {
        if (this.cached_feature == feature) {
            return this.cached_feature_index;
        }
        FeatureEnumeration enumerator = this.features();
        int i = 0;
        while (enumerator.hasMoreFeatures()) {
            Feature this_feature = enumerator.nextFeature();
            if (this_feature == feature) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public FeatureEnumeration features() {
        return this.getFeatures().features();
    }
}

