/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class GCFrameAlgorithm
extends BaseAlgorithm {
    private int[] gc_counts = new int[this.getValueCount()];

    public GCFrameAlgorithm(Strand strand) {
        super(strand, GCFrameAlgorithm.makeName(strand), "gc_frame");
        this.setScalingFlag(true);
    }

    public void getValues(int start, int end, float[] values) {
        String sub_sequence;
        if (this.isRevCompDisplay()) {
            int new_end = this.getStrand().getBases().getComplementPosition(start);
            int new_start = this.getStrand().getBases().getComplementPosition(end);
            end = new_end;
            start = new_start;
        }
        if (this.getStrand().isForwardStrand()) {
            end -= (end - start + 1) % 3;
        } else {
            start += (end - start + 1) % 3;
        }
        for (int i = 0; i < this.getValueCount(); ++i) {
            this.gc_counts[i] = 0;
        }
        try {
            sub_sequence = this.getStrand().getRawSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        int sub_sequence_length = sub_sequence.length();
        if (this.getStrand().isForwardStrand()) {
            for (int i = 0; i < sub_sequence_length; i += 3) {
                for (int frame = 0; frame < 3; ++frame) {
                    char this_char = sub_sequence.charAt(i + frame);
                    if (this_char != 'g' && this_char != 'c') continue;
                    int n = (frame + start) % 3;
                    this.gc_counts[n] = this.gc_counts[n] + 1;
                }
            }
        } else {
            int whole_sequence_length = this.getStrand().getSequenceLength();
            int whole_sequence_length_mod3 = whole_sequence_length % 3;
            for (int i = 0; i < sub_sequence_length; i += 3) {
                for (int frame = 0; frame < 3; ++frame) {
                    char this_char = sub_sequence.charAt(i + frame);
                    if (this_char != 'g' && this_char != 'c') continue;
                    int n = (frame + start + 3 - whole_sequence_length_mod3) % 3;
                    this.gc_counts[n] = this.gc_counts[n] + 1;
                }
            }
        }
        for (int frame = 0; frame < 3; ++frame) {
            values[frame] = 1.0f * (float)this.gc_counts[frame] / (float)sub_sequence_length * 3.0f * 100.0f;
        }
    }

    public int getValueCount() {
        return 3;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(120);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(500);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(24);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 8) {
            return new Integer(window_size / 8);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(100.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(0.0f);
    }

    public Float getAverage() {
        return new Float(this.getStrand().getBases().getAverageGCPercent());
    }

    private static String makeName(Strand strand) {
        if (strand.isForwardStrand()) {
            return "GC Frame Plot";
        }
        return "Reverse GC Frame Plot";
    }
}

