/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class KarlinSigAlgorithm
extends BaseAlgorithm {
    private float[][] global_relative_abundance_values = null;

    public KarlinSigAlgorithm(Strand strand) {
        super(strand, "Karlin Signature Difference", "karlin_sig");
        this.setScalingFlag(true);
    }

    public void getValues(int start, int end, float[] values) {
        String sub_sequence;
        end -= (end - start + 1) % 3;
        try {
            sub_sequence = this.getStrand().getSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        float[][] global_relative_abundance_values = this.getGlobalRelativeAbundance();
        float[][] subseq_relative_abundance_values = this.getRelativeAbundance(sub_sequence);
        float signature_difference = 0.0f;
        for (int first_base = 0; first_base < 4; ++first_base) {
            for (int second_base = 0; second_base < 4; ++second_base) {
                float global_value = global_relative_abundance_values[first_base][second_base];
                float subseq_value = subseq_relative_abundance_values[first_base][second_base];
                signature_difference += Math.abs(global_value - subseq_value);
            }
        }
        values[0] = signature_difference / 16.0f;
    }

    public int getValueCount() {
        return 1;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(240);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(5000);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(24);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 10) {
            return new Integer(window_size / 10);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(2.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(0.0f);
    }

    public Float getAverage() {
        return null;
    }

    private float[][] getRelativeAbundance(String sequence) {
        float[][] return_value = new float[4][4];
        char[] sequence_forward_raw = sequence.toCharArray();
        char[] sequence_reverse_raw = Bases.reverseComplement(sequence).toCharArray();
        int[] base_counts = new int[4];
        int[][] dinucleotide_base_counts = new int[4][4];
        char this_f_base = '\u0000';
        char next_f_base = '\u0000';
        char this_r_base = '\u0000';
        char next_r_base = '\u0000';
        int this_f_base_index = 0;
        int next_f_base_index = 0;
        int this_r_base_index = 0;
        int next_r_base_index = 0;
        for (int i = 0; i < sequence_forward_raw.length - 1; ++i) {
            this_f_base = sequence_forward_raw[i];
            next_f_base = sequence_forward_raw[i + 1];
            this_f_base_index = Bases.getIndexOfBase(this_f_base);
            next_f_base_index = Bases.getIndexOfBase(next_f_base);
            if (this_f_base_index < 4 && next_f_base_index < 4) {
                int n = this_f_base_index;
                base_counts[n] = base_counts[n] + 1;
                int[] nArray = dinucleotide_base_counts[this_f_base_index];
                int n2 = next_f_base_index;
                nArray[n2] = nArray[n2] + 1;
            }
            this_r_base = sequence_reverse_raw[i];
            next_r_base = sequence_reverse_raw[i + 1];
            this_r_base_index = Bases.getIndexOfBase(this_r_base);
            next_r_base_index = Bases.getIndexOfBase(next_r_base);
            if (this_r_base_index >= 4 || next_r_base_index >= 4) continue;
            int n = this_r_base_index;
            base_counts[n] = base_counts[n] + 1;
            int[] nArray = dinucleotide_base_counts[this_r_base_index];
            int n3 = next_r_base_index;
            nArray[n3] = nArray[n3] + 1;
        }
        if (next_f_base_index < 4) {
            int n = next_f_base_index;
            base_counts[n] = base_counts[n] + 1;
        }
        if (next_r_base_index < 4) {
            int n = next_r_base_index;
            base_counts[n] = base_counts[n] + 1;
        }
        for (int first_base_index = 0; first_base_index < 4; ++first_base_index) {
            for (int second_base_index = 0; second_base_index < 4; ++second_base_index) {
                float dinucleotide_frequency = 1.0f * (float)dinucleotide_base_counts[first_base_index][second_base_index] / (float)(sequence_reverse_raw.length - 1) / 2.0f;
                float first_base_frequency = 1.0f * (float)base_counts[first_base_index] / (float)sequence_reverse_raw.length / 2.0f;
                float second_base_frequency = 1.0f * (float)base_counts[second_base_index] / (float)sequence_reverse_raw.length / 2.0f;
                return_value[first_base_index][second_base_index] = dinucleotide_frequency / (first_base_frequency * second_base_frequency);
            }
        }
        return return_value;
    }

    private float[][] getGlobalRelativeAbundance() {
        if (this.global_relative_abundance_values == null) {
            try {
                Range whole_range = new Range(1, this.getStrand().getSequenceLength());
                String sequence = this.getStrand().getSubSequence(whole_range);
                this.global_relative_abundance_values = this.getRelativeAbundance(sequence);
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        return this.global_relative_abundance_values;
    }
}

