/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class Configuration {
    public static final String FILE = "file";
    public static final String EXTENSION = "extension";
    public static final String ID = "id";
    public static final String ALIAS = "alias";
    public static final String TEMPLATE = "template";
    public static final String SEQUENCE = "sequence";
    public static final String NUCLEIC = "nucleotide";
    public static final String AMINO = "aminoacid";
    public static final String FASTA = "fasta";
    public static final String EMBL = "embl";
    public static final String FEATURETABLE = "featuretable";
    public static final String EXECUTABLE = "executable";
    public static final String RUN = "run";
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    public static final String ERROR = "error";
    public static final String QUEUE = "queue";
    public static final String ORGANISM = "organism";
    public static final String TAXID = "taxid";
    public static final String FASTA_NT_EXTENSION_KEY = Configuration.joinComponents(new String[]{"sequence", "file", "extension", "fasta", "nucleotide"});
    public static final String FASTA_AA_EXTENSION_KEY = Configuration.joinComponents(new String[]{"sequence", "file", "extension", "fasta", "aminoacid"});
    public static final String EMBL_EXTENSION_KEY = Configuration.joinComponents(new String[]{"sequence", "file", "extension", "embl"});
    public static final String FTABLE_EXTENSION_KEY = Configuration.joinComponents(new String[]{"sequence", "file", "extension", "featuretable"});
    public static final String INPUT_EXTENSION_KEY = Configuration.joinComponents(new String[]{"executable", "run", "file", "extension", "input"});
    public static final String OUTPUT_EXTENSION_KEY = Configuration.joinComponents(new String[]{"executable", "run", "file", "extension", "output"});
    public static final String ERROR_EXTENSION_KEY = Configuration.joinComponents(new String[]{"executable", "run", "file", "extension", "error"});
    public static final String EXEC_QUEUE_KEY = Configuration.joinComponents(new String[]{"executable", "run", "queue"});
    public static final String EXEC_ALIAS_KEY = Configuration.joinComponents(new String[]{"executable", "alias"});
    public static final String EXEC_ID_KEY = Configuration.joinComponents(new String[]{"executable", "id"});
    public static final String ORG_ALIAS_KEY = Configuration.joinComponents(new String[]{"organism", "alias"});
    public static final String ORG_TAXID_KEY = Configuration.joinComponents(new String[]{"organism", "taxid"});
    private ResourceBundle resource;
    private Set execAliases;
    private Set organismAliases;
    private Map execIds;
    private Map taxIds;

    public Configuration(ResourceBundle resource) {
        this.resource = resource;
        this.initConfiguration();
    }

    public Set getExecutableAliases() {
        return Collections.unmodifiableSet(this.execAliases);
    }

    public Set getOrganismAliases() {
        return Collections.unmodifiableSet(this.organismAliases);
    }

    public int getExecutableId(String execAlias) {
        if (!this.execAliases.contains(execAlias)) {
            throw new IllegalArgumentException("Unknown alias '" + execAlias + "'");
        }
        if (!this.execIds.containsKey(execAlias)) {
            throw new IllegalArgumentException("No ID bound to alias '" + execAlias + "'");
        }
        return (Integer)this.execIds.get(execAlias);
    }

    public int getTaxonomyId(String organismAlias) {
        if (!this.organismAliases.contains(organismAlias)) {
            throw new IllegalArgumentException("Unknown alias '" + organismAlias + "'");
        }
        if (!this.taxIds.containsKey(organismAlias)) {
            throw new IllegalArgumentException("No Taxonomy ID bound to alias '" + organismAlias + "'");
        }
        return (Integer)this.taxIds.get(organismAlias);
    }

    public String getTemplate(String organismAlias, String execAlias) {
        if (!this.organismAliases.contains(organismAlias)) {
            throw new IllegalArgumentException("Unknown alias '" + organismAlias + "'");
        }
        if (!this.execAliases.contains(execAlias)) {
            throw new IllegalArgumentException("Unknown alias '" + execAlias + "'");
        }
        return this.resource.getString("template." + organismAlias + "." + execAlias);
    }

    public String getString(String key) {
        return this.resource.getString(key);
    }

    private void initConfiguration() {
        this.execAliases = this.initAliases(EXECUTABLE);
        this.organismAliases = this.initAliases(ORGANISM);
        this.execIds = this.initIdMap(EXEC_ID_KEY, this.execAliases);
        this.taxIds = this.initIdMap(ORG_TAXID_KEY, this.organismAliases);
    }

    private Set initAliases(String baseKey) {
        HashSet<String> aliases = new HashSet<String>();
        String key = baseKey + "." + ALIAS;
        String[] val = this.stringTokenize(this.resource.getString(key));
        int i = 0;
        while (i < val.length) {
            aliases.add(val[i]);
            ++i;
        }
        return aliases;
    }

    private Map initIdMap(String baseKey, Set aliases) {
        HashMap<String, Integer> ids = new HashMap<String, Integer>();
        Iterator i = aliases.iterator();
        while (i.hasNext()) {
            String alias = (String)i.next();
            String key = baseKey + "." + alias;
            String val = this.resource.getString(key);
            ids.put(alias, Integer.decode(val));
        }
        return ids;
    }

    private String[] stringTokenize(String val) {
        StringTokenizer st = new StringTokenizer(val);
        int count = st.countTokens();
        String[] tokens = new String[count];
        int i = 0;
        while (i < count) {
            tokens[i] = st.nextToken();
            ++i;
        }
        return tokens;
    }

    private static String joinComponents(String[] components) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < components.length) {
            sb.append(components[i]);
            sb.append(".");
            ++i;
        }
        return sb.substring(0, sb.length() - 1);
    }
}

