/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.SMORegressionTrainer;
import org.biojava.stats.svm.SVMRegressionModel;
import org.biojava.stats.svm.SparseVector;
import org.biojava.stats.svm.tools.SVM_Light;

public class TrainRegression {
    public static void main(String[] args) throws Throwable {
        String line;
        if (args.length < 2) {
            throw new Exception("usage: stats.svm.tools.TrainRegression <train_examples> <model_file>");
        }
        String trainFile = args[0];
        String modelFile = args[1];
        ArrayList<SVM_Light.LabelledVector> examples = new ArrayList<SVM_Light.LabelledVector>();
        BufferedReader r = new BufferedReader(new FileReader(trainFile));
        while ((line = r.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            examples.add(SVM_Light.parseExample(line));
        }
        r.close();
        SVMRegressionModel model = new SVMRegressionModel(examples.size());
        double[] target = new double[examples.size()];
        for (int i = 0; i < examples.size(); ++i) {
            SVM_Light.LabelledVector ex = (SVM_Light.LabelledVector)examples.get(i);
            model.addVector(ex.getVector());
            target[i] = ex.getLabel();
        }
        PolynomialKernel k = new PolynomialKernel();
        k.setNestedKernel(SparseVector.kernel);
        k.setOrder(2.0);
        model.setKernel(k);
        System.out.println("Calculating kernel " + k);
        model.calcKernel();
        SMORegressionTrainer trainer = new SMORegressionTrainer();
        trainer.setEpsilon(1.0E-11);
        trainer.setC(1000.0);
        System.out.println("\nTraining");
        trainer.trainModel(model, target);
        System.out.println("\nDone");
        for (int i = 0; i < model.size(); ++i) {
            System.err.println("y=" + target[i] + "\tf(x)=" + model.internalClassify(i) + "    (" + model.getAlpha(i) + ",\t" + model.getAlphaStar(i) + ")" + "\t" + (model.internalClassify(i) - model.getThreshold()));
        }
        System.err.println("b=" + model.getThreshold());
    }
}

