/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.io.Serializable;
import org.metaqtl.util.MappingFunction;

public class Qtl {
    public int id;
    public String name = null;
    public int m1 = 0;
    public int m2 = 0;
    public double position = 0.0;
    public double sd_position = 0.0;
    public double c1 = 0.0;
    public double c2 = 0.0;
    public QTLTrait trait = null;
    public QTLStats stats = null;
    public QTLSupport ci = null;
    public QTLCross cross = null;
    public QTLProj proj = null;
    private boolean ignore = false;

    public static double getQTLSD(QTLSupport ci, int mappingFunction, int mappingUnit) {
        double sd = 0.0;
        if (ci == null) {
            return 0.0;
        }
        double d1 = MappingFunction.distance(ci.ic1, mappingFunction, mappingUnit);
        double d2 = MappingFunction.distance(ci.ic2, mappingFunction, mappingUnit);
        double sup = d1 + d2;
        sd = ci.lodDecrease != 0.0 ? (ci.lodDecrease < 1.5 ? sup / 3.2898 : sup / 3.92) : sup / 3.92;
        return sd;
    }

    public static double getQTLSD(double rsquare, QTLCross cross, int mappingUnit) {
        double sd = 0.0;
        if (cross == null) {
            return 0.0;
        }
        if ((double)cross.size == 0.0) {
            return 0.0;
        }
        if (rsquare == 0.0) {
            return 0.0;
        }
        if (rsquare > 1.0) {
            return 0.0;
        }
        sd = 530.0 / (rsquare * (double)cross.size);
        sd /= 3.92;
        if (mappingUnit == 1) {
            sd /= 100.0;
        }
        return sd;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public Qtl getCopy() {
        Qtl qtl = new Qtl();
        qtl.c1 = this.c1;
        qtl.c2 = this.c2;
        if (this.ci != null) {
            qtl.ci = this.ci.getCopy();
        }
        if (this.cross != null) {
            qtl.cross = this.cross.getCopy();
        }
        qtl.ignore = this.ignore;
        qtl.m1 = this.m1;
        qtl.m2 = this.m2;
        qtl.name = new String(this.name);
        qtl.position = this.position;
        if (this.proj != null) {
            qtl.proj = this.proj.getCopy();
        }
        qtl.sd_position = this.sd_position;
        if (this.stats != null) {
            qtl.stats = this.stats.getCopy();
        }
        if (this.trait != null) {
            qtl.trait = this.trait.getCopy();
        }
        return qtl;
    }

    public String getName() {
        return this.name;
    }

    public class QTLTrait
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name = null;
        public String unit = null;
        public String group;

        public QTLTrait getCopy() {
            QTLTrait trait = new QTLTrait();
            if (this.name != null) {
                trait.name = new String(this.name);
            }
            if (this.group != null) {
                trait.group = new String(this.group);
            }
            if (this.unit != null) {
                trait.unit = new String(this.unit);
            }
            return trait;
        }
    }

    public class QTLStats
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double rsquare = 0.0;
        public double additive = 0.0;
        public double dominance = 0.0;
        public double lod = 0.0;

        public QTLStats getCopy() {
            QTLStats stats = new QTLStats();
            stats.additive = this.additive;
            stats.dominance = this.dominance;
            stats.lod = this.lod;
            stats.rsquare = this.rsquare;
            return stats;
        }
    }

    public class QTLSupport
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double ic1 = 0.0;
        public double ic2 = 0.0;
        public double from = 0.0;
        public double to = 0.0;
        public double lodDecrease = 0.0;

        public QTLSupport getCopy() {
            QTLSupport copy = new QTLSupport();
            copy.from = this.from;
            copy.ic1 = this.ic1;
            copy.ic2 = this.ic2;
            copy.lodDecrease = this.lodDecrease;
            copy.to = this.to;
            return copy;
        }
    }

    public class QTLCross
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name = null;
        public int type = 0;
        public int gen = 0;
        public int size = 0;

        public QTLCross getCopy() {
            QTLCross copy = new QTLCross();
            copy.gen = this.gen;
            copy.name = this.name != null ? new String(this.name) : null;
            copy.size = this.size;
            copy.type = this.type;
            return copy;
        }
    }

    public class QTLProj
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String mapOrigin = null;
        public int o_mrkIdxL;
        public int o_mrkIdxR;
        public int s_mrkIdxL;
        public int s_mrkIdxR;
        public double mapScale = 0.0;
        public double mapWeight = 0.0;
        public double intScale = 0.0;
        public boolean shareFlanking = false;
        public boolean swap = false;

        public QTLProj getCopy() {
            QTLProj copy = new QTLProj();
            copy.intScale = this.intScale;
            copy.mapScale = this.mapScale;
            copy.mapWeight = this.mapWeight;
            copy.o_mrkIdxL = this.o_mrkIdxL;
            copy.o_mrkIdxR = this.o_mrkIdxR;
            copy.s_mrkIdxL = this.s_mrkIdxL;
            copy.s_mrkIdxR = this.s_mrkIdxR;
            copy.shareFlanking = this.shareFlanking;
            copy.swap = this.swap;
            if (this.mapOrigin != null) {
                copy.mapOrigin = new String(this.mapOrigin);
            }
            return copy;
        }
    }
}

