/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.adapter;

import java.util.Properties;
import org.metaqtl.EMResult;
import org.metaqtl.Qtl;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.Locus;
import org.metaqtl.bio.util.BioCrossTypes;
import org.metaqtl.bio.util.NumberFormat;

public final class QtlAdapter {
    public static IBioLocus fromQTL(Qtl qtl) {
        Locus locus = null;
        if (qtl == null) {
            return locus;
        }
        locus = Locus.newLocus(1);
        locus.setName(qtl.name);
        locus.setPosition(qtl.position);
        Properties properties = locus.getProperties();
        if (qtl.trait != null) {
            if (qtl.trait.name != null) {
                properties.setProperty("qtl.trait.name", qtl.trait.name);
            }
            if (qtl.trait.unit != null) {
                properties.setProperty("qtl.trait.unit", qtl.trait.unit);
            }
        }
        if (qtl.cross != null) {
            String val;
            if (qtl.cross.name != null) {
                properties.setProperty("qtl.cross.name", qtl.cross.name);
            }
            if (qtl.cross.type != 0 && (val = BioCrossTypes.crossToString(qtl.cross.type, qtl.cross.gen)) != null) {
                properties.setProperty("qtl.cross.type", val);
            }
            if (qtl.cross.size > 0) {
                properties.setProperty("qtl.cross.size", "" + qtl.cross.size);
            }
        }
        if (qtl.ci != null) {
            properties.setProperty("qtl.ci.from", "" + qtl.ci.from);
            properties.setProperty("qtl.ci.to", "" + qtl.ci.to);
            if (qtl.ci.lodDecrease > 0.0) {
                properties.setProperty("qtl.ci.lod.decrease", "" + qtl.ci.lodDecrease);
            }
        }
        if (qtl.stats != null) {
            if (qtl.stats.additive != 0.0) {
                properties.setProperty("qtl.effect.additive", "" + qtl.stats.additive);
            }
            if (qtl.stats.dominance != 0.0) {
                properties.setProperty("qtl.effect.dominance", "" + qtl.stats.dominance);
            }
            if (qtl.stats.rsquare != 0.0) {
                properties.setProperty("qtl.rsquare", "" + qtl.stats.rsquare);
            }
        }
        if (qtl.proj != null) {
            properties.setProperty("qtl.proj.mapOrigin", qtl.proj.mapOrigin);
            properties.setProperty("qtl.proj.intScale", "" + qtl.proj.intScale);
            properties.setProperty("qtl.proj.mapScale", "" + qtl.proj.mapScale);
            properties.setProperty("qtl.proj.shareFlanking", "" + qtl.proj.shareFlanking);
            properties.setProperty("qtl.proj.swapFlanking", "" + qtl.proj.swap);
        }
        locus.setProperties(properties);
        return locus;
    }

    public static Qtl toQTL(IBioLocus locus) {
        Qtl qtl = null;
        if (locus == null) {
            return null;
        }
        qtl = new Qtl();
        qtl.position = locus.getPosition().absolute();
        qtl.name = locus.getName();
        Properties properties = locus.getProperties();
        String value = properties.getProperty("qtl.trait.name");
        if (value != null && !value.equals("")) {
            qtl.trait = qtl.new Qtl.QTLTrait();
            qtl.trait.name = value;
            value = properties.getProperty("qtl.trait.unit");
            if (value != null && !value.equals("")) {
                qtl.trait.unit = value;
            }
            if ((value = properties.getProperty("qtl.trait.group")) != null && !value.equals("")) {
                qtl.trait.group = value;
            }
        }
        if ((value = properties.getProperty("qtl.rsquare")) != null && !value.equals("")) {
            double d = NumberFormat.parseDouble(value);
            if (qtl.stats == null) {
                qtl.stats = qtl.new Qtl.QTLStats();
            }
            qtl.stats.rsquare = NumberFormat.parseDouble(value);
        }
        if ((value = properties.getProperty("qtl.effect.additive")) != null && !value.equals("")) {
            if (qtl.stats == null) {
                qtl.stats = qtl.new Qtl.QTLStats();
            }
            qtl.stats.additive = NumberFormat.parseDouble(value);
        }
        if ((value = properties.getProperty("qtl.effect.dominance")) != null && !value.equals("")) {
            if (qtl.stats == null) {
                qtl.stats = qtl.new Qtl.QTLStats();
            }
            qtl.stats.dominance = NumberFormat.parseDouble(value);
        }
        if ((value = properties.getProperty("qtl.ci.from")) != null && !value.equals("")) {
            if (qtl.ci == null) {
                qtl.ci = qtl.new Qtl.QTLSupport();
            }
            qtl.ci.from = NumberFormat.parseDouble(value);
        }
        if ((value = properties.getProperty("qtl.ci.to")) != null && !value.equals("")) {
            if (qtl.ci == null) {
                qtl.ci = qtl.new Qtl.QTLSupport();
            }
            qtl.ci.to = NumberFormat.parseDouble(value);
        }
        if ((value = properties.getProperty("qtl.ci.lod.decrease")) != null && !value.equals("")) {
            if (qtl.ci == null) {
                qtl.ci = qtl.new Qtl.QTLSupport();
            }
            qtl.ci.lodDecrease = NumberFormat.parseDouble(value);
        }
        if (qtl.ci != null && qtl.ci.to == qtl.ci.from && qtl.ci.from == 0.0) {
            qtl.ci = null;
        }
        if ((value = properties.getProperty("qtl.cross.name")) != null && !value.equals("")) {
            if (qtl.cross == null) {
                qtl.cross = qtl.new Qtl.QTLCross();
            }
            qtl.cross.name = value;
        }
        if ((value = properties.getProperty("qtl.cross.type")) != null && !value.equals("")) {
            if (qtl.cross == null) {
                qtl.cross = qtl.new Qtl.QTLCross();
            }
            BioCrossTypes.parseCross(value);
            qtl.cross.type = BioCrossTypes.type;
            qtl.cross.gen = BioCrossTypes.gen;
        }
        if ((value = properties.getProperty("qtl.cross.size")) != null && !value.equals("")) {
            if (qtl.cross == null) {
                qtl.cross = qtl.new Qtl.QTLCross();
            }
            try {
                qtl.cross.size = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                qtl.cross.size = 0;
            }
        }
        if ((value = properties.getProperty("qtl.proj.intScale")) != null && !value.equals("")) {
            if (qtl.proj == null) {
                qtl.proj = qtl.new Qtl.QTLProj();
            }
            qtl.proj.intScale = NumberFormat.parseDouble(value);
        }
        if ((value = properties.getProperty("qtl.proj.mapScale")) != null && !value.equals("")) {
            if (qtl.proj == null) {
                qtl.proj = qtl.new Qtl.QTLProj();
            }
            qtl.proj.mapScale = NumberFormat.parseDouble(value);
        }
        if ((value = properties.getProperty("qtl.proj.shareFlanking")) != null && !value.equals("")) {
            if (qtl.proj == null) {
                qtl.proj = qtl.new Qtl.QTLProj();
            }
            qtl.proj.shareFlanking = Boolean.parseBoolean(value);
        }
        if ((value = properties.getProperty("qtl.proj.swapFlanking")) != null && !value.equals("")) {
            if (qtl.proj == null) {
                qtl.proj = qtl.new Qtl.QTLProj();
            }
            qtl.proj.swap = Boolean.parseBoolean(value);
        }
        return qtl;
    }

    public static Qtl[] adapt(EMResult result) {
        if (result == null) {
            return null;
        }
        Qtl[] qtls = null;
        qtls = new Qtl[result.k];
        int i = 0;
        while (i < result.k) {
            qtls[i] = new Qtl();
            qtls[i].position = result.mu[i];
            qtls[i].sd_position = Math.sqrt(result.ocov[i][i]);
            qtls[i].ci = qtls[i].new Qtl.QTLSupport();
            qtls[i].ci.from = result.mu[i] - qtls[i].sd_position * 1.96;
            qtls[i].ci.to = result.mu[i] + qtls[i].sd_position * 1.96;
            ++i;
        }
        return qtls;
    }
}

