/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import org.metaqtl.MetaQtlData;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.adapter.MetaQtlAnalysisAdapter;
import org.metaqtl.algo.ClustAlgorithm;
import org.metaqtl.algo.HClustAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioOntology;

public class QtlTreeAlgorithm
extends ClustAlgorithm {
    public int tree_method = 2;

    public QtlTreeAlgorithm(IBioGenome map, IBioOntology ontology) {
        super(map, ontology);
    }

    public void run() {
        int i = 0;
        while (i < this.chromosomes.length) {
            if (this.chromosomes[i].hasQTL()) {
                ++this.workProgress;
                this.chromosomes[i].computeQtlSD(this.sd_mode);
                MetaQtlData data = new MetaQtlData(this.chromosomes[i].getQtls());
                if (this.ontology == null) {
                    data.doTraitGroupClustering();
                } else {
                    data.doTraitOntologyClustering(this.ontology);
                }
                data.manageMissingData(this.missing_sd_mode);
                if (this.isLoggerEnable()) {
                    this.getLogger().println("Start Clustering on chromosome " + this.chromosomes[i].getName());
                    this.getLogger().flush();
                }
                this.chromosomes[i].metaQtlAnalysis = this.buildQtlTree(data);
            }
            ++i;
        }
        this.result = MetaQtlAnalysisAdapter.adapt(this.chromosomes);
    }

    public MetaQtlResult[] buildQtlTree(MetaQtlData data) {
        MetaQtlResult[] results = null;
        if (data == null) {
            return null;
        }
        int ntg = data.getTraitClusterNumber();
        results = new MetaQtlResult[ntg];
        int i = 0;
        while (i < ntg) {
            Double[][] X;
            String trait = data.getTraitClusterName(i);
            if (this.isLoggerEnable()) {
                this.getLogger().println("Clustering for trait " + trait);
                this.getLogger().flush();
            }
            if ((X = data.getDataPoints(i, true)) != null) {
                HClustAlgorithm.METHOD = this.tree_method;
                results[i] = new MetaQtlResult(trait, X[0].length);
                results[i].setX(X[0]);
                results[i].setSD(X[1]);
                results[i].setTree(HClustAlgorithm.run(results[i].x, results[i].sd));
                results[i].setQtlIdx(data.getQtlIdx(i));
            } else if (this.isLoggerEnable()) {
                this.getLogger().print("[ WARNING ] : ");
                this.getLogger().println("No data points for trait cluster " + trait);
                this.getLogger().flush();
            }
            ++i;
        }
        return results;
    }

    public void setTreeMethod(int tree_method) {
        this.tree_method = tree_method;
    }
}

