/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity;

import java.util.Properties;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.entity.BioEntityCollection;
import org.metaqtl.bio.entity.CrossPopulation;
import org.metaqtl.bio.entity.GeneticMap;
import org.metaqtl.bio.entity.Individual;
import org.metaqtl.bio.entity.LGroup;
import org.metaqtl.bio.entity.Marker;
import org.metaqtl.bio.entity.Ontology;
import org.metaqtl.bio.entity.OntologyTerm;
import org.metaqtl.bio.entity.QTL;

public abstract class BioEntity
implements IBioEntity {
    protected String name = "";
    protected IBioEntity parent = null;
    protected Properties properties;

    public BioEntity() {
        this.properties = new Properties();
    }

    public BioEntity(String name, IBioEntity parent) {
        this.name = name;
        this.parent = parent;
        this.properties = new Properties();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public abstract int getType();

    public IBioEntity getParent() {
        return this.parent == null ? this : this.parent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties defaultProp) {
        this.properties = defaultProp;
    }

    public static IBioEntity newBioEntity(int type) {
        if (type == 6) {
            return new Marker();
        }
        if (type == 8) {
            return null;
        }
        if (type == 9) {
            return new BioEntityCollection();
        }
        if (type == 3) {
            return new GeneticMap();
        }
        if (type == 1) {
            return new Individual();
        }
        if (type == 4) {
            return new LGroup();
        }
        if (type == 2) {
            return new CrossPopulation();
        }
        if (type == 7) {
            return new QTL();
        }
        if (type == 11) {
            return new Ontology();
        }
        if (type == 10) {
            return new OntologyTerm();
        }
        return null;
    }
}

