/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity;

import java.util.HashMap;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.BioEntityContainer;

public abstract class LocusContainer
extends BioEntityContainer
implements IBioLGroup {
    public LocusContainer() {
    }

    public LocusContainer(String name, IBioEntity parent) {
        super(name, parent);
    }

    public abstract int getType();

    public IBioGenome getGenome() {
        return (IBioGenome)this.parent;
    }

    public void setGenome(IBioGenome genome) {
        this.parent = genome;
    }

    public IBioLocus[] loci() {
        IBioEntity[] entities = this.entities();
        IBioLocus[] loci = new IBioLocus[entities.length];
        int i = 0;
        while (i < loci.length) {
            loci[i] = (IBioLocus)entities[i];
            ++i;
        }
        return loci;
    }

    public void addLocus(IBioLocus locus) {
        this.addEntity(locus);
    }

    public IBioLocus getLocus(String name) {
        return (IBioLocus)this.getEntity(name);
    }

    public void removeLocus(String name) {
        this.removeEntity(name);
    }

    public int getLocusNumber() {
        return this.entityNumber();
    }

    public void setLoci(IBioLocus[] loci) {
        if (loci == null) {
            this.entities = null;
            return;
        }
        this.entities = new HashMap(loci.length);
        int i = 0;
        while (i < loci.length) {
            this.entities.put(loci[i].getName(), loci[i]);
            ++i;
        }
    }
}

