/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity.factory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.metaqtl.bio.IBioAdapter;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.entity.BioEntity;
import org.metaqtl.bio.entity.factory.BioEntityFactory;

public abstract class XmlBioEntityFactory
extends BioEntityFactory {
    protected abstract Class getEntityBeanClass();

    protected abstract int getEntityType();

    public IBioEntity load(InputStream stream) throws IOException {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(this.getEntityBeanClass());
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            Object object = uctx.unmarshalDocument(stream, null);
            IBioEntity entity = BioEntity.newBioEntity(this.getEntityType());
            return entity.getBioAdapter().toEntity(object);
        }
        catch (JiBXException e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public IBioEntity load(Reader reader) throws IOException {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(this.getEntityBeanClass());
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            Object object = uctx.unmarshalDocument(reader, null);
            IBioEntity entity = BioEntity.newBioEntity(this.getEntityType());
            return entity.getBioAdapter().toEntity(object);
        }
        catch (JiBXException e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public void unload(IBioEntity obj, OutputStream stream) throws IOException {
        try {
            Object bean = null;
            IBioAdapter adapter = obj.getBioAdapter();
            bean = adapter.fromEntity(obj);
            IBindingFactory bfact = BindingDirectory.getFactory(bean.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(3);
            mctx.marshalDocument(bean, "UTF-8", null, stream);
        }
        catch (JiBXException e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public void unload(IBioEntity obj, Writer writer) throws IOException {
        try {
            Object bean = null;
            IBioAdapter adapter = obj.getBioAdapter();
            bean = adapter.fromEntity(obj);
            IBindingFactory bfact = BindingDirectory.getFactory(bean.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(1);
            mctx.marshalDocument(bean, "UTF-8", null, writer);
        }
        catch (JiBXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

