/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Set;

public final class TabulatedReader {
    private String[] keyStrs;
    private Hashtable keys;
    private BufferedReader buffer;
    private String token = "\t";

    public TabulatedReader(Reader reader) throws IOException {
        this.buffer = new BufferedReader(reader);
        this.readKeysFromHeader(this.buffer.readLine());
    }

    public TabulatedReader(InputStream stream) throws IOException {
        InputStreamReader is = new InputStreamReader(stream);
        this.buffer = new BufferedReader(is);
        this.readKeysFromHeader(this.buffer.readLine());
    }

    private void readKeysFromHeader(String line) {
        this.keyStrs = line.split(this.token);
        this.keys = new Hashtable(this.keyStrs.length);
        int i = 0;
        while (i < this.keyStrs.length) {
            this.keys.put(this.keyStrs[i], "");
            ++i;
        }
    }

    public boolean containsKey(String string) {
        return this.keys.containsKey(string);
    }

    public int size() {
        return this.keys.size();
    }

    public Set getKeys() {
        return this.keys.keySet();
    }

    public boolean hasNext() throws IOException {
        String line = this.buffer.readLine();
        if (line != null) {
            String[] values = line.split(this.token);
            int i = 0;
            while (i < values.length) {
                if (this.notEmptyField(values[i])) {
                    this.keys.put(this.keyStrs[i], values[i]);
                } else {
                    this.keys.put(this.keyStrs[i], "");
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean notEmptyField(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ' ') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String get(String key) {
        return (String)this.keys.get(key);
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

