/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.entity.GeneticMap;

public final class MapDBFactory {
    public static IBioGenome[] read(Reader reader) throws IOException {
        int i;
        if (reader == null) {
            return null;
        }
        BufferedReader buffer = null;
        StringTokenizer token = null;
        String line = null;
        String sbuff = null;
        String[] propKeys = null;
        IBioGenome[] maps = null;
        GeneticMap map = null;
        Properties properties = null;
        ArrayList<GeneticMap> mapList = null;
        buffer = new BufferedReader(reader);
        line = buffer.readLine();
        if (line == null) {
            return maps;
        }
        token = new StringTokenizer(line);
        if (token.countTokens() >= 1) {
            sbuff = token.nextToken();
            if (sbuff.equalsIgnoreCase("map")) {
                propKeys = new String[token.countTokens()];
                i = 0;
                while (token.hasMoreTokens()) {
                    propKeys[i++] = token.nextToken();
                }
            } else {
                throw new IOException("Bad header format : first field must be called 'map'");
            }
        }
        int cnt = 1;
        while ((line = buffer.readLine()) != null) {
            token = new StringTokenizer(line);
            if (token.countTokens() == propKeys.length + 1) {
                map = new GeneticMap();
                map.setName(token.nextToken());
                properties = map.getProperties();
                i = 0;
                while (token.hasMoreTokens()) {
                    properties.setProperty(propKeys[i++], token.nextToken());
                }
                map.setProperties(properties);
                if (mapList == null) {
                    mapList = new ArrayList<GeneticMap>();
                }
            } else {
                throw new IOException("Bad line format at " + cnt);
            }
            mapList.add(map);
            ++cnt;
        }
        buffer.close();
        reader.close();
        if (mapList != null) {
            maps = new IBioGenome[mapList.size()];
            mapList.toArray(maps);
        }
        return maps;
    }
}

