/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.bio.util.NumberFormat;

public class MetaQtlAnalysisSummaryFactory {
    public static void write(MetaQtlAnalysis analysis, OutputStream stream) throws IOException {
        if (analysis == null) {
            return;
        }
        if (stream == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream));
        int nchr = analysis.nchr;
        writer.print("Chromosome\t");
        writer.print("Trait\t");
        writer.print("K\t");
        writer.print("Criterion\t");
        writer.print("Value\t");
        writer.print("Delta\t");
        writer.println("Weight");
        int i = 0;
        while (i < nchr) {
            MetaQtlResult[] results = analysis.resultByChrom[i];
            int j = 0;
            while (j < results.length) {
                if (results[j] != null) {
                    int[] K = results[j].getKValues();
                    Iterator iter = results[j].getCriteria();
                    while (iter.hasNext()) {
                        String criterion = (String)iter.next();
                        double[] values = results[j].getCritValues(criterion, K);
                        double[] delta = results[j].getCritDelta(criterion, K);
                        double[] weights = results[j].getCritWeights(criterion, K);
                        int l = 0;
                        while (l < K.length) {
                            MetaQtlAnalysisSummaryFactory.write_line(writer, analysis.chromNames[i], results[j].trait, criterion, K[l], values[l], delta[l], weights[l]);
                            ++l;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        writer.flush();
        writer.close();
    }

    private static void write_line(PrintWriter writer, String chrom, String trait, String criterion, int k, double value, double delta, double weight) {
        writer.print(String.valueOf(chrom) + "\t");
        writer.print(String.valueOf(trait) + "\t");
        writer.print(String.valueOf(k) + "\t");
        writer.print(String.valueOf(criterion) + "\t");
        writer.print(String.valueOf(NumberFormat.formatDouble(value)) + "\t");
        writer.print(String.valueOf(NumberFormat.formatDouble(delta)) + "\t");
        writer.println(NumberFormat.formatDouble(weight));
        writer.flush();
    }
}

