/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.metaqtl.graph.PaletteColor;

public final class MetaGraphPar {
    public static double LAYER_HSPACE = 20.0;
    public static double LAYER_VSPACE = 20.0;
    public static double DEFAULT_WIDTH = 600.0;
    public static double DEFAULT_HEIGHT = 400.0;
    public static Color BACKGROUND_COLOR = Color.WHITE;
    public static double QTL_VSPACE = 20.0;
    public static double QTL_HSPACE = 10.0;
    public static double QTL_TREE_SPACE = 50.0;
    public static double TREE_NODE_WIDTH = 5.0;
    public static boolean WITH_QTL_NAME = true;
    public static Font QTL_NAME_FONT = new Font("Verdana", 0, 10);
    public static Font MARKER_NAME_FONT = new Font("Verdana", 0, 10);
    public static Font MARKER_POSITION_FONT = new Font("Verdana", 0, 10);
    public static Font CHROM_NAME_FONT = new Font("Verdana", 1, 12);
    public static Color QTL_NAME_COLOR = Color.BLACK;
    public static double QTL_NAME_VSPACE_CEX = 1.0;
    public static boolean WITH_MAP_NAME = true;
    public static boolean WITH_CHROM_NAME = true;
    public static double QTL_PCH_SIZE = 5.0;
    public static boolean WITH_LEGEND = true;
    public static double QTL_TICK_WIDTH_CEX = 0.1;
    public static Color[] QTL_PALETTE = null;
    public static Color[] PROBA_PALETTE = null;
    public static int PROBA_BIN = 20;
    public static double CHROM_WIDTH = 30.0;
    public static double QTL_CI_WIDTH = 10.0;
    public static double CHROM_NAME_HSPACE = 20.0;
    public static boolean WITH_MARKER_NAME = true;
    public static int CHROM_ALIGN_MODE = 1;
    public static boolean WITH_MARKER_POSITION = true;
    public static double CHROM_FLANKING_CEX = 0.1;
    public static Stroke CHROM_STROKE = new BasicStroke();
    public static Stroke CHROM_TICK_STROKE = new BasicStroke();
    public static double MAKER_NAME_VSPACE = 1.0;
    public static Color CHROM_STROKE_COLOR = Color.BLACK;
    public static double CHROM_TICK_WIDTH_1 = 10.0;
    public static double CHROM_TICK_WIDTH_2 = 20.0;
    public static double CHROM_TICK_WIDTH_3 = 10.0;
    public static double QTL_POS_HEIGHT_CEX = 0.01;
    public static double QTL_POS_WIDTH_CEX = 1.5;
    public static Color CHROM_TICK_COLOR = Color.BLACK;
    public static double QTL_NAME_SPACE = 30.0;
    public static double CHROM_DISTANCE_SCALE = 5.0;
    public static double QTL_CI_WIDTH_CEX = 0.25;
    public static double QTL_PROB_WIDTH = 20.0;
    public static Font LEGEND_FONT = new Font("Verdana", 0, 10);
    public static double LEGEND_PART_HEIGHT = 20.0;
    public static double LEGEND_PART_WIDTH = 50.0;
    public static double LEGEND_HSPACE = 5.0;
    public static double LEGEND_BOX_CEX = 0.5;
    public static int LEGEND_SCALE_UNIT = 5;
    public static boolean WITH_COMMON_MARKER = false;
    private static ArrayList QTL_COLOR_LIST;
    public static Color PROBA_FROM_COLOR;
    public static Color PROBA_TO_COLOR;
    public static Color SINGLE_COMMON_COLOR;
    public static Color POS_COMMON_COLOR;
    public static Color NEG_COMMON_COLOR;
    public static double COMMON_STROKE_WIDTH;
    public static double LEGEND_GRAD_HEIGHT;
    public static double LEGEND_GRAD_WIDTH;
    public static double QTL_TREE_SCALE;

    static {
        PROBA_FROM_COLOR = Color.WHITE;
        PROBA_TO_COLOR = Color.RED;
        SINGLE_COMMON_COLOR = Color.GRAY;
        POS_COMMON_COLOR = Color.BLUE;
        NEG_COMMON_COLOR = Color.RED;
        COMMON_STROKE_WIDTH = 5.0;
        LEGEND_GRAD_HEIGHT = 10.0;
        LEGEND_GRAD_WIDTH = 50.0;
        QTL_TREE_SCALE = 1.0;
    }

    private MetaGraphPar() {
    }

    public static void set(String parameter, String value) throws IllegalArgumentException {
        if (parameter.equals("LAYER_HSPACE")) {
            LAYER_HSPACE = Double.parseDouble(value);
        }
        if (parameter.equals("LAYER_VSPACE")) {
            LAYER_VSPACE = Double.parseDouble(value);
        }
        if (parameter.equals("BACKGROUND_COLOR")) {
            BACKGROUND_COLOR = MetaGraphPar.string2color(value);
        }
        if (parameter.equals("QTL_HSPACE")) {
            QTL_HSPACE = Double.parseDouble(value);
        }
        if (parameter.equals("QTL_VSPACE")) {
            QTL_VSPACE = Double.parseDouble(value);
        }
        if (parameter.equals("QTL_TREE_SPACE")) {
            QTL_TREE_SPACE = Double.parseDouble(value);
        }
        if (parameter.equals("QTL_TREE_SCALE")) {
            QTL_TREE_SCALE = Double.parseDouble(value);
        }
        if (parameter.equals("QTL_NAME_WITH")) {
            WITH_QTL_NAME = Boolean.parseBoolean(value);
        }
        if (parameter.equals("QTL_NAME_FONT")) {
            QTL_NAME_FONT = MetaGraphPar.string2font(value);
        }
        if (parameter.equals("MARKER_NAME_FONT")) {
            MARKER_NAME_FONT = MetaGraphPar.string2font(value);
        }
        if (parameter.equals("MARKER_POSITION_FONT")) {
            MARKER_POSITION_FONT = MetaGraphPar.string2font(value);
        }
        if (parameter.equals("CHROM_NAME_FONT")) {
            CHROM_NAME_FONT = MetaGraphPar.string2font(value);
        }
        if (parameter.equals("CHROM_WIDTH")) {
            CHROM_WIDTH = Double.parseDouble(value);
        }
        if (parameter.equals("CHROM_FLANKING_CEX")) {
            CHROM_FLANKING_CEX = Double.parseDouble(value);
        }
        if (parameter.equals("CHROM_TICK_WIDTH_1")) {
            CHROM_TICK_WIDTH_1 = Double.parseDouble(value);
        }
        if (parameter.equals("CHROM_TICK_WIDTH_2")) {
            CHROM_TICK_WIDTH_2 = Double.parseDouble(value);
        }
        if (parameter.equals("CHROM_TICK_WIDTH_3")) {
            CHROM_TICK_WIDTH_3 = Double.parseDouble(value);
        }
        if (parameter.equals("CHROM_TICK_COLOR")) {
            CHROM_TICK_COLOR = MetaGraphPar.string2color(value);
        }
        if (parameter.equals("CHROM_DISTANCE_SCALE")) {
            CHROM_DISTANCE_SCALE = Double.parseDouble(value);
        }
        if (parameter.equals("COMMON_STROKE_WIDTH")) {
            COMMON_STROKE_WIDTH = Double.parseDouble(value);
        }
        if (parameter.equals("CHROM_ALIGN_MODE")) {
            CHROM_ALIGN_MODE = Integer.parseInt(value);
        }
        if (parameter.startsWith("QTL_COLOR")) {
            if (QTL_COLOR_LIST == null) {
                QTL_COLOR_LIST = new ArrayList();
            }
            QTL_COLOR_LIST.add(MetaGraphPar.string2color(value));
        }
        if (parameter.equals("PROBA_BIN")) {
            PROBA_BIN = Integer.parseInt(value);
        }
        if (parameter.equals("PROBA_FROM_COLOR")) {
            PROBA_FROM_COLOR = MetaGraphPar.string2color(value);
        }
        if (parameter.equals("PROBA_TO_COLOR")) {
            PROBA_TO_COLOR = MetaGraphPar.string2color(value);
        }
        if (parameter.equals("SINGLE_COMMON_COLOR")) {
            SINGLE_COMMON_COLOR = MetaGraphPar.string2color(value);
        }
        if (parameter.equals("POS_COMMON_COLOR")) {
            POS_COMMON_COLOR = MetaGraphPar.string2color(value);
        }
        if (parameter.equals("NEG_COMMON_COLOR")) {
            NEG_COMMON_COLOR = MetaGraphPar.string2color(value);
        }
        if (parameter.equals("WITH_CHROM_NAME")) {
            WITH_CHROM_NAME = Boolean.parseBoolean(value);
        }
        if (parameter.equals("WITH_COMMON_MARKER")) {
            WITH_COMMON_MARKER = Boolean.parseBoolean(value);
        }
        if (parameter.equals("WITH_LEGEND")) {
            WITH_LEGEND = Boolean.parseBoolean(value);
        }
        if (parameter.equals("WITH_MAP_NAME")) {
            WITH_MAP_NAME = Boolean.parseBoolean(value);
        }
        if (parameter.equals("WITH_MARKER_NAME")) {
            WITH_MARKER_NAME = Boolean.parseBoolean(value);
        }
        if (parameter.equals("WITH_QTL_NAME")) {
            WITH_QTL_NAME = Boolean.parseBoolean(value);
        }
        if (parameter.equals("WITH_MARKER_POSITION")) {
            WITH_MARKER_POSITION = Boolean.parseBoolean(value);
        }
        if (parameter.equals("LEGEND_GRAD_HEIGHT")) {
            LEGEND_GRAD_HEIGHT = Double.parseDouble(value);
        }
        if (parameter.equals("LEGEND_GRAD_WIDTH")) {
            LEGEND_GRAD_WIDTH = Double.parseDouble(value);
        }
    }

    public static Color string2color(String value) {
        int[] rgb = MetaGraphPar.parseRGB(value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static String color2string(Color color) {
        if (color == null) {
            return new String("ffffff");
        }
        String colStr = new String("");
        String rStr = Integer.toHexString(color.getRed());
        colStr = rStr.length() == 1 ? String.valueOf(colStr) + "0" + rStr : String.valueOf(colStr) + rStr;
        String gStr = Integer.toHexString(color.getGreen());
        colStr = gStr.length() == 1 ? String.valueOf(colStr) + "0" + gStr : String.valueOf(colStr) + gStr;
        String bStr = Integer.toHexString(color.getBlue());
        colStr = bStr.length() == 1 ? String.valueOf(colStr) + "0" + bStr : String.valueOf(colStr) + bStr;
        return colStr;
    }

    public static Font string2font(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ":", false);
        String fontName = tokenizer.nextToken();
        String fontStyle = tokenizer.nextToken();
        int style = 0;
        if (fontStyle.equals("ITALIC")) {
            style = 2;
        } else if (fontStyle.equals("BOLD")) {
            style = 1;
        }
        int size = Integer.parseInt(tokenizer.nextToken());
        return new Font(fontName, style, size);
    }

    public static String font2string(Font font) {
        String styStr;
        String fontStr = font.getName();
        switch (font.getStyle()) {
            case 2: {
                styStr = new String(":ITALIC");
                break;
            }
            case 1: {
                styStr = new String(":BOLD");
                break;
            }
            default: {
                styStr = new String(":PLAIN");
            }
        }
        fontStr = String.valueOf(fontStr) + styStr;
        fontStr = String.valueOf(fontStr) + ":" + Integer.toString(font.getSize());
        return fontStr;
    }

    private static int[] parseRGB(String value) {
        String r = value.substring(0, 2);
        String g = value.substring(2, 4);
        String b = value.substring(4, 6);
        int[] rgb = new int[]{MetaGraphPar.parseHexa(r), MetaGraphPar.parseHexa(g), MetaGraphPar.parseHexa(b)};
        return rgb;
    }

    private static int parseHexa(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static Color getProbaColor(double d) {
        double h = 1.0 / (double)PROBA_BIN;
        int cidx = d == 1.0 ? PROBA_BIN - 1 : (int)Math.floor(d / h);
        return PROBA_PALETTE[cidx];
    }

    public static Color getProbaColor(double d, double thresh) {
        if (d >= thresh) {
            return PROBA_PALETTE[PROBA_BIN - 1];
        }
        return PROBA_PALETTE[0];
    }

    public static void initProbaPalette() {
        PROBA_PALETTE = PaletteColor.getPaletteGradient(PROBA_BIN, PROBA_FROM_COLOR, PROBA_TO_COLOR);
    }

    public static void initQTLPalette() {
        if (QTL_COLOR_LIST == null || QTL_COLOR_LIST.size() < 1) {
            return;
        }
        QTL_PALETTE = new Color[QTL_COLOR_LIST.size()];
        int i = 0;
        while (i < QTL_PALETTE.length) {
            MetaGraphPar.QTL_PALETTE[i] = (Color)QTL_COLOR_LIST.get(i);
            ++i;
        }
    }

    public static void initQTLPalette(int n) {
        QTL_PALETTE = PaletteColor.getPalette(n);
    }

    public static void initPalettes() {
        MetaGraphPar.initProbaPalette();
        MetaGraphPar.initQTLPalette();
    }
}

