/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.File;
import java.io.IOException;
import org.metaqtl.CMarkerSequence;
import org.metaqtl.ChromCluster;
import org.metaqtl.Chromosome;
import org.metaqtl.MapCluster;
import org.metaqtl.algo.CMSAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.graph.ChromGraph;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public class MMapView
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: MMapView [{-m, --mapdir}] [{-r, --refmap] [{-c, --chr}] [{-q, --withqtl}] [{--qmode}][{--htest}] [{--hth}] [{-t, --tonto}] [{-p, --par}][{--img}][{-o, --outstem}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        MetaMain.printLicense("MMapDraw", VERSION);
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-m, --mapdir    : the directory of the XML files for the input maps");
        System.out.println("-r, --refmap    : the XML file for the reference map");
        System.out.println("-c, --chr       : the chromosome(s) to draw");
        System.out.println("-q, --withqtl   : draw also the QTL");
        System.out.println("--qmode         : QTL representation mode");
        System.out.println("    --htest     : test distance homogeneity between maps (only with -r)");
        System.out.println("    --hth       : threshold p-value of the homogeneity test");
        System.out.println("-t, --tonto     : the XML file for the trait ontology");
        System.out.println("    --mrkt      : threshold on the occurence of the markers");
        System.out.println("-p, --par       : the file location of the plot parameters");
        System.out.println("-o, --outstem   : the output stem");
        System.out.println("--img           : the format name of the image among this list");
        MetaMain.printImgFormat(16);
    }

    public static void main(String[] args) {
        ChromCluster[] clusters;
        ChromCluster[] clust2draw;
        MMapView program = new MMapView();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option amapDir = parser.addStringOption('m', "mapdir");
        CmdLineParser.Option arefFile = parser.addStringOption('r', "refmap");
        CmdLineParser.Option achrName = parser.addStringOption('c', "chr");
        CmdLineParser.Option awithQtl = parser.addBooleanOption('q', "withqtl");
        CmdLineParser.Option amodeQtl = parser.addIntegerOption("qmode");
        CmdLineParser.Option ahDist = parser.addBooleanOption("htest");
        CmdLineParser.Option ahThresh = parser.addDoubleOption("hth");
        CmdLineParser.Option aontoFile = parser.addStringOption('t', "tonto");
        CmdLineParser.Option amrkThresh = parser.addIntegerOption("mrkt");
        CmdLineParser.Option aparFile = parser.addStringOption('p', "par");
        CmdLineParser.Option aimgFormat = parser.addStringOption("img");
        CmdLineParser.Option aoutStem = parser.addStringOption('o', "outstem");
        program.parseCmdLine(args);
        String mapDir = (String)parser.getOptionValue(amapDir);
        String refFile = (String)parser.getOptionValue(arefFile);
        String chrList = (String)parser.getOptionValue(achrName);
        Boolean withQtl = (Boolean)parser.getOptionValue(awithQtl, new Boolean(false));
        Integer modeQtl = (Integer)parser.getOptionValue(amodeQtl, new Integer(1));
        Boolean hDist = (Boolean)parser.getOptionValue(ahDist, new Boolean(false));
        Double hThresh = (Double)parser.getOptionValue(ahThresh, new Double(0.0));
        String ontoFile = (String)parser.getOptionValue(aontoFile);
        Integer mrkThresh = (Integer)parser.getOptionValue(amrkThresh, new Integer(1));
        String parFile = (String)parser.getOptionValue(aparFile);
        String imgFormat = (String)parser.getOptionValue(aimgFormat, "jpeg");
        String outStem = (String)parser.getOptionValue(aoutStem);
        if (mapDir == null) {
            System.err.println("[ ERROR ] No map directory defined");
            System.exit(2);
        }
        if (outStem == null) {
            System.err.println("[ ERROR ] No output stem defined");
            System.exit(2);
        }
        IBioGenome[] maps = null;
        IBioGenome refmap = null;
        IBioOntology ontology = null;
        String[] chromNames = null;
        try {
            refmap = MMapView.getMap(refFile);
            maps = MMapView.getMaps(mapDir);
            ontology = MMapView.getOntology(ontoFile, 'x');
            chromNames = MMapView.parseChromList(chrList);
            MMapView.setParameter(parFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (maps == null) {
            System.err.println("[ ERROR ] Unable to load maps from " + mapDir);
            System.exit(3);
        }
        MapCluster mapCluster = new MapCluster();
        int i = 0;
        while (i < maps.length) {
            mapCluster.addMap(maps[i], false);
            ++i;
        }
        if (refmap != null) {
            mapCluster.addMap(refmap, true);
        }
        if ((clust2draw = MMapView.getClusterByNames(clusters = mapCluster.getClusters(), chromNames)) == null) {
            clust2draw = clusters;
        }
        int i2 = 0;
        while (i2 < clust2draw.length) {
            clust2draw[i2].setMrkThresh(mrkThresh);
            clust2draw[i2].fixCluster();
            Chromosome[] chromosomes = clust2draw[i2].getClusterMembers();
            if (refmap != null && hDist.booleanValue()) {
                MMapView.testDistanceHomogeneity(chromosomes, hThresh);
            }
            ChromGraph[] chromGraphs = MMapView.getChromGraph(chromosomes, withQtl, modeQtl, ontology, null);
            try {
                File outFile = MMapView.getOutFile(outStem, clust2draw[i2].getName(), imgFormat);
                MMapView.writeImg(chromGraphs, outFile, imgFormat);
                outFile = MMapView.getParFile(outStem, clust2draw[i2].getName());
                MMapView.writePar(outFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        System.exit(0);
    }

    private static void testDistanceHomogeneity(Chromosome[] chromosomes, double thresh) {
        boolean doThresh = thresh > 0.0 && thresh < 1.0;
        Chromosome skeleton = MMapView.getSkeleton(chromosomes);
        Chromosome[] others = MMapView.getOthers(chromosomes, skeleton);
        int j = 0;
        while (j < others.length) {
            CMarkerSequence cms = CMSAlgorithm.run(others[j], skeleton);
            double[] hetero = Chromosome.getDistHeterogeneity(cms.nmc, cms.mcidx, others[j], skeleton);
            double[][] proba = new double[cms.nmc - 1][3];
            int k = 0;
            while (k < cms.nmc - 1) {
                proba[k][0] = others[j].getDistance(cms.mcidx[0][k]);
                proba[k][1] = others[j].getDistance(cms.mcidx[0][k + 1]);
                if (doThresh && hetero[k] >= thresh) {
                    proba[k][2] = 1.0;
                }
                proba[k][2] = doThresh && hetero[k] < thresh ? 0.0 : hetero[k];
                ++k;
            }
            others[j].setProba(proba);
            ++j;
        }
    }

    private static Chromosome getSkeleton(Chromosome[] chroms) {
        if (chroms == null) {
            return null;
        }
        int i = 0;
        while (i < chroms.length) {
            if (chroms[i].skeleton) {
                return chroms[i];
            }
            ++i;
        }
        return null;
    }

    private static Chromosome[] getOthers(Chromosome[] chroms, Chromosome skeleton) {
        if (chroms == null || chroms.length <= 1) {
            return null;
        }
        Chromosome[] others = new Chromosome[chroms.length - 1];
        int j = 0;
        int i = 0;
        while (i < chroms.length) {
            if (!chroms[i].equals(skeleton)) {
                others[j++] = chroms[i];
            }
            ++i;
        }
        return others;
    }

    private static File getOutFile(String outStem, String name, String imgFormat) {
        return new File(String.valueOf(outStem) + "_" + name + "." + imgFormat);
    }

    private static File getParFile(String outStem, String name) {
        return new File(String.valueOf(outStem) + "_" + name + ".par");
    }
}

