/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.IOException;
import org.metaqtl.Chromosome;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlModel;
import org.metaqtl.Qtl;
import org.metaqtl.adapter.ChromosomeAdapter;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public class QTLModel
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: QTLModel [{-m, --map}]] [{-r, --clust}]] [{-b, --best}]] [{-o, --outfile}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        System.out.println("QTLModel1.0, Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println("QTLModel comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome to redistribute it");
        System.out.println("under certain conditions;");
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-m, --map    : the file location of the map");
        System.out.println("-r, --clust  : the file location of the clustering result");
        System.out.println("-b, --best   : the file location of the best clustering");
        System.out.println("-o, --outfile: the output file");
    }

    public static void main(String[] args) {
        QTLModel program = new QTLModel();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option amapFile = parser.addStringOption('m', "map");
        CmdLineParser.Option aresFile = parser.addStringOption('r', "clust");
        CmdLineParser.Option acluFile = parser.addStringOption('b', "best");
        CmdLineParser.Option aoutFile = parser.addStringOption('o', "outfile");
        program.parseCmdLine(args);
        String mapFile = (String)parser.getOptionValue(amapFile);
        String resFile = (String)parser.getOptionValue(aresFile);
        String cluFile = (String)parser.getOptionValue(acluFile);
        String outFile = (String)parser.getOptionValue(aoutFile);
        if (mapFile == null) {
            System.err.println("[ ERROR ] No map file defined");
            System.exit(2);
        }
        if (resFile == null) {
            System.err.println("[ ERROR ] No result file defined");
            System.exit(2);
        }
        if (cluFile == null) {
            System.err.println("[ ERROR ] No best model defined");
            System.exit(2);
        }
        if (outFile == null) {
            System.err.println("[ ERROR ] No output stem file defined");
            System.exit(2);
        }
        IBioGenome map = null;
        MetaQtlAnalysis result = null;
        MetaQtlModel cluster = null;
        try {
            map = QTLModel.getMap(mapFile);
            result = QTLModel.getResult(resFile);
            cluster = QTLModel.getCluster(cluFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (map == null) {
            System.err.println("[ ERROR ]  Unable to load map from " + mapFile);
            System.exit(4);
        }
        if (result == null) {
            System.err.println("[ ERROR ]  Unable to load result from " + resFile);
            System.exit(4);
        }
        if (cluster == null) {
            System.err.println("[ ERROR ]  Unable to load best model from " + cluFile);
            System.exit(4);
        }
        Chromosome[] chromosomes = ChromosomeAdapter.toChromosomes(map);
        int i = 0;
        while (i < chromosomes.length) {
            Chromosome chrom = chromosomes[i];
            String[] traits = cluster.getTraitNames(chrom.getName());
            if (traits != null) {
                int j = 0;
                while (j < traits.length) {
                    int kclust = cluster.getModel(chrom.getName(), traits[j]);
                    Qtl[] mqtls = result.getMetaQtl(chrom.getName(), traits[j], kclust);
                    chrom.attachQtl(mqtls);
                    ++j;
                }
            }
            ++i;
        }
        map = ChromosomeAdapter.toIBioGenome(chromosomes, 0);
        try {
            QTLModel.writeMap(map, outFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(5);
        }
        System.exit(0);
    }
}

