/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.numrec;

public strictfp final class NumericalUtilities {
    public static double[] GAMCOF = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
    private static final int ITMAX = 100;
    private static final double EPS = 3.0E-8;
    private static final int NTAB = 10;
    private static final double BIG = 1.0E30;
    private static final double CON = 1.4;
    private static final double CON2 = 1.9599999999999997;
    private static final double SAFE = 2.0;

    public static double SIGN(double a, double b) {
        return b > 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    public static double DMAX(double a, double b) {
        return a > b ? a : b;
    }

    public static int IMIN(int a, int b) {
        return a < b ? a : b;
    }

    public static double PYTHAG(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            return absa * Math.sqrt(1.0 + NumericalUtilities.SQR(absb / absa));
        }
        return absb == 0.0 ? 0.0 : absb * Math.sqrt(1.0 + NumericalUtilities.SQR(absa / absb));
    }

    public static double SQR(double a) {
        return a == 0.0 ? 0.0 : a * a;
    }

    public static double gauss(double x) {
        return Math.exp(-0.5 * x * x) / Math.sqrt(Math.PI * 2);
    }

    public static double sd2ci(double sd) {
        return sd * 2.0 * 1.96;
    }

    public static double ci2sd(double ci) {
        return ci / 3.92;
    }

    public static double gammln(double xx) {
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.0;
        int j = 0;
        while (j <= 5) {
            ser += GAMCOF[j] / (x += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.50662827465 * ser);
    }

    public static double gammp(double a, double x) {
        if (x < 0.0 || a <= 0.0) {
            return 0.0;
        }
        if (x < a + 1.0) {
            double[] y = NumericalUtilities.gser(a, x);
            return y[0];
        }
        double[] y = NumericalUtilities.gcf(a, x);
        return 1.0 - y[0];
    }

    public static double[] gcf(double a, double x) {
        double gold = 0.0;
        double fac = 1.0;
        double b1 = 1.0;
        double b0 = 0.0;
        double a0 = 1.0;
        double[] ret = new double[2];
        ret[1] = NumericalUtilities.gammln(a);
        double a1 = x;
        int n = 1;
        while (n <= 100) {
            double an = n;
            double ana = an - a;
            a0 = (a1 + a0 * ana) * fac;
            b0 = (b1 + b0 * ana) * fac;
            double anf = an * fac;
            a1 = x * a0 + anf * a1;
            b1 = x * b0 + anf * b1;
            if (a1 != 0.0) {
                fac = 1.0 / a1;
                double g = b1 * fac;
                if (Math.abs((g - gold) / g) < 3.0E-8) {
                    ret[0] = Math.exp(-x + a * Math.log(x) - ret[1]) * g;
                    return ret;
                }
                gold = g;
            }
            ++n;
        }
        return ret;
    }

    public static double[] gser(double a, double x) {
        double sum;
        double[] ret = new double[2];
        ret[1] = NumericalUtilities.gammln(a);
        if (x <= 0.0) {
            if (x < 0.0) {
                ret[0] = 0.0;
            }
            return ret;
        }
        double ap = a;
        double del = sum = 1.0 / a;
        int n = 1;
        while (n <= 100) {
            sum += (del *= x / (ap += 1.0));
            if (Math.abs(del) < Math.abs(sum) * 3.0E-8) {
                ret[0] = sum * Math.exp(-x + a * Math.log(x) - ret[1]);
                return ret;
            }
            ++n;
        }
        return ret;
    }

    public static double betacf(double a, double b, double x) {
        double bm = 1.0;
        double az = 1.0;
        double am = 1.0;
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double bz = 1.0 - qab * x / qap;
        int m = 1;
        while (m <= 100) {
            double em = m;
            double tem = em + em;
            double d = em * (b - em) * x / ((qam + tem) * (a + tem));
            double ap = az + d * am;
            double bp = bz + d * bm;
            d = -(a + em) * (qab + em) * x / ((qap + tem) * (a + tem));
            double app = ap + d * az;
            double bpp = bp + d * bz;
            double aold = az;
            am = ap / bpp;
            bm = bp / bpp;
            az = app / bpp;
            bz = 1.0;
            if (Math.abs(az - aold) < 3.0E-8 * Math.abs(az)) {
                return az;
            }
            ++m;
        }
        return 0.0;
    }

    public static double betai(double a, double b, double x) {
        if (x < 0.0 || x > 1.0) {
            return 0.0;
        }
        double bt = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(NumericalUtilities.gammln(a + b) - NumericalUtilities.gammln(a) - NumericalUtilities.gammln(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * NumericalUtilities.betacf(a, b, x) / a;
        }
        return 1.0 - bt * NumericalUtilities.betacf(b, a, 1.0 - x) / b;
    }

    public static double beta(double z, double w) {
        return Math.exp(NumericalUtilities.gammln(z) + NumericalUtilities.gammln(w) - NumericalUtilities.gammln(z + w));
    }

    public static void indexx(int n, double[] arrin, int[] indx) {
        int j = 1;
        while (j <= n) {
            indx[j] = j;
            ++j;
        }
        int l = (n >> 1) + 1;
        int ir = n;
        while (true) {
            double q;
            int indxt;
            if (l > 1) {
                indxt = indx[--l];
                q = arrin[indxt];
            } else {
                indxt = indx[ir];
                q = arrin[indxt];
                indx[ir] = indx[1];
                if (--ir == 1) {
                    indx[1] = indxt;
                    return;
                }
            }
            int i = l;
            j = l << 1;
            while (j <= ir) {
                if (j < ir && arrin[indx[j]] < arrin[indx[j + 1]]) {
                    ++j;
                }
                if (q < arrin[indx[j]]) {
                    indx[i] = indx[j];
                    i = j;
                    j += i;
                    continue;
                }
                j = ir + 1;
            }
            indx[i] = indxt;
        }
    }

    public static double rtsafe(NRFunction funcd, double x1, double x2, double xacc) {
        double dxold;
        double xh;
        double xl;
        funcd.funcd(x1);
        double f1 = funcd.getF();
        funcd.funcd(x2);
        double fh = funcd.getDF();
        if (f1 > 0.0 && fh > 0.0 || f1 < 0.0 && fh < 0.0) {
            System.err.println("Root must be bracketed in rtsafe");
            return 0.0;
        }
        if (f1 == 0.0) {
            return x1;
        }
        if (fh == 0.0) {
            return x2;
        }
        if (f1 < 0.0) {
            xl = x1;
            xh = x2;
        } else {
            xh = x1;
            xl = x2;
        }
        double rts = 0.5 * (x1 + x2);
        double dx = dxold = Math.abs(x2 - x1);
        funcd.funcd(rts);
        double f = funcd.getF();
        double df = funcd.getDF();
        int j = 1;
        while (j <= 100) {
            if (((rts - xh) * df - f) * ((rts - x1) * df - f) > 0.0 || Math.abs(2.0 * f) > Math.abs(dxold * df)) {
                dxold = dx;
                dx = 0.5 * (xh - xl);
                rts = xl + dx;
                if (xl == rts) {
                    return rts;
                }
            } else {
                dxold = dx;
                double temp = rts;
                dx = f / df;
                if (temp == (rts -= dx)) {
                    return rts;
                }
            }
            if (Math.abs(dx) < xacc) {
                return rts;
            }
            funcd.funcd(rts);
            f = funcd.getF();
            df = funcd.getDF();
            if (f < 0.0) {
                xl = rts;
            } else {
                xh = rts;
            }
            ++j;
        }
        System.err.println("Maximum number of iterations exceeded in rtsafe");
        return 0.0;
    }

    public static double dfridr(Function f, double x, double h) {
        if (h == 0.0) {
            return 0.0;
        }
        double[][] a = new double[11][11];
        double hh = h;
        double d = (f.func(x + hh) - f.func(x - hh)) / (2.0 * hh);
        a[1][1] = d;
        double ans = d;
        double err = 1.0E30;
        int i = 2;
        while (i <= 10) {
            a[1][i] = (f.func(x + (hh /= 1.4)) - f.func(x - hh)) / (2.0 * hh);
            double fac = 1.9599999999999997;
            int j = 2;
            while (j <= i) {
                a[j][i] = (a[j - 1][i] * fac - a[j - 1][i - 1]) / (fac - 1.0);
                fac *= 1.9599999999999997;
                double errt = Math.max(Math.abs(a[j][i] - a[j - 1][i]), Math.abs(a[j][i] - a[j - 1][i - 1]));
                if (errt <= err) {
                    err = errt;
                    ans = a[j][i];
                }
                ++j;
            }
            if (Math.abs(a[i][i] - a[i - 1][i - 1]) >= 2.0 * err) break;
            ++i;
        }
        f.setDF(ans);
        return err;
    }

    public static void ISWAP(int[] a, int i, int j) {
        int tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void DSWAP(double[] a, int i, int j) {
        double tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static interface Function {
        public double func(double var1);

        public double getDF();

        public void setDF(double var1);
    }

    public static interface NRFunction {
        public void funcd(double var1);

        public double getF();

        public double getDF();
    }
}

