/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.util;

import java.util.Properties;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.entity.CrossPopulation;
import org.metaqtl.bio.util.BioCrossTypes;

public final class GeneticMapProperties {
    public static int getMappingFunction(IBioGenome map) {
        String mapping = map.getProperties().getProperty("mapping.function");
        if (mapping != null) {
            if (mapping.equals("haldane")) {
                return 1;
            }
            if (mapping.equals("kosambi")) {
                return 2;
            }
        }
        return 1;
    }

    public static CrossPopulation getCrossDesign(IBioGenome map) {
        int gen;
        int type;
        String value = map.getProperties().getProperty("cross.size");
        int size = value == null ? 0 : Integer.parseInt(value);
        value = map.getProperties().getProperty("cross.type");
        if (value == null) {
            type = 0;
            gen = 0;
        } else {
            BioCrossTypes.parseCross(value);
            type = BioCrossTypes.type;
            gen = BioCrossTypes.gen;
        }
        CrossPopulation cross = new CrossPopulation();
        cross.setCrossType(type);
        cross.setSize(size);
        cross.setGeneration(gen);
        return cross;
    }

    public static int getMappingUnit(IBioGenome map) {
        String mapping = map.getProperties().getProperty("mapping.unit");
        if (mapping != null) {
            if (mapping.equals("M")) {
                return 1;
            }
            if (mapping.equals("cM")) {
                return 2;
            }
        }
        return 2;
    }

    public static boolean needToBeRescaled(IBioGenome map) {
        String mapping = map.getProperties().getProperty("mapping.expansion");
        if (mapping != null) {
            return mapping.equals("1");
        }
        return false;
    }

    public static void setMappingContext(IBioGenome map, int mapping_function, int mapping_unit) {
        Properties prop = map.getProperties();
        if (prop == null) {
            prop = new Properties();
        }
        if (mapping_function == 1) {
            prop.setProperty("mapping.function", "haldane");
        }
        if (mapping_function == 2) {
            prop.setProperty("mapping.function", "kosambi");
        }
        if (mapping_unit == 1) {
            prop.setProperty("mapping.unit", "M");
        }
        if (mapping_unit == 2) {
            prop.setProperty("mapping.unit", "cM");
        }
    }

    public static void setCrossDesign(IBioGenome map, CrossPopulation crossDesign) {
        Properties prop = map.getProperties();
        if (prop == null) {
            prop = new Properties();
        }
        prop.setProperty("cross.size", Integer.toString(crossDesign.getSize()));
        String code = BioCrossTypes.crossToString(crossDesign.getCrossType(), crossDesign.getGeneration());
        prop.setProperty("cross.type", code);
    }

    public static CrossPopulation getMappingCross(IBioGenome map) {
        int gen;
        int type;
        String value = map.getProperties().getProperty("mapping.cross");
        if (value == null) {
            type = 0;
            gen = 0;
        } else {
            BioCrossTypes.parseCross(value);
            type = BioCrossTypes.type;
            gen = BioCrossTypes.gen;
        }
        CrossPopulation cross = new CrossPopulation();
        cross.setCrossType(type);
        cross.setGeneration(gen);
        return cross;
    }
}

