/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.classes.UnmarshalBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class ValueChild
implements IComponent {
    static final int DIRECT_IDENT = 0;
    static final int AUTO_IDENT = 1;
    static final int DEF_IDENT = 2;
    static final int REF_IDENT = 3;
    static final int ATTRIBUTE_STYLE = 0;
    static final int ELEMENT_STYLE = 1;
    static final int TEXT_STYLE = 2;
    static final int CDATA_STYLE = 3;
    private static final String BACKFILL_SUFFIX = "_backfill_";
    private static final String[] BACKFILL_INTERFACES = new String[]{"org.jibx.runtime.impl.BackFillReference"};
    private static final String BACKFILL_METHODNAME = "backfill";
    private static final Type[] BACKFILL_METHODARGS = new Type[]{Type.OBJECT};
    private static final String BOUNDREF_NAME = "m_obj";
    private static final String CHECK_ELEMENT_NAME = "org.jibx.runtime.impl.UnmarshallingContext.isAt";
    private static final String CHECK_ATTRIBUTE_NAME = "org.jibx.runtime.impl.UnmarshallingContext.hasAttribute";
    private static final String CHECK_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Z";
    private static final String UNMARSHAL_DEFREF_ATTR_NAME = "org.jibx.runtime.impl.UnmarshallingContext.attributeExistingIDREF";
    private static final String UNMARSHAL_DEFREF_ELEM_NAME = "org.jibx.runtime.impl.UnmarshallingContext.parseElementExistingIDREF";
    private static final String UNMARSHAL_FWDREF_ATTR_NAME = "org.jibx.runtime.impl.UnmarshallingContext.attributeForwardIDREF";
    private static final String UNMARSHAL_FWDREF_ELEM_NAME = "org.jibx.runtime.impl.UnmarshallingContext.parseElementForwardIDREF";
    private static final String UNMARSHAL_DEFREF_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/Object;";
    private static final String REGISTER_BACKFILL_NAME = "org.jibx.runtime.impl.UnmarshallingContext.registerBackFill";
    private static final String REGISTER_BACKFILL_SIGNATURE = "(ILorg/jibx/runtime/impl/BackFillReference;)V";
    private static final String DEFINE_ID_NAME = "org.jibx.runtime.impl.UnmarshallingContext.defineID";
    private static final String DEFINE_ID_SIGNATURE = "(Ljava/lang/String;ILjava/lang/Object;)V";
    private static final String UNMARSHAL_TEXT_NAME = "org.jibx.runtime.impl.UnmarshallingContext.parseContentText";
    private static final String UNMARSHAL_TEXT_SIGNATURE = "()Ljava/lang/String;";
    private static final String MARSHAL_TEXT_NAME = "org.jibx.runtime.impl.MarshallingContext.writeContent";
    private static final String MARSHAL_CDATA_NAME = "org.jibx.runtime.impl.MarshallingContext.writeCData";
    private static final String MARSHAL_TEXT_SIGNATURE = "(Ljava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;";
    private static final String UNMARSHALLING_THROWEXCEPTION_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.throwException";
    private static final String UNMARSHALLING_THROWEXCEPTION_SIGNATURE = "(Ljava/lang/String;)V";
    protected static final String MARSHAL_ATTRIBUTE = "org.jibx.runtime.impl.MarshallingContext.attribute";
    protected static final String MARSHAL_ELEMENT = "org.jibx.runtime.impl.MarshallingContext.element";
    protected static final String MARSHAL_SIGNATURE = "(ILjava/lang/String;Ljava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;";
    private final IContainer m_container;
    private final IContextObj m_objContext;
    private final int m_valueStyle;
    private final String m_constantValue;
    private final int m_identType;
    private final NameDefinition m_name;
    private final String m_type;
    private final PropertyDefinition m_property;
    private final StringConversion m_conversion;
    private IMapping m_idRefMap;

    public ValueChild(IContainer contain, IContextObj objc, NameDefinition name, PropertyDefinition prop, StringConversion conv, int style, int ident, String constant) {
        this.m_container = contain;
        this.m_objContext = objc;
        this.m_name = name;
        this.m_property = prop;
        this.m_type = prop.getTypeName();
        this.m_conversion = conv;
        this.m_valueStyle = style;
        this.m_identType = ident;
        this.m_constantValue = constant;
    }

    private ClassFile createBackfillClass() throws JiBXException {
        BoundClass bc = this.m_objContext.getBoundClass();
        BindingDefinition def = this.m_container.getBindingRoot();
        String name = bc.getClassFile().deriveClassName(def.getPrefix(), BACKFILL_SUFFIX + this.m_property.getName());
        ClassFile base = ClassCache.getClassFile("java.lang.Object");
        ClassFile cf = new ClassFile(name, bc.getClassFile().getRoot(), base, 1, BACKFILL_INTERFACES);
        String type = bc.getClassFile().getName();
        ClassItem ref = cf.addPrivateField(type, BOUNDREF_NAME);
        Type[] args = new Type[]{ClassItem.typeFromName(type)};
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder("<init>", Type.VOID, args, cf, 0);
        mb.appendLoadLocal(0);
        mb.appendCallInit("java.lang.Object", "()V");
        mb.appendLoadLocal(0);
        mb.appendLoadLocal(1);
        mb.appendPutField(ref);
        mb.appendReturn();
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(BACKFILL_METHODNAME, Type.VOID, BACKFILL_METHODARGS, cf, 1);
        mb.appendLoadLocal(0);
        mb.appendGetField(ref);
        mb.appendLoadLocal(1);
        mb.appendCreateCast(this.m_property.getSetValueType());
        this.m_property.genStore(mb);
        mb.appendReturn();
        mb.codeComplete(false);
        mb.addMethod();
        return MungedClass.getUniqueSupportClass(cf);
    }

    private void genParseIdRef(ContextMethodBuilder mb) throws JiBXException {
        String name;
        BranchWrapper ifmiss = null;
        if (this.m_property.isOptional()) {
            String name2 = this.m_valueStyle == 0 ? CHECK_ATTRIBUTE_NAME : CHECK_ELEMENT_NAME;
            mb.appendCallVirtual(name2, CHECK_SIGNATURE);
            BranchWrapper ifpres = mb.appendIFNE(this);
            mb.appendACONST_NULL();
            ifmiss = mb.appendUnconditionalBranch(this);
            mb.targetNext(ifpres);
            mb.loadContext();
            this.m_name.genPushUriPair(mb);
        }
        int index = this.m_container.getBindingRoot().getIdClassIndex(this.m_property.getTypeName());
        if (this.m_container.getBindingRoot().isForwards()) {
            mb.appendLoadConstant(index);
            name = this.m_valueStyle == 0 ? UNMARSHAL_FWDREF_ATTR_NAME : UNMARSHAL_FWDREF_ELEM_NAME;
            mb.appendCallVirtual(name, UNMARSHAL_DEFREF_SIGNATURE);
            mb.appendDUP();
            BranchWrapper ifdef = mb.appendIFNONNULL(this);
            ClassFile backclas = this.createBackfillClass();
            mb.loadContext();
            mb.appendLoadConstant(index);
            mb.appendCreateNew(backclas.getName());
            mb.appendDUP();
            mb.loadObject();
            mb.appendCallInit(backclas.getName(), "(" + this.m_objContext.getBoundClass().getClassFile().getSignature() + ")V");
            mb.appendCallVirtual(REGISTER_BACKFILL_NAME, REGISTER_BACKFILL_SIGNATURE);
            mb.targetNext(ifdef);
        } else {
            mb.appendLoadConstant(index);
            name = this.m_valueStyle == 0 ? UNMARSHAL_DEFREF_ATTR_NAME : UNMARSHAL_DEFREF_ELEM_NAME;
            mb.appendCallVirtual(name, UNMARSHAL_DEFREF_SIGNATURE);
        }
        mb.appendCreateCast(this.m_property.getSetValueType());
        if (ifmiss != null) {
            mb.targetNext(ifmiss);
        }
        this.m_property.genStore(mb);
    }

    public void genIfPresentTest(UnmarshalBuilder mb) throws JiBXException {
        if (this.m_name == null) {
            throw new JiBXException("Method call on invalid value");
        }
        mb.loadContext();
        this.m_name.genPushUriPair(mb);
        String name = this.m_valueStyle == 0 ? CHECK_ATTRIBUTE_NAME : CHECK_ELEMENT_NAME;
        mb.appendCallVirtual(name, CHECK_SIGNATURE);
    }

    private void genUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        boolean isatt;
        if (this.m_constantValue == null && !this.m_property.isImplicit()) {
            mb.loadObject();
        }
        mb.loadContext();
        if (this.m_name != null) {
            this.m_name.genPushUriPair(mb);
        }
        boolean bl = isatt = this.m_valueStyle == 0;
        if (this.m_identType == 2 || this.m_identType == 1) {
            BindingDefinition.s_stringConversion.genParseRequired(isatt, mb);
            if (this.m_identType != 1) {
                mb.appendDUP();
            }
            mb.loadContext();
            mb.appendSWAP();
            int index = this.m_container.getBindingRoot().getIdClassIndex(this.m_property.getTypeName());
            mb.appendLoadConstant(index);
            mb.loadObject();
            mb.appendCallVirtual(DEFINE_ID_NAME, DEFINE_ID_SIGNATURE);
            if (this.m_identType != 1) {
                this.m_conversion.genFromText(mb);
                this.m_property.genStore(mb);
            }
        } else if (this.m_identType == 3) {
            this.genParseIdRef(mb);
        } else if (this.m_constantValue == null) {
            if (this.m_valueStyle == 2 || this.m_valueStyle == 3) {
                mb.appendCallVirtual(UNMARSHAL_TEXT_NAME, UNMARSHAL_TEXT_SIGNATURE);
                this.m_conversion.genFromText(mb);
            } else if (this.m_property.isOptional() && (isatt || this.m_container.isContentOrdered())) {
                this.m_conversion.genParseOptional(isatt, mb);
            } else {
                this.m_conversion.genParseRequired(isatt, mb);
            }
            if (!this.m_conversion.isPrimitive() && this.m_property != null) {
                String stype = this.m_conversion.getTypeName();
                String dtype = this.m_property.getSetValueType();
                mb.appendCreateCast(stype, dtype);
            }
            this.m_property.genStore(mb);
        } else {
            BranchWrapper ifmiss = null;
            if (this.m_valueStyle == 2 || this.m_valueStyle == 3) {
                mb.appendCallVirtual(UNMARSHAL_TEXT_NAME, UNMARSHAL_TEXT_SIGNATURE);
            } else {
                this.m_conversion.genParseOptional(isatt, mb);
                mb.appendDUP();
                ifmiss = mb.appendIFNULL(this);
            }
            mb.appendDUP();
            mb.appendLoadConstant(this.m_constantValue);
            mb.appendCallVirtual("java.lang.String.equals", "(Ljava/lang/Object;)Z");
            BranchWrapper ifmatch = mb.appendIFNE(this);
            mb.appendCreateNew("java.lang.StringBuffer");
            mb.appendDUP();
            mb.appendLoadConstant("Expected constant value \"" + this.m_constantValue + "\", found \"");
            mb.appendCallInit("java.lang.StringBuffer", UNMARSHALLING_THROWEXCEPTION_SIGNATURE);
            mb.appendSWAP();
            mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            mb.appendLoadConstant("\"");
            mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            mb.appendCallVirtual("java.lang.StringBuffer.toString", UNMARSHAL_TEXT_SIGNATURE);
            mb.loadContext();
            mb.appendSWAP();
            mb.appendCallVirtual(UNMARSHALLING_THROWEXCEPTION_METHOD, UNMARSHALLING_THROWEXCEPTION_SIGNATURE);
            mb.targetNext(ifmatch);
            mb.targetNext(ifmiss);
            mb.appendPOP();
        }
    }

    private void genMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_constantValue == null) {
            boolean isatt;
            BranchWrapper ifmiss = null;
            if (this.m_property.hasTest()) {
                mb.loadObject();
                ifmiss = this.m_property.genTest(mb);
            }
            String type = this.m_property.getTypeName();
            if (this.m_name != null) {
                Type tobj = ClassItem.typeFromName(type);
                if (this.m_property.isImplicit()) {
                    mb.defineSlot(this, tobj);
                }
                this.m_name.genPushIndexPair(mb);
                if (this.m_property.isImplicit()) {
                    mb.appendLoadLocal(mb.getSlot(this));
                    mb.freeSlot(this);
                }
            }
            if (!this.m_property.isImplicit()) {
                mb.loadObject();
                this.m_property.genLoad(mb);
            }
            StringConversion convert = this.m_conversion;
            if (this.m_identType == 3) {
                this.m_idRefMap.getImplComponent().genLoadId(mb);
                convert = BindingDefinition.s_stringConversion;
                type = "java.lang.String";
            }
            boolean bl = isatt = this.m_valueStyle == 0;
            if (this.m_valueStyle == 2 || this.m_valueStyle == 3) {
                convert.genToText(type, mb);
                String name = this.m_valueStyle == 2 ? MARSHAL_TEXT_NAME : MARSHAL_CDATA_NAME;
                mb.appendCallVirtual(name, MARSHAL_TEXT_SIGNATURE);
            } else if (this.m_property.isOptional()) {
                convert.genWriteOptional(isatt, type, mb);
            } else {
                convert.genWriteRequired(isatt, type, mb);
            }
            if (ifmiss != null) {
                mb.targetNext(ifmiss);
            }
        } else {
            if (this.m_name != null) {
                this.m_name.genPushIndexPair(mb);
            }
            mb.appendLoadConstant(this.m_constantValue);
            switch (this.m_valueStyle) {
                case 0: {
                    mb.appendCallVirtual(MARSHAL_ATTRIBUTE, MARSHAL_SIGNATURE);
                    break;
                }
                case 1: {
                    mb.appendCallVirtual(MARSHAL_ELEMENT, MARSHAL_SIGNATURE);
                    break;
                }
                case 2: {
                    mb.appendCallVirtual(MARSHAL_TEXT_NAME, MARSHAL_TEXT_SIGNATURE);
                    break;
                }
                case 3: {
                    mb.appendCallVirtual(MARSHAL_CDATA_NAME, MARSHAL_TEXT_SIGNATURE);
                }
            }
        }
    }

    public String getPropertyName() {
        if (this.m_property == null) {
            return null;
        }
        return this.m_property.getName();
    }

    public boolean isOptional() {
        return this.m_property.isOptional();
    }

    public boolean hasAttribute() {
        return this.m_valueStyle == 0;
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_valueStyle != 0 || this.m_name == null) {
            throw new JiBXException("Method call on invalid structure");
        }
        mb.loadContext();
        this.m_name.genPushUriPair(mb);
        mb.appendCallVirtual(CHECK_ATTRIBUTE_NAME, CHECK_SIGNATURE);
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_valueStyle == 0) {
            this.genUnmarshal(mb);
        }
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_valueStyle == 0) {
            this.genMarshal(mb);
        }
    }

    public boolean hasContent() {
        return this.m_valueStyle != 0;
    }

    public void genContentPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_valueStyle != 1) {
            throw new JiBXException("Method call on invalid structure");
        }
        mb.loadContext();
        this.m_name.genPushUriPair(mb);
        mb.appendCallVirtual(CHECK_ELEMENT_NAME, CHECK_SIGNATURE);
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_valueStyle != 0) {
            this.genUnmarshal(mb);
        }
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_valueStyle != 0) {
            this.genMarshal(mb);
        }
    }

    public void genNewInstance(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no instance creation");
    }

    public String getType() {
        return this.m_type;
    }

    public boolean hasId() {
        return this.m_identType == 2;
    }

    public void genLoadId(ContextMethodBuilder mub) throws JiBXException {
        this.m_property.genLoad(mub);
    }

    public boolean checkContentSequence(boolean text) throws JiBXException {
        if (this.m_valueStyle == 1) {
            return true;
        }
        if (this.m_valueStyle == 0) {
            return text;
        }
        if (text) {
            return false;
        }
        throw new JiBXException("Text value must follow required element");
    }

    public void setLinkages() throws JiBXException {
        if (this.m_identType == 3) {
            String type = this.m_property == null ? this.m_objContext.getBoundClass().getClassFile().getName() : this.m_property.getTypeName();
            this.m_idRefMap = this.m_container.getDefinitionContext().getClassMapping(type);
            if (this.m_idRefMap == null) {
                throw new JiBXException("No mapping defined for " + type + " used as IDREF target");
            }
            if (!this.m_idRefMap.getImplComponent().hasId()) {
                throw new JiBXException("No ID value defined for " + type + " used as IDREF target");
            }
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        if (this.m_valueStyle == 1) {
            System.out.print("element");
        } else if (this.m_valueStyle == 0) {
            System.out.print("attribute");
        } else if (this.m_valueStyle == 2) {
            System.out.print("text");
        } else if (this.m_valueStyle == 3) {
            System.out.print("cdata");
        }
        if (this.m_name != null) {
            System.out.print(" " + this.m_name.toString());
        }
        if (this.m_property != null) {
            System.out.print(" from " + this.m_property.toString());
        }
        System.out.println();
    }
}

