/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.adapter;

import java.util.ArrayList;
import org.metaqtl.Chromosome;
import org.metaqtl.adapter.QtlAdapter;
import org.metaqtl.bio.IBioCross;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.CrossPopulation;
import org.metaqtl.bio.entity.GeneticMap;
import org.metaqtl.bio.entity.LGroup;
import org.metaqtl.bio.entity.Locus;
import org.metaqtl.numrec.NumericalUtilities;
import org.metaqtl.util.GeneticMapProperties;
import org.metaqtl.util.MappingFunction;

public final class ChromosomeAdapter {
    public static Chromosome[] toChromosomes(IBioGenome map) {
        Chromosome[] chroms = null;
        int mappingFunct = GeneticMapProperties.getMappingFunction(map);
        int mappingUnit = GeneticMapProperties.getMappingUnit(map);
        boolean rescale = GeneticMapProperties.needToBeRescaled(map);
        CrossPopulation crossDesign = GeneticMapProperties.getCrossDesign(map);
        IBioLGroup[] groups = map.groups();
        chroms = new Chromosome[groups.length];
        int i = 0;
        while (i < groups.length) {
            chroms[i] = ChromosomeAdapter.toChromosome(groups[i], crossDesign, mappingFunct, mappingUnit);
            if (rescale) {
                CrossPopulation mappingCross = GeneticMapProperties.getMappingCross(map);
                if (mappingCross != null) {
                    chroms[i].r2R(mappingCross.getCrossType(), mappingCross.getGeneration());
                }
                chroms[i].R2r();
            }
            ++i;
        }
        return chroms;
    }

    public static Chromosome toChromosome(IBioLGroup group, IBioCross crossDesign, int mappingFunction, int mappingUnit) {
        double d;
        ArrayList<IBioLocus> qtls = null;
        IBioLocus[] loci = group.loci();
        int[] oidx = new int[loci.length];
        int[] idx = new int[loci.length + 1];
        double[] positions = new double[loci.length + 1];
        double[] mr = new double[loci.length - 1];
        String[] names = new String[loci.length];
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int i = 0;
        int nm = 0;
        while (i < loci.length) {
            if (loci[i].getLocusType() == 0) {
                if (loci[i].getPosition().absolute() < start) {
                    start = loci[i].getPosition().absolute();
                } else if (loci[i].getPosition().absolute() > end) {
                    end = loci[i].getPosition().absolute();
                }
            }
            ++i;
        }
        i = 0;
        nm = 0;
        while (i < loci.length) {
            if (loci[i].getLocusType() == 0) {
                positions[nm + 1] = loci[i].getPosition().absolute();
                oidx[nm] = i;
                ++nm;
            } else if (loci[i].getLocusType() == 1 && !(loci[i].getPosition().absolute() < start) && !(loci[i].getPosition().absolute() > end)) {
                if (qtls == null) {
                    qtls = new ArrayList<IBioLocus>();
                }
                qtls.add(loci[i]);
            }
            ++i;
        }
        if (nm > 0) {
            NumericalUtilities.indexx(nm, positions, idx);
            names[0] = loci[oidx[idx[1] - 1]].getName();
            d = 0.0;
            i = 1;
            while (i < nm) {
                double d1 = positions[idx[i]];
                double d2 = positions[idx[i + 1]];
                mr[i - 1] = MappingFunction.recombination(d2 - d1, mappingFunction, mappingUnit);
                d += MappingFunction.distance(mr[i - 1], mappingFunction, mappingUnit);
                names[i] = loci[oidx[idx[i + 1] - 1]].getName();
                ++i;
            }
        } else {
            d = 0.0;
        }
        Chromosome chrom = new Chromosome();
        if (group.getParent() != null) {
            chrom.mapName = group.getParent().getName();
        }
        chrom.name = group.getName();
        chrom.nm = nm;
        chrom.mr = mr;
        chrom.totd = d;
        chrom.mrkNames = names;
        chrom.ct = crossDesign.getCrossType();
        chrom.cs = crossDesign.getSize();
        chrom.cg = crossDesign.getGeneration();
        chrom.mfc = mappingFunction;
        chrom.mut = mappingUnit;
        if (qtls != null) {
            loci = new IBioLocus[qtls.size()];
            qtls.toArray(loci);
            chrom.attachQTL(loci);
        }
        return chrom;
    }

    public static IBioGenome toIBioGenome(Chromosome[] chromosomes, int gout) {
        GeneticMap geneticMap = null;
        if (chromosomes == null) {
            return null;
        }
        if (chromosomes.length < 1) {
            return null;
        }
        geneticMap = new GeneticMap();
        int i = 0;
        while (i < chromosomes.length) {
            IBioLocus locus;
            int j;
            Chromosome chrom = chromosomes[i];
            LGroup group = new LGroup(chrom.name, geneticMap);
            if (gout == 0 || gout == 1) {
                j = 0;
                while (j < chrom.nm) {
                    locus = Locus.newLocus(0);
                    locus.setName(chrom.mrkNames[j]);
                    locus.setPosition(chrom.getDistance(j, chrom.mfc, chrom.mut));
                    group.addLocus(locus);
                    ++j;
                }
            }
            if ((gout == 0 || gout == 2) && chrom.qtls != null) {
                j = 0;
                while (j < chrom.qtls.length) {
                    locus = QtlAdapter.fromQTL(chrom.qtls[j]);
                    group.addLocus(locus);
                    ++j;
                }
            }
            geneticMap.addGroup(group);
            ++i;
        }
        return geneticMap;
    }
}

