/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import java.util.Random;
import org.metaqtl.EMResult;
import org.metaqtl.algo.SVDAlgorithm;
import org.metaqtl.numrec.NumericalUtilities;

public final class EMAlgorithm {
    public static int EM_START = 50;
    public static int EM_ITER_MAX = 1000;
    public static double EM_ERR = 1.0E-8;
    public static double EM_MIN_DISTANCE = 1.0E-5;
    public static boolean DO_SEM = true;
    public static final double TINY_Z_PROBA = Double.MIN_VALUE;
    public static final int EM_OK = 0;
    public static final int EM_CONTINUE = 1;
    public static final int EM_FAILURE = 2;

    public static EMResult doEM(double[] x, double[] sd, int k, EMResult spoint) {
        int i;
        int status;
        int iter;
        double[] mu;
        EMResult stheta = null;
        EMResult theta = null;
        if (k < 1) {
            return null;
        }
        if (x == null || sd == null) {
            return null;
        }
        int nstart = EM_START > 0 && spoint == null ? (k > 1 && k < x.length ? EM_START : 1) : 1;
        EMResult[] buff1 = new EMResult[nstart];
        EMResult[] buff2 = new EMResult[nstart];
        Random rng = new Random();
        int start = 0;
        while (start < nstart) {
            theta = new EMResult(x.length, k);
            buff2[start] = new EMResult(x.length, k);
            mu = new double[k];
            if (spoint == null) {
                EMAlgorithm.initEM(x, sd, theta, rng);
                EMResult.copy(buff2[start], theta);
            } else {
                EMResult.copy(theta, spoint);
            }
            iter = 0;
            do {
                ++iter;
                i = 0;
                while (i < theta.k) {
                    mu[i] = theta.mu[i];
                    ++i;
                }
                status = EMAlgorithm.iterate(x, sd, theta);
                if (iter <= EM_ITER_MAX) continue;
                status = 2;
                break;
            } while (status == 1);
            buff1[start] = theta;
            ++start;
        }
        double max = Double.NEGATIVE_INFINITY;
        stheta = null;
        theta = null;
        i = 0;
        while (i < start) {
            if (buff1[i].olog > max) {
                boolean ok = true;
                if (spoint == null && k > 1 && k < x.length) {
                    double[] d = buff1[i].getEuclidean();
                    int j = 0;
                    while (j < d.length) {
                        if (d[j] < EM_MIN_DISTANCE) break;
                        ++j;
                    }
                    boolean bl = ok = j == d.length;
                }
                if (ok) {
                    max = buff1[i].olog;
                    theta = buff1[i];
                    stheta = buff2[i];
                }
            }
            ++i;
        }
        if (theta != null && DO_SEM) {
            iter = 0;
            mu = new double[k];
            do {
                ++iter;
                i = 0;
                while (i < stheta.k) {
                    mu[i] = stheta.mu[i];
                    ++i;
                }
                status = EMAlgorithm.iterate(x, sd, stheta);
                if (iter > EM_ITER_MAX) {
                    status = 2;
                    break;
                }
                if (!DO_SEM) continue;
                EMAlgorithm.computeDM(x, sd, mu, stheta);
            } while (status == 1);
            theta.dm = stheta.dm;
        }
        if (theta != null) {
            EMAlgorithm.computeCOV(sd, theta);
        }
        return theta;
    }

    public static void initEM(double[] x, double[] sd, EMResult theta, Random rng) {
        if (theta.k == 1) {
            int i = 0;
            while (i < theta.n) {
                theta.z[0][i] = 1.0;
                ++i;
            }
            theta.pi[0] = 1.0;
            EMAlgorithm.mStep(x, sd, theta, EM_ERR);
        } else if (theta.k == theta.n) {
            int i = 0;
            while (i < theta.k) {
                theta.mu[i] = x[i];
                theta.pi[i] = 1.0 / (double)theta.k;
                int j = 0;
                while (j < theta.k) {
                    theta.z[i][j] = j != i ? 0.0 : 1.0;
                    ++j;
                }
                ++i;
            }
            theta.sortCluster();
        } else {
            int l;
            int j;
            int n = theta.k;
            int[] cidx = new int[n];
            int i = 0;
            while (i < theta.k) {
                cidx[i] = i;
                ++i;
            }
            i = 0;
            while (i < theta.k) {
                j = rng.nextInt(n);
                l = 0;
                while (l < theta.k) {
                    theta.z[l][i] = l == cidx[j] ? 1.0 : 0.0;
                    ++l;
                }
                l = j;
                while (l < n - 1) {
                    cidx[l] = cidx[l + 1];
                    ++l;
                }
                --n;
                ++i;
            }
            i = theta.k;
            while (i < theta.n) {
                j = rng.nextInt(theta.k);
                l = 0;
                while (l < theta.k) {
                    theta.z[l][i] = l == j ? 1.0 : 0.0;
                    ++l;
                }
                ++i;
            }
            EMAlgorithm.mStep(x, sd, theta, EM_ERR);
        }
        EMAlgorithm.updateLoglikelihood(x, sd, theta);
    }

    public static int iterate(double[] x, double[] sd, EMResult theta) {
        if (theta.k > 1 && theta.k < theta.n) {
            EMAlgorithm.eStep(x, sd, theta);
            return EMAlgorithm.mStep(x, sd, theta, EM_ERR);
        }
        if (theta.k == 1) {
            return 0;
        }
        return 0;
    }

    public static void eStep(double[] x, double[] sd, EMResult theta) {
        EMAlgorithm.updateZMatrix(x, sd, theta);
    }

    public static int mStep(double[] x, double[] sd, EMResult theta, double err) {
        double[] mu = EMAlgorithm.updateMuVector(x, sd, theta);
        double[] pi = EMAlgorithm.updatePiVector(theta);
        double[] tmp1 = theta.mu;
        theta.mu = mu;
        mu = tmp1;
        double[] tmp2 = theta.pi;
        theta.pi = pi;
        pi = tmp2;
        double olog = -theta.olog;
        theta.sortCluster();
        EMAlgorithm.updateLoglikelihood(x, sd, theta);
        olog += theta.olog;
        if (olog < 0.0) {
            tmp1 = theta.mu;
            theta.mu = mu;
            mu = tmp1;
            tmp2 = theta.pi;
            theta.pi = pi;
            pi = tmp2;
            theta.sortCluster();
            EMAlgorithm.updateLoglikelihood(x, sd, theta);
            return 2;
        }
        if (olog < err) {
            EMAlgorithm.emRate(theta, mu, pi);
            return 0;
        }
        EMAlgorithm.emRate(theta, mu, pi);
        return 1;
    }

    public static void emRate(EMResult theta, double[] mu, double[] pi) {
        double r = 0.0;
        if (theta.k > 1) {
            int i = 0;
            while (i < theta.k) {
                r += (mu[i] - theta.mu[i]) * (mu[i] - theta.mu[i]);
                r += (pi[i] - theta.pi[i]) * (pi[i] - theta.pi[i]);
                ++i;
            }
            theta.rate = theta.edist > Double.MIN_VALUE ? Math.sqrt(r) / theta.edist : 0.0;
            theta.edist = Math.sqrt(r);
        } else {
            theta.edist = 0.0;
            theta.rate = 0.0;
        }
    }

    public static double[] updateMuVector(double[] x, double[] sd, EMResult theta) {
        double[] mu = new double[theta.k];
        int i = 0;
        while (i < theta.k) {
            double w = 0.0;
            mu[i] = 0.0;
            int j = 0;
            while (j < x.length) {
                int n = i;
                mu[n] = mu[n] + x[j] * theta.z[i][j] / (sd[j] * sd[j]);
                w += theta.z[i][j] / (sd[j] * sd[j]);
                ++j;
            }
            int n = i++;
            mu[n] = mu[n] / w;
        }
        return mu;
    }

    public static double[] updatePiVector(EMResult theta) {
        double[] pi = new double[theta.k];
        int i = 0;
        while (i < theta.k) {
            pi[i] = 0.0;
            int j = 0;
            while (j < theta.n) {
                int n = i;
                pi[n] = pi[n] + theta.z[i][j];
                ++j;
            }
            int n = i++;
            pi[n] = pi[n] / (double)theta.n;
        }
        return pi;
    }

    public static void updateZMatrix(double[] x, double[] sd, EMResult theta) {
        double[] s = new double[theta.n];
        int j = 0;
        while (j < theta.n) {
            s[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < theta.k) {
            j = 0;
            while (j < theta.n) {
                theta.z[i][j] = theta.pi[i] / sd[j] * NumericalUtilities.gauss((x[j] - theta.mu[i]) / sd[j]);
                int n = j;
                s[n] = s[n] + theta.z[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < theta.k) {
            j = 0;
            while (j < theta.n) {
                if (s[j] > Double.MIN_VALUE) {
                    double[] dArray = theta.z[i];
                    int n = j;
                    dArray[n] = dArray[n] / s[j];
                    theta.z[i][j] = theta.z[i][j] < Double.MIN_VALUE ? 0.0 : theta.z[i][j];
                } else {
                    theta.z[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void updateLoglikelihood(double[] x, double[] sd, EMResult theta) {
        double clog = 0.0;
        double olog = 0.0;
        int i = 0;
        while (i < theta.n) {
            double o = 0.0;
            int j = 0;
            while (j < theta.k) {
                double u = NumericalUtilities.gauss((x[i] - theta.mu[j]) / sd[i]);
                if (u > Double.MIN_VALUE) {
                    o += theta.pi[j] / sd[i] * u;
                    clog += theta.z[j][i] * Math.log(u / sd[i]);
                }
                ++j;
            }
            if (o > 0.0) {
                olog += Math.log(o);
            }
            ++i;
        }
        theta.olog = olog;
        theta.clog = clog;
    }

    public static void computeDM(double[] x, double[] sd, double[] mu, EMResult theta) {
        int i = 0;
        while (i < theta.k) {
            int j;
            EMResult theta_i = new EMResult(theta.n, theta.k);
            double d = theta.mu[i] - mu[i];
            if (Math.abs(d) > Double.MIN_VALUE) {
                j = 0;
                while (j < theta.k) {
                    if (j == i) {
                        theta_i.mu[i] = theta.mu[i];
                    } else {
                        theta_i.mu[j] = mu[j];
                    }
                    theta_i.pi[j] = theta.pi[j];
                    ++j;
                }
                EMAlgorithm.eStep(x, sd, theta_i);
                EMAlgorithm.mStep(x, sd, theta_i, EM_ERR);
                j = 0;
                while (j < theta.k) {
                    double z = theta_i.mu[j] - theta.mu[j];
                    theta.dm[i][j] = Math.abs(z) > Double.MIN_VALUE ? z / d : 0.0;
                    ++j;
                }
            } else {
                j = 0;
                while (j < theta.k) {
                    theta.dm[i][j] = 0.0;
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void computeCOV(double[] sd, EMResult theta) {
        block26: {
            int j;
            int i;
            if (theta.k < theta.n) {
                i = 0;
                while (i < theta.k) {
                    theta.ccov[i] = 0.0;
                    j = 0;
                    while (j < theta.n) {
                        int n = i;
                        theta.ccov[n] = theta.ccov[n] + theta.z[i][j] / (sd[j] * sd[j]);
                        ++j;
                    }
                    theta.ccov[i] = theta.ccov[i] != 0.0 ? 1.0 / theta.ccov[i] : 0.0;
                    ++i;
                }
            } else {
                i = 0;
                while (i < theta.k) {
                    theta.ccov[i] = sd[i] * sd[i];
                    ++i;
                }
            }
            i = 0;
            while (i < theta.k) {
                theta.ocov[i][i] = theta.ccov[i];
                j = i + 1;
                while (j < theta.k) {
                    theta.ocov[i][j] = 0.0;
                    theta.ocov[j][i] = 0.0;
                    ++j;
                }
                ++i;
            }
            if (theta.k <= 1 || theta.k >= theta.n || !DO_SEM) break block26;
            double[][] u = new double[theta.k][theta.k];
            double[][] v = new double[theta.k][theta.k];
            double[][] t = new double[theta.k][theta.k];
            double[] w = new double[theta.k];
            i = 0;
            while (i < theta.k) {
                u[i][i] = 1.0 - theta.dm[i][i];
                j = i + 1;
                while (j < theta.k) {
                    u[i][j] = -theta.dm[i][j];
                    u[j][i] = -theta.dm[j][i];
                    ++j;
                }
                ++i;
            }
            SVDAlgorithm.SVDecomposition(u, v, w, theta.k, theta.k);
            boolean singular = false;
            double wmax = 0.0;
            i = 0;
            while (i < theta.k) {
                if (w[i] > wmax) {
                    wmax = w[i];
                }
                ++i;
            }
            i = 0;
            while (i < theta.k) {
                if (w[i] < wmax * 1.0E-8) {
                    w[i] = 0.0;
                    singular = true;
                }
                ++i;
            }
            if (!singular) {
                int l;
                i = 0;
                while (i < theta.k) {
                    j = 0;
                    while (j < theta.k) {
                        t[i][j] = 0.0;
                        l = 0;
                        while (l < theta.k) {
                            if (w[l] != 0.0) {
                                double[] dArray = t[i];
                                int n = j;
                                dArray[n] = dArray[n] + v[i][l] * u[j][l] / w[l];
                            }
                            ++l;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < theta.k) {
                    j = 0;
                    while (j < theta.k) {
                        u[i][j] = 0.0;
                        l = 0;
                        while (l < theta.k) {
                            double[] dArray = u[i];
                            int n = j;
                            dArray[n] = dArray[n] + theta.dm[i][l] * t[l][j];
                            ++l;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < theta.k) {
                    theta.ocov[i][i] = Math.max(theta.ccov[i], theta.ccov[i] + u[i][i]);
                    j = i + 1;
                    while (j < theta.k) {
                        double d = 0.5 * (u[i][j] + u[j][i]);
                        theta.ocov[i][j] = d;
                        theta.ocov[j][i] = d;
                        ++j;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < theta.k) {
                    theta.ocov[i][i] = theta.ccov[i];
                    j = i + 1;
                    while (j < theta.k) {
                        theta.ocov[i][j] = 0.0;
                        theta.ocov[j][i] = 0.0;
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }
}

