/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public final class NumberFormat {
    public static String formatDouble(double d) {
        if (d != Double.NaN) {
            java.text.NumberFormat form = java.text.NumberFormat.getInstance();
            if (form instanceof DecimalFormat) {
                DecimalFormatSymbols df = ((DecimalFormat)form).getDecimalFormatSymbols();
                df.setDecimalSeparator('.');
                df.setGroupingSeparator(' ');
                ((DecimalFormat)form).setDecimalFormatSymbols(df);
                form.setMaximumFractionDigits(2);
                String s = form.format(d);
                s = s.replaceAll(" ", "");
                return s;
            }
            DecimalFormat df = new DecimalFormat("%.2f");
            StringBuffer tmp = new StringBuffer();
            tmp = df.format(d, tmp, (FieldPosition)null);
            return tmp.toString();
        }
        return "NaN";
    }

    public static double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(value.replace(',', '.'));
            }
            catch (NumberFormatException e2) {
                return Double.NaN;
            }
        }
    }
}

