/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.metaqtl.EMCriteria;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlModel;
import org.metaqtl.factory.MetaQtlModelFactory;

public class MetaQtlAnalysisModelFactory {
    public static void write(MetaQtlAnalysis analysis, OutputStream stream) throws IOException {
        PrintWriter writer = new PrintWriter(stream);
        MetaQtlAnalysisModelFactory.write(analysis, writer);
    }

    public static void write(MetaQtlAnalysis analysis, Writer writer) throws IOException {
        MetaQtlModel model;
        if (analysis == null) {
            return;
        }
        if (writer == null) {
            return;
        }
        Iterator iter = EMCriteria.getCriteria();
        ArrayList<MetaQtlModel> modelList = new ArrayList<MetaQtlModel>();
        while (iter.hasNext()) {
            String critName = (String)iter.next();
            int crit = EMCriteria.getCriterionIdx(critName);
            model = analysis.getBestModel(crit);
            model.setCriterion(critName);
            modelList.add(model);
        }
        iter = modelList.iterator();
        while (iter.hasNext()) {
            model = (MetaQtlModel)iter.next();
            MetaQtlModelFactory.write(model, writer);
        }
    }
}

