/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import org.metaqtl.Tree;
import org.metaqtl.TreeNode;
import org.metaqtl.bio.util.NumberFormat;

public final class TreeFactory {
    public static void write(Tree tree, OutputStream stream) throws IOException {
        if (tree == null) {
            return;
        }
        if (stream == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream));
        TreeFactory.write(tree, writer);
    }

    public static void write(Tree tree, PrintWriter writer) {
        if (tree == null) {
            return;
        }
        if (writer == null) {
            return;
        }
        TreeFactory.write_newick(tree.root, tree.root, writer);
        writer.flush();
    }

    private static void write_newick(TreeNode cur, TreeNode root, PrintWriter writer) {
        if (cur.leaf) {
            writer.print(cur.idx);
        } else {
            TreeNode[] children = cur.children;
            writer.print("(");
            int i = 0;
            while (i < children.length) {
                TreeFactory.write_newick(children[i], root, writer);
                writer.print(":" + NumberFormat.formatDouble(children[i].dist));
                if (i < children.length - 1) {
                    writer.print(",");
                }
                ++i;
            }
            writer.print(")");
        }
        if (cur.equals(root)) {
            writer.print(";");
        }
        writer.flush();
    }

    public static Tree read_newick(Reader reader) throws IOException {
        String line;
        BufferedReader buffer = new BufferedReader(reader);
        StringBuffer sbuffer = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            line.replace("\n", "");
            sbuffer.append(line);
            if (line.charAt(0) == ';') break;
        }
        String treeStr = sbuffer.toString();
        System.out.println("tree = " + treeStr);
        return TreeFactory.read_newick(treeStr);
    }

    public static Tree read_newick(String treeStr) throws IOException {
        Tree tree = null;
        int p0 = treeStr.indexOf("(");
        int p1 = treeStr.lastIndexOf(");");
        if (p0 < 0 || p0 >= p1) {
            throw new IOException("Invalid tree format");
        }
        TreeNode root = new TreeNode();
        TreeFactory.parse_newick(root, treeStr.substring(p0 + 1, p1));
        tree = new Tree(root);
        return tree;
    }

    private static void parse_newick(TreeNode parent, String children) throws IOException {
        if (children.indexOf("(") != 0) {
            String leafDist;
            String leafLabel;
            int ends = children.indexOf(",");
            String leafData = null;
            leafData = ends < 0 ? children.trim() : children.substring(0, ends).trim();
            int ends1 = leafData.indexOf(":");
            if (ends1 < 0) {
                leafLabel = leafData.trim();
                leafDist = new String("1.0");
            } else {
                leafLabel = leafData.substring(0, ends1).trim();
                leafDist = leafData.substring(ends1 + 1, leafData.length()).trim();
            }
            int label = Integer.parseInt(leafLabel);
            double dist = Double.parseDouble(leafDist);
            TreeNode leaf = new TreeNode(label);
            leaf.dist = dist;
            parent.addChild(leaf);
            if (ends > 0) {
                TreeFactory.parse_newick(parent, children.substring(ends + 1).trim());
            }
            return;
        }
        int p0 = 0;
        int p1 = 0;
        int leftRight = 0;
        do {
            int pr;
            int pl;
            if ((pl = children.indexOf("(", p1)) < 0) {
                pl = Integer.MAX_VALUE;
            }
            if ((pr = children.indexOf(")", p1)) < 0) {
                pr = Integer.MAX_VALUE;
            }
            if (pl < pr) {
                ++leftRight;
                p1 = pl + 1;
            } else {
                --leftRight;
                p1 = pr + 1;
            }
            if (leftRight >= 0) continue;
            throw new IOException("Could not parse tree.");
        } while (leftRight != 0);
        int ends = children.indexOf(",", p1);
        String nodeData = null;
        nodeData = ends < 0 ? children.substring(p1).trim() : children.substring(p1, ends).trim();
        int ends1 = nodeData.indexOf(":");
        nodeData = nodeData.substring(ends1 + 1, nodeData.length()).trim();
        TreeNode node = new TreeNode();
        node.dist = Double.parseDouble(nodeData);
        parent.addChild(node);
        if (ends >= 0) {
            TreeFactory.parse_newick(parent, children.substring(ends + 1).trim());
        }
        String newChildren = children.substring(p0 + 1, p1 - 1).trim();
        TreeFactory.parse_newick(node, newChildren);
    }

    public static Tree read(Reader reader) throws IOException {
        return TreeFactory.read_newick(reader);
    }

    public static Tree read(String str) throws IOException {
        String t = new String(str);
        t.replaceAll("\n", "");
        return TreeFactory.read_newick(t);
    }
}

