/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.metaqtl.Chromosome;
import org.metaqtl.Qtl;
import org.metaqtl.bio.util.NumberFormat;
import org.metaqtl.graph.ChromAxe;
import org.metaqtl.graph.GraphShape;
import org.metaqtl.graph.MetaGraphPar;

public class ChromShape
extends GraphShape {
    public static final int RIGHT_LABEL = 0;
    public static final int LEFT_LABEL = 1;
    private boolean withMrkLabel;
    private boolean withMrkPos;
    private boolean withChromName;
    private boolean withMapName;
    private double chrom_height;
    private double chrom_width;
    private double y_chrom;
    private double y_map_label;
    private double y_chrom_label;
    private double max_label_width = 0.0;
    private double max_pos_width = 0.0;
    private double tick_width_1 = MetaGraphPar.CHROM_TICK_WIDTH_1;
    private double tick_width_2 = MetaGraphPar.CHROM_TICK_WIDTH_2;
    private double tick_width_3 = MetaGraphPar.CHROM_TICK_WIDTH_3;
    private double[] ymin_mqtls;
    private double[] ymax_mqtls;
    private double[] y_markers;
    private double[] y_labels;
    private double[] label_widths;
    private double[] pos_widths;
    private double[][] proba;
    private double[] pos_markers;
    private boolean[] labelStatus;
    private String[] labels;
    private int whichLabelSide = 1;
    private int whichPosSide = 0;
    private ChromAxe chromAxe = null;
    private String chromName;
    private String mapName;

    public void buildShape(Graphics2D graph, Object object) {
        Qtl[] mqtls;
        this.withMapName = MetaGraphPar.WITH_MAP_NAME;
        this.withChromName = MetaGraphPar.WITH_CHROM_NAME;
        this.withMrkLabel = MetaGraphPar.WITH_MARKER_NAME;
        this.withMrkPos = MetaGraphPar.WITH_MARKER_POSITION;
        Chromosome chrom = (Chromosome)object;
        if (this.withMapName) {
            this.mapName = chrom.getMapName();
            boolean bl = this.withMapName = this.mapName != null && !this.mapName.equals("");
        }
        if (this.withChromName) {
            this.chromName = chrom.getName();
            boolean bl = this.withChromName = this.chromName != null && !this.chromName.equals("");
            if (this.withChromName) {
                TextLayout t = new TextLayout(this.chromName, MetaGraphPar.CHROM_NAME_FONT, graph.getFontRenderContext());
                this.y_chrom_label = t.getBounds().getHeight();
                this.y_chrom = t.getBounds().getHeight() + MetaGraphPar.CHROM_NAME_HSPACE;
            }
        }
        this.chromAxe = new ChromAxe(this.y_chrom, MetaGraphPar.CHROM_DISTANCE_SCALE * chrom.totd, chrom.totd);
        this.chrom_height = this.chromAxe.getHeight() + MetaGraphPar.CHROM_FLANKING_CEX * this.chromAxe.getHeight();
        this.chromAxe.setYMin(this.chromAxe.getYMin() + MetaGraphPar.CHROM_FLANKING_CEX * this.chromAxe.getHeight() / 2.0);
        this.chromAxe.setYMax(this.chromAxe.getYMax() + MetaGraphPar.CHROM_FLANKING_CEX * this.chromAxe.getHeight() / 2.0);
        this.chrom_width = MetaGraphPar.CHROM_WIDTH;
        this.pos_markers = new double[chrom.nm];
        this.y_markers = new double[chrom.nm];
        this.y_labels = new double[chrom.nm];
        this.labels = new String[chrom.nm];
        int i = 0;
        while (i < chrom.nm) {
            this.pos_markers[i] = chrom.getDistance(i);
            this.y_markers[i] = this.chromAxe.transformY(this.pos_markers[i]);
            this.y_labels[i] = this.y_markers[i];
            this.labels[i] = chrom.mrkNames[i];
            ++i;
        }
        if (this.withMrkLabel || this.withMrkPos) {
            this.checkLabelLocation(graph);
            this.resolveLabelLocation(graph);
        }
        this.proba = chrom.getProba();
        if (this.proba != null) {
            i = 0;
            while (i < this.proba.length) {
                this.proba[i][0] = this.chromAxe.transformY(this.proba[i][0]);
                this.proba[i][1] = this.chromAxe.transformY(this.proba[i][1]);
                ++i;
            }
        }
        if ((mqtls = chrom.mqtls) != null) {
            this.ymin_mqtls = new double[mqtls.length];
            this.ymax_mqtls = new double[mqtls.length];
            int i2 = 0;
            while (i2 < mqtls.length) {
                this.ymin_mqtls[i2] = this.chromAxe.transformY(mqtls[i2].position - mqtls[i2].sd_position * 1.96);
                this.ymax_mqtls[i2] = this.chromAxe.transformY(mqtls[i2].position + mqtls[i2].sd_position * 1.96);
                ++i2;
            }
        }
        this.initShapeDimension(graph);
    }

    private TextLayout getLabelTextLayout(FontRenderContext fctx, int idx) {
        if (this.labels != null) {
            return new TextLayout(this.labels[idx], MetaGraphPar.MARKER_NAME_FONT, fctx);
        }
        return null;
    }

    public void draw(Graphics2D graph) {
        Rectangle2D.Double prect;
        int i;
        double xx = this.getXChrom();
        double yy = this.y_chrom;
        if (this.proba != null) {
            i = 0;
            while (i < this.proba.length) {
                prect = new Rectangle2D.Double(xx, this.proba[i][0], this.chrom_width, this.proba[i][1] - this.proba[i][0]);
                graph.setColor(MetaGraphPar.getProbaColor(this.proba[i][2]));
                graph.fill(prect);
                ++i;
            }
        }
        if (this.ymin_mqtls != null && this.ymax_mqtls != null) {
            i = 0;
            while (i < this.ymin_mqtls.length) {
                prect = new Rectangle2D.Double(xx, this.ymin_mqtls[i], this.chrom_width, this.ymax_mqtls[i] - this.ymin_mqtls[i]);
                graph.setColor(MetaGraphPar.QTL_PALETTE[i]);
                graph.fill(prect);
                ++i;
            }
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(xx, yy, this.chrom_width, this.chrom_height, 10.0, 10.0);
        graph.setColor(MetaGraphPar.CHROM_STROKE_COLOR);
        graph.setStroke(MetaGraphPar.CHROM_STROKE);
        graph.draw(rect);
        if (this.y_markers != null) {
            graph.setColor(MetaGraphPar.CHROM_TICK_COLOR);
            graph.setStroke(MetaGraphPar.CHROM_TICK_STROKE);
            int i2 = 0;
            while (i2 < this.y_markers.length) {
                GeneralPath path;
                Line2D.Double line = new Line2D.Double(this.getXChrom(), this.y_markers[i2], this.getXChrom() + this.chrom_width, this.y_markers[i2]);
                graph.draw(line);
                if (this.withMrkLabel) {
                    TextLayout labelTxt = this.getLabelTextLayout(graph.getFontRenderContext(), i2);
                    path = this.getPath2MrkLabel(i2);
                    graph.draw(path);
                    double xl = this.getLabelX(labelTxt, this.whichLabelSide == 1);
                    labelTxt.draw(graph, (float)xl, (float)(this.y_labels[i2] + labelTxt.getBounds().getHeight() / 2.0));
                }
                if (this.withMrkPos) {
                    TextLayout posTxt = this.getPositionTextLayout(graph.getFontRenderContext(), i2);
                    path = this.getPath2MrkPos(i2);
                    graph.draw(path);
                    double xp = this.getLabelX(posTxt, this.whichPosSide == 1);
                    posTxt.draw(graph, (float)xp, (float)(this.y_labels[i2] + posTxt.getBounds().getHeight() / 2.0));
                }
                ++i2;
            }
        }
        if (this.withMapName) {
            TextLayout txt = new TextLayout(this.mapName, MetaGraphPar.CHROM_NAME_FONT, graph.getFontRenderContext());
            AffineTransform t = graph.getTransform();
            AffineTransform rot = new AffineTransform();
            rot.rotate(1.5707963267948966, xx, this.y_map_label);
            graph.transform(rot);
            txt.draw(graph, (float)xx, (float)this.y_map_label);
            graph.setTransform(t);
        }
        if (this.withChromName) {
            TextLayout t = new TextLayout(this.chromName, MetaGraphPar.CHROM_NAME_FONT, graph.getFontRenderContext());
            xx = this.getXChrom() + this.chrom_width / 2.0;
            t.draw(graph, (float)(xx -= t.getBounds().getWidth() / 2.0), (float)this.y_chrom_label);
        }
    }

    private double getLabelX(TextLayout label, boolean side) {
        double xx = 0.0;
        if (side) {
            xx = this.getXChrom();
            xx -= this.getTickWidth();
            xx -= label.getBounds().getWidth();
        } else {
            xx = this.getXChrom() + this.chrom_width;
            xx += this.getTickWidth();
        }
        return xx;
    }

    private GeneralPath getPath2MrkPos(int i) {
        return this.getPath2Label(i, this.whichPosSide == 1);
    }

    private GeneralPath getPath2MrkLabel(int i) {
        return this.getPath2Label(i, this.whichLabelSide == 1);
    }

    private GeneralPath getPath2Label(int i, boolean side) {
        double xx = 0.0;
        GeneralPath path = new GeneralPath(0, 4);
        if (side) {
            xx = this.getXChrom();
            path.moveTo((float)xx, (float)this.y_markers[i]);
            xx -= this.tick_width_1;
        } else {
            xx = this.getXChrom() + this.chrom_width;
            path.moveTo((float)xx, (float)this.y_markers[i]);
            xx += this.tick_width_1;
        }
        path.lineTo((float)xx, (float)this.y_markers[i]);
        xx = side ? (xx -= this.tick_width_2) : (xx += this.tick_width_2);
        path.lineTo((float)xx, (float)this.y_labels[i]);
        xx = side ? (xx -= this.tick_width_3) : (xx += this.tick_width_3);
        path.lineTo((float)xx, (float)this.y_labels[i]);
        return path;
    }

    public double getXChrom() {
        double shift = this.getTickWidth();
        if (this.withMrkLabel) {
            if (this.withMrkPos) {
                if (this.whichPosSide == 1) {
                    return this.max_pos_width + shift;
                }
                return this.max_label_width + shift;
            }
            if (this.whichLabelSide == 1) {
                return this.max_label_width + shift;
            }
        } else if (this.withMrkPos && this.whichPosSide == 1) {
            return this.max_pos_width + shift;
        }
        return 0.0;
    }

    private void initShapeDimension(Graphics2D graph) {
        int i;
        this.width = 0.0;
        this.height = 0.0;
        if (this.withMrkLabel) {
            this.label_widths = new double[this.labels.length];
            i = 0;
            while (i < this.labels.length) {
                this.label_widths[i] = this.getLabelWidth(graph, i);
                if (this.label_widths[i] > this.width) {
                    this.width = this.label_widths[i];
                }
                ++i;
            }
            this.max_label_width = this.width;
            this.width += this.getTickWidth();
        }
        if (this.withMrkPos) {
            this.pos_widths = new double[this.pos_markers.length];
            i = 0;
            while (i < this.pos_markers.length) {
                this.pos_widths[i] = this.getPositionWidth(graph, i);
                ++i;
            }
            this.max_pos_width = this.getPositionWidth(graph, this.pos_markers.length - 1);
            this.width += this.max_pos_width;
            this.width += this.getTickWidth();
        }
        this.width += this.chrom_width;
        this.height = this.y_chrom + this.chrom_height;
        if (this.y_labels != null) {
            if (this.y_labels[0] < 0.0) {
                double y_shift = this.getLabelHeight(graph, 0) - this.y_labels[0];
                this.height += y_shift;
            }
            if (this.y_labels[this.y_labels.length - 1] > this.chrom_height) {
                this.height += this.y_labels[this.y_labels.length - 1] - this.chrom_height;
                this.height += this.getLabelHeight(graph, this.y_labels.length - 1);
            }
        }
        if (this.withMapName) {
            TextLayout t = new TextLayout(this.mapName, MetaGraphPar.CHROM_NAME_FONT, graph.getFontRenderContext());
            this.y_map_label = this.height + MetaGraphPar.CHROM_NAME_HSPACE;
            this.height += t.getBounds().getWidth() + MetaGraphPar.CHROM_NAME_HSPACE;
            this.width = Math.max(this.width, t.getBounds().getHeight());
        }
    }

    private double getTickWidth() {
        double w = 1.1 * this.tick_width_1;
        w += this.tick_width_2;
        return w += this.tick_width_3;
    }

    private TextLayout getPositionTextLayout(FontRenderContext fctx, int idx) {
        if (this.pos_markers != null) {
            String s = NumberFormat.formatDouble(this.pos_markers[idx]);
            return new TextLayout(s, MetaGraphPar.MARKER_POSITION_FONT, fctx);
        }
        return null;
    }

    private double getPositionWidth(Graphics2D graph, int idx) {
        TextLayout t = this.getPositionTextLayout(graph.getFontRenderContext(), idx);
        if (t != null) {
            return t.getBounds().getWidth();
        }
        return 0.0;
    }

    private void checkLabelLocation(Graphics2D graph) {
        this.labelStatus = new boolean[this.labels.length];
        int i = 0;
        while (i < this.labels.length) {
            this.labelStatus[i] = true;
            ++i;
        }
        i = 0;
        while (i < this.labels.length - 1) {
            double y1 = this.y_labels[i];
            double y2 = this.y_labels[i + 1];
            int n = i;
            this.labelStatus[n] = this.labelStatus[n] & (y1 += this.getLabelHeight(graph, i)) <= y2;
            int n2 = i + 1;
            this.labelStatus[n2] = this.labelStatus[n2] & y1 <= y2;
            ++i;
        }
    }

    private void resolveLabelLocation(Graphics2D graph) {
        int i = 0;
        while (i < this.labels.length) {
            int nl = 1;
            if (!this.labelStatus[i]) {
                double y_top = i > 0 ? this.y_labels[i - 1] + this.getLabelHeight(graph, i - 1) : this.y_labels[i];
                int j = i + 1;
                while (j < this.labels.length) {
                    if (this.labelStatus[j]) break;
                    ++j;
                    ++nl;
                }
                double y_bottom = i + nl < this.labels.length ? this.y_labels[i + nl] : this.y_labels[i + nl - 1] + this.getLabelHeight(graph, i + nl - 1);
                double space = y_bottom - y_top;
                double require = 0.0;
                j = i;
                while (j < i + nl) {
                    require += this.getLabelHeight(graph, j);
                    ++j;
                }
                if (space < require) {
                    if (i + nl < this.labels.length - 1) {
                        j = i - 1;
                        while (j >= 0) {
                            int n = j;
                            this.y_labels[n] = this.y_labels[n] - (require - space) / 2.0;
                            if (j <= 0 || !(this.y_labels[j - 1] + this.getLabelHeight(graph, j - 1) < this.y_labels[j])) {
                                --j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        j = i;
                        while (j < this.labels.length) {
                            int n = j++;
                            this.y_labels[n] = this.y_labels[n] + (require - space);
                        }
                    }
                    if (i > 0) {
                        j = i + nl;
                        while (j < this.labels.length) {
                            int n = j;
                            this.y_labels[n] = this.y_labels[n] + (require - space) / 2.0;
                            if (j + 1 >= this.labels.length || !(this.y_labels[j + 1] > this.y_labels[j] + this.getLabelHeight(graph, j))) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        j = 0;
                        while (j < nl) {
                            int n = j++;
                            this.y_labels[n] = this.y_labels[n] - (require - space);
                        }
                    }
                    y_top = i > 0 ? this.y_labels[i - 1] + this.getLabelHeight(graph, i - 1) : this.y_labels[i];
                    j = 0;
                    while (j < nl) {
                        this.y_labels[i + j] = y_top;
                        y_top += this.getLabelHeight(graph, i + j);
                        ++j;
                    }
                    y_bottom = y_top;
                    y_top = i > 0 ? this.y_labels[i - 1] + this.getLabelHeight(graph, i - 1) : this.y_labels[i];
                } else {
                    double y_box = space / (double)nl;
                    j = 0;
                    while (j < nl) {
                        this.y_labels[i + j] = y_top + (y_box - this.getLabelHeight(graph, i + j)) / 2.0;
                        y_top += y_box;
                        ++j;
                    }
                }
            }
            i += nl;
        }
    }

    private double getLabelHeight(Graphics2D graph, int i) {
        TextLayout t = this.getLabelTextLayout(graph.getFontRenderContext(), i);
        double h = i < this.labels.length - 1 ? t.getBounds().getHeight() + MetaGraphPar.MAKER_NAME_VSPACE : t.getBounds().getHeight();
        t = null;
        return h;
    }

    private double getLabelWidth(Graphics2D graph, int i) {
        TextLayout t = this.getLabelTextLayout(graph.getFontRenderContext(), i);
        double w = t.getBounds().getWidth();
        t = null;
        return w;
    }

    private double getMapLabelHeigth(Graphics2D graph, int i) {
        TextLayout t = this.getLabelTextLayout(graph.getFontRenderContext(), i);
        double w = t.getBounds().getWidth();
        t = null;
        return w;
    }

    public void setLabelSide(int side) {
        this.whichLabelSide = side;
    }

    public double getChromWidth() {
        return this.chrom_width;
    }

    public ChromAxe getChromAxe() {
        return this.chromAxe;
    }

    public double getYMin() {
        if (this.y_labels != null) {
            return Math.min(this.y_chrom, this.y_labels[0]);
        }
        return this.y_chrom;
    }

    public double getYMax() {
        double y_max = this.y_chrom + this.chrom_height;
        if (this.y_labels != null) {
            y_max = Math.max(y_max, this.y_labels[this.y_labels.length - 1]);
        }
        if (this.mapName != null) {
            y_max = Math.max(y_max, this.y_map_label);
        }
        return y_max;
    }

    public Point2D getMrkTickPoint2D(int mrkIdx, boolean reverse) {
        double xx = 0.0;
        double yy = 0.0;
        if (reverse) {
            if (this.withMrkLabel) {
                switch (this.whichLabelSide) {
                    case 1: {
                        xx = this.max_label_width - this.label_widths[mrkIdx] * 1.05;
                        yy = this.y_labels[mrkIdx];
                        break;
                    }
                    case 0: {
                        if (this.withMrkPos) {
                            xx = this.max_pos_width - this.pos_widths[mrkIdx] * 1.05;
                            yy = this.y_labels[mrkIdx];
                            break;
                        }
                        xx = this.getXChrom() * 0.95;
                        yy = this.y_markers[mrkIdx];
                    }
                }
            } else if (this.withMrkPos) {
                if (this.whichLabelSide == 1) {
                    xx = this.max_pos_width - this.pos_widths[mrkIdx] * 1.05;
                    yy = this.y_labels[mrkIdx];
                } else {
                    xx = this.getXChrom() * 0.95;
                    yy = this.y_markers[mrkIdx];
                }
            } else {
                xx = this.getXChrom() * 0.95;
                yy = this.y_markers[mrkIdx];
            }
        } else if (this.withMrkLabel) {
            switch (this.whichLabelSide) {
                case 1: {
                    if (this.withMrkPos) {
                        xx = this.getXChrom() + this.chrom_width + this.getTickWidth() + this.pos_widths[mrkIdx] * 1.05;
                        yy = this.y_labels[mrkIdx];
                        break;
                    }
                    xx = this.getXChrom() + this.chrom_width * 1.05;
                    yy = this.y_markers[mrkIdx];
                    break;
                }
                case 0: {
                    xx = this.getXChrom() + this.chrom_width + this.getTickWidth() + this.label_widths[mrkIdx] * 1.05;
                    yy = this.y_labels[mrkIdx];
                }
            }
        } else if (this.withMrkPos) {
            switch (this.whichLabelSide) {
                case 1: {
                    xx = this.getXChrom() + this.chrom_width * 1.05;
                    yy = this.y_markers[mrkIdx];
                    break;
                }
                case 0: {
                    xx = this.getXChrom() + this.chrom_width + this.getTickWidth() + this.label_widths[mrkIdx] * 1.05;
                    yy = this.y_labels[mrkIdx];
                }
            }
        } else {
            xx = this.getXChrom() + this.chrom_width * 1.05;
            yy = this.y_markers[mrkIdx];
        }
        return new Point2D.Double(xx, yy);
    }

    public int getLabelSide() {
        return this.whichLabelSide;
    }
}

