/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.metaqtl.graph.ChromGraph;
import org.metaqtl.graph.MetaGraph;
import org.metaqtl.graph.MetaGraphPar;

public class GraphFactory {
    public static int WIDTH = 5000;
    public static int HEIGHT = 500;
    public static int BOX_WIDTH = 4000;
    public static int BOX_HEIGHT = 300;

    public static BufferedImage getImage(ChromGraph[] chroms) {
        double sy;
        int H;
        double sx;
        int W;
        if (chroms == null) {
            return null;
        }
        MetaGraph mg = new MetaGraph();
        BufferedImage bi = new BufferedImage(WIDTH, HEIGHT, 1);
        Graphics2D graph = bi.createGraphics();
        mg.init(graph, chroms);
        HEIGHT = (int)mg.getHeight();
        HEIGHT = (int)((double)HEIGHT + (double)HEIGHT * 0.1);
        WIDTH = (int)mg.getWidth();
        WIDTH = (int)((double)WIDTH + (double)WIDTH * 0.1);
        if (WIDTH > 3500) {
            W = 3500;
            sx = (double)W / (double)WIDTH;
            H = W * HEIGHT / WIDTH;
            sy = (double)H / (double)HEIGHT;
        } else {
            W = WIDTH;
            H = HEIGHT;
            sy = 0.0;
            sx = 0.0;
        }
        bi = new BufferedImage(W, H, 1);
        graph = bi.createGraphics();
        graph.setBackground(MetaGraphPar.BACKGROUND_COLOR);
        graph.clearRect(0, 0, W, H);
        if (sx > 0.0 && sy > 0.0) {
            AffineTransform s = new AffineTransform();
            s.scale(sx, sy);
            graph.transform(s);
        }
        mg.draw(graph, (double)WIDTH * 0.05, (double)HEIGHT * 0.05);
        graph.dispose();
        bi.flush();
        return bi;
    }
}

