/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.metaqtl.graph.GraphShape;
import org.metaqtl.graph.MetaGraphPar;
import org.metaqtl.graph.QtlUnit;

public class QtlShape
extends GraphShape {
    public double y_pos;
    public double y_from;
    public double ci_height;
    public double ci_width;
    private double x_ci;
    private double y_label;
    private TextLayout label;
    private Rectangle2D.Double[] rectangles;
    private int rectMaxIdx;
    private GeneralPath position;

    public void buildShape(Graphics2D graph, Object object) {
        double h;
        boolean np = false;
        QtlUnit unit = (QtlUnit)object;
        this.y = unit.from;
        this.y_pos = unit.pos;
        this.y_from = unit.from;
        this.height = this.ci_height = unit.to - unit.from;
        this.ci_width = unit.width;
        if (MetaGraphPar.WITH_QTL_NAME) {
            FontRenderContext fr = graph.getFontRenderContext();
            this.label = new TextLayout(unit.name, MetaGraphPar.QTL_NAME_FONT, fr);
            h = this.label.getBounds().getHeight();
            this.x_ci += h;
            this.x_ci += h * MetaGraphPar.QTL_NAME_VSPACE_CEX;
            h = this.label.getBounds().getWidth();
            this.y_label = this.y_from + 0.5 * (this.ci_height - h);
            if (h > this.ci_height) {
                this.y = this.y_label;
            }
            this.height = Math.max(this.height, this.label.getBounds().getWidth());
        }
        double[] partitions = unit.partition != null ? unit.partition : new double[]{1.0};
        this.rectangles = new Rectangle2D.Double[partitions.length];
        double yy = this.y_from;
        np = false;
        double max = 0.0;
        int i = 0;
        while (i < partitions.length) {
            if (partitions[i] > 0.01) {
                h = this.ci_height * partitions[i];
                this.rectangles[i] = new Rectangle2D.Double(this.x_ci, yy, this.ci_width, h);
                yy += h;
                if (partitions[i] > max) {
                    max = partitions[i];
                    this.rectMaxIdx = i;
                }
            } else {
                this.rectangles[i] = null;
            }
            ++i;
        }
        double x1 = this.x_ci;
        double y1 = this.y_pos;
        double x2 = this.x_ci + this.ci_width * (1.0 + MetaGraphPar.QTL_TICK_WIDTH_CEX);
        double y2 = this.y_pos;
        this.position = new GeneralPath(0, 3);
        this.position.moveTo((float)(this.x_ci + this.ci_width), (float)(this.y_pos - this.ci_height * MetaGraphPar.QTL_POS_HEIGHT_CEX));
        this.position.lineTo((float)(this.x_ci + this.ci_width * (1.0 + MetaGraphPar.QTL_POS_WIDTH_CEX)), (float)this.y_pos);
        this.position.lineTo((float)(this.x_ci + this.ci_width), (float)(this.y_pos + this.ci_height * MetaGraphPar.QTL_POS_HEIGHT_CEX));
        this.position.closePath();
        this.width = this.x_ci + this.ci_width * (1.0 + MetaGraphPar.QTL_POS_WIDTH_CEX);
    }

    public void draw(Graphics2D graph) {
        Color lcolor = Color.black;
        if (this.label != null) {
            AffineTransform t = graph.getTransform();
            AffineTransform rot = new AffineTransform();
            double h = this.label.getBounds().getHeight();
            double w = this.label.getBounds().getWidth();
            rot.rotate(1.5707963267948966, 0.0, this.y_label);
            graph.transform(rot);
            graph.setColor(MetaGraphPar.QTL_NAME_COLOR);
            this.label.draw(graph, 0.0f, (float)this.y_label);
            graph.setTransform(t);
        }
        int np = this.rectangles.length;
        int i = 0;
        while (i < np) {
            if (this.rectangles[i] != null) {
                if (MetaGraphPar.QTL_PALETTE != null) {
                    graph.setPaint(MetaGraphPar.QTL_PALETTE[i]);
                } else {
                    graph.setPaint(Color.darkGray);
                }
                graph.fill(this.rectangles[i]);
            }
            ++i;
        }
        if (MetaGraphPar.QTL_PALETTE != null) {
            graph.setPaint(MetaGraphPar.QTL_PALETTE[this.rectMaxIdx]);
        } else {
            graph.setPaint(Color.darkGray);
        }
        graph.fill(this.position);
    }

    public double getHeigth() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getYMin() {
        return this.y;
    }

    public double getYMax() {
        return this.y + this.height;
    }

    public static double getYDistance(QtlShape s1, QtlShape s2) {
        double d = 0.0;
        if (s1.label != null && s2.label != null) {
            double yt1 = s1.y_label;
            double h1 = s1.label.getBounds().getWidth();
            double yt2 = s2.y_label;
            double h2 = s2.label.getBounds().getWidth();
            d = yt1 > yt2 ? yt1 - (yt2 + h2) : yt2 - (yt1 + h1);
        }
        d = s1.y_from > s2.y_from ? Math.min(d, s1.y_from - (s2.y_from + s2.ci_height)) : Math.min(d, s2.y_from - (s1.y_from + s1.ci_height));
        return d;
    }
}

