/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.File;
import java.io.IOException;
import org.metaqtl.Chromosome;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.adapter.ChromosomeAdapter;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.graph.ChromGraph;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public class MapView
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: MapView [{-m, --map}]] [{-c, --chrom}]] [{-q, --qtl}]] [{--qmode}]] [{-o, --outstem}]] [{-t, --tonto}]] [{-p, --par}][{--tree}][{--img}]" + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        MetaMain.printLicense("MapView", VERSION);
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-m, --map     : the file location of the map");
        System.out.println("-c, --chrom   : the chromosome(s) to draw");
        System.out.println("-q, --qtl     : draw also the QTL");
        System.out.println("--qmode       : QTL representation mode");
        System.out.println("-p, --par     : the file location of the drawing parameters");
        System.out.println("-t, --tonto   : the XML file for the trait ontology");
        System.out.println("-o, --outstem : the output stem");
        System.out.println("--tree : the tree which linked the QTL");
        System.out.println("--img         : the format of the image among this list");
        MetaMain.printImgFormat(15);
    }

    public static void main(String[] args) {
        ChromGraph[] chromGraphs;
        Chromosome[] chromosomes;
        Chromosome[] chrom2draws;
        MapView program = new MapView();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option amapFile = parser.addStringOption('m', "map");
        CmdLineParser.Option achromList = parser.addStringOption('c', "chrom");
        CmdLineParser.Option awithQtl = parser.addBooleanOption('q', "qtl");
        CmdLineParser.Option amodeQtl = parser.addIntegerOption("qmode");
        CmdLineParser.Option aparFile = parser.addStringOption('p', "par");
        CmdLineParser.Option aontoFile = parser.addStringOption('t', "tonto");
        CmdLineParser.Option atreeFile = parser.addStringOption("tree");
        CmdLineParser.Option aimgFormat = parser.addStringOption("img");
        CmdLineParser.Option aoutFile = parser.addStringOption('o', "outdir");
        program.parseCmdLine(args);
        String mapFile = (String)parser.getOptionValue(amapFile);
        String chromList = (String)parser.getOptionValue(achromList);
        Boolean withQtl = (Boolean)parser.getOptionValue(awithQtl, new Boolean(false));
        Integer modeQtl = (Integer)parser.getOptionValue(amodeQtl, new Integer(1));
        String ontoFile = (String)parser.getOptionValue(aontoFile);
        String treeFile = (String)parser.getOptionValue(atreeFile);
        String parFile = (String)parser.getOptionValue(aparFile);
        String imgFormat = (String)parser.getOptionValue(aimgFormat, "jpeg");
        String outFile = (String)parser.getOptionValue(aoutFile);
        if (mapFile == null) {
            System.err.println("[ ERROR ] : No map file defined");
            System.exit(2);
        }
        if (chromList == null) {
            System.err.println("[ ERROR ]:  No chromosome name defined");
            System.exit(2);
        }
        if (outFile == null) {
            System.err.println("[ ERROR ] : No output file defined");
            System.exit(2);
        }
        IBioGenome map = null;
        IBioOntology ontology = null;
        MetaQtlAnalysis tree = null;
        String[] chromNames = null;
        try {
            map = MapView.getMap(mapFile);
            ontology = MapView.getOntology(ontoFile, 'x');
            tree = MapView.getResult(treeFile);
            MapView.setParameter(parFile);
            chromNames = MapView.parseChromList(chromList);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (map == null) {
            System.err.println("[ ERROR ] : Unable to load map from " + mapFile);
            System.exit(4);
        }
        if ((chrom2draws = MapView.getChromByNames(chromosomes = ChromosomeAdapter.toChromosomes(map), chromNames)) == null) {
            chrom2draws = chromosomes;
        }
        if ((chromGraphs = MapView.getChromGraph(chrom2draws, withQtl, modeQtl, ontology, tree)) != null) {
            try {
                File file = new File(String.valueOf(outFile) + "." + imgFormat);
                MapView.writeImg(chromGraphs, file, imgFormat);
                file = new File(String.valueOf(outFile) + ".par");
                MapView.writePar(file);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(5);
            }
            System.exit(0);
        }
        System.err.println("[ ERROR ] : No chromosome to draw !");
        System.exit(6);
    }
}

