/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.util.Stack;
import org.jibx.runtime.IXMLWriter;

public abstract class XMLWriterBase
implements IXMLWriter {
    protected String[] m_uris;
    protected boolean m_textSeen;
    protected boolean m_contentSeen;
    protected int m_nestingDepth;
    protected String[] m_prefixes;
    private Stack m_namespaceStack;
    private int m_namespaceDepth;
    private String[][] m_extensionUris;
    private String[][] m_extensionPrefixes;

    public XMLWriterBase(String[] uris) {
        this.m_uris = uris;
        this.m_prefixes = new String[uris.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml";
        this.m_namespaceStack = new Stack();
        this.m_namespaceDepth = -1;
    }

    protected abstract void writeMarkup(String var1) throws IOException;

    protected abstract void writeMarkup(char var1) throws IOException;

    protected abstract void defineNamespace(int var1, String var2) throws IOException;

    protected abstract void undefineNamespace(int var1);

    protected abstract void writePrefix(int var1) throws IOException;

    protected abstract void writeAttributeText(String var1) throws IOException;

    public void writeXMLDecl(String version, String encoding, String standalone) throws IOException {
        this.writeMarkup("<?xml version=\"");
        this.writeAttributeText(version);
        if (encoding != null) {
            this.writeMarkup("\" encoding=\"");
            this.writeAttributeText(encoding);
        }
        if (standalone != null) {
            this.writeMarkup("\" standalone=\"");
            this.writeAttributeText(standalone);
        }
        this.writeMarkup("\"?>");
    }

    public void startTagOpen(int index, String name) throws IOException {
        this.indent();
        this.writeMarkup('<');
        this.writePrefix(index);
        this.writeMarkup(name);
    }

    private void setNamespacePrefix(int index, String prefix) {
        if (index < this.m_prefixes.length) {
            this.m_prefixes[index] = prefix;
        } else if (this.m_extensionUris != null) {
            index -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index < length) {
                    this.m_extensionPrefixes[i][index] = prefix;
                    break;
                }
                index -= length;
            }
        }
    }

    public void startTagNamespaces(int index, String name, int[] nums, String[] prefs) throws IOException {
        int count = 0;
        for (int i = 0; i < nums.length; ++i) {
            if (prefs[i].equals(this.getNamespacePrefix(nums[i]))) continue;
            ++count;
        }
        int[] deltas = null;
        if (count > 0) {
            String[] priors = new String[count];
            if (count == nums.length) {
                deltas = nums;
                for (int i = 0; i < count; ++i) {
                    int slot = deltas[i];
                    priors[i] = this.getNamespacePrefix(slot);
                    this.setNamespacePrefix(slot, prefs[i]);
                    this.defineNamespace(slot, prefs[i]);
                }
            } else {
                int fill = 0;
                deltas = new int[count];
                for (int i = 0; i < nums.length; ++i) {
                    int slot = nums[i];
                    String curr = this.getNamespacePrefix(slot);
                    if (prefs[i].equals(curr)) continue;
                    deltas[fill] = slot;
                    priors[fill++] = curr;
                    this.setNamespacePrefix(slot, prefs[i]);
                    this.defineNamespace(slot, prefs[i]);
                }
            }
            this.m_namespaceStack.push(new DeclarationInfo(this.m_nestingDepth, deltas, priors));
            this.m_namespaceDepth = this.m_nestingDepth;
        }
        this.startTagOpen(index, name);
        for (int i = 0; i < count; ++i) {
            int slot = deltas[i];
            String prefix = this.getNamespacePrefix(slot);
            if (prefix.length() > 0) {
                this.writeMarkup(" xmlns:");
                this.writeMarkup(prefix);
                this.writeMarkup("=\"");
            } else {
                this.writeMarkup(" xmlns=\"");
            }
            this.writeAttributeText(this.getNamespaceUri(slot));
            this.writeMarkup('\"');
        }
    }

    public void addAttribute(int index, String name, String value) throws IOException {
        this.writeMarkup(" ");
        this.writePrefix(index);
        this.writeMarkup(name);
        this.writeMarkup("=\"");
        this.writeAttributeText(value);
        this.writeMarkup('\"');
    }

    public void closeNamespaces() {
        DeclarationInfo info = (DeclarationInfo)this.m_namespaceStack.pop();
        int[] deltas = info.m_deltas;
        String[] priors = info.m_priors;
        for (int i = 0; i < deltas.length; ++i) {
            int index = deltas[i];
            this.undefineNamespace(index);
            if (index < this.m_prefixes.length) {
                this.m_prefixes[index] = null;
                continue;
            }
            if (this.m_extensionUris == null) continue;
            index -= this.m_prefixes.length;
            for (int j = 0; j < this.m_extensionUris.length; ++j) {
                int length = this.m_extensionUris[j].length;
                if (index < length) {
                    this.m_extensionPrefixes[j][index] = null;
                    continue;
                }
                index -= length;
            }
        }
        this.m_namespaceDepth = this.m_namespaceStack.empty() ? -1 : ((DeclarationInfo)this.m_namespaceStack.peek()).m_depth;
    }

    public void closeStartTag() throws IOException {
        this.writeMarkup('>');
        ++this.m_nestingDepth;
        this.m_contentSeen = false;
        this.m_textSeen = false;
    }

    public void closeEmptyTag() throws IOException {
        this.writeMarkup("/>");
        if (this.m_nestingDepth == this.m_namespaceDepth) {
            this.closeNamespaces();
        }
        this.m_contentSeen = true;
    }

    public void startTagClosed(int index, String name) throws IOException {
        this.indent();
        this.writeMarkup('<');
        this.writePrefix(index);
        this.writeMarkup(name);
        this.writeMarkup('>');
        ++this.m_nestingDepth;
        this.m_contentSeen = false;
        this.m_textSeen = false;
    }

    public void endTag(int index, String name) throws IOException {
        --this.m_nestingDepth;
        if (this.m_contentSeen && !this.m_textSeen) {
            this.indent();
        }
        this.writeMarkup("</");
        this.writePrefix(index);
        this.writeMarkup(name);
        this.writeMarkup('>');
        if (this.m_nestingDepth == this.m_namespaceDepth) {
            this.closeNamespaces();
        }
        this.m_textSeen = false;
        this.m_contentSeen = true;
    }

    public void writeComment(String text) throws IOException {
        this.writeMarkup("<!--");
        this.writeMarkup(text);
        this.writeMarkup("-->");
    }

    public void writeEntityRef(String name) throws IOException {
        this.writeMarkup('&');
        this.writeMarkup(name);
        this.writeMarkup(';');
        this.m_contentSeen = true;
    }

    public void writeDocType(String name, String sys, String pub, String subset) throws IOException {
        this.indent();
        this.writeMarkup("<!DOCTYPE ");
        this.writeMarkup(name);
        this.writeMarkup(' ');
        if (sys != null) {
            if (pub == null) {
                this.writeMarkup("SYSTEM \"");
                this.writeMarkup(sys);
            } else {
                this.writeMarkup("PUBLIC \"");
                this.writeMarkup(pub);
                this.writeMarkup("\" \"");
                this.writeMarkup(sys);
            }
            this.writeMarkup('\"');
        }
        if (subset != null) {
            this.writeMarkup('[');
            this.writeMarkup(subset);
            this.writeMarkup(']');
        }
        this.writeMarkup('>');
    }

    public void writePI(String target, String data) throws IOException {
        this.indent();
        this.writeMarkup("<?");
        this.writeMarkup(target);
        this.writeMarkup(' ');
        this.writeMarkup(data);
        this.writeMarkup("?>");
        this.m_contentSeen = true;
    }

    public abstract void close() throws IOException;

    public void reset() {
        this.m_contentSeen = false;
        this.m_textSeen = false;
        this.m_nestingDepth = 0;
        this.m_namespaceDepth = -1;
        this.m_namespaceStack.clear();
        this.m_extensionUris = null;
        this.m_extensionPrefixes = null;
    }

    public String[] getNamespaces() {
        return this.m_uris;
    }

    public String getNamespaceUri(int index) {
        if (index < this.m_uris.length) {
            return this.m_uris[index];
        }
        if (this.m_extensionUris != null) {
            index -= this.m_uris.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index < length) {
                    return this.m_extensionUris[i][index];
                }
                index -= length;
            }
        }
        return null;
    }

    public String getNamespacePrefix(int index) {
        if (index < this.m_prefixes.length) {
            return this.m_prefixes[index];
        }
        if (this.m_extensionUris != null) {
            index -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index < length) {
                    return this.m_extensionPrefixes[i][index];
                }
                index -= length;
            }
        }
        return null;
    }

    public int getPrefixIndex(String prefix) {
        int i;
        if (this.m_extensionPrefixes != null) {
            for (i = this.m_extensionPrefixes.length - 1; i >= 0; --i) {
                String[] prefixes = this.m_extensionPrefixes[i];
                for (int j = prefixes.length - 1; j >= 0; --j) {
                    if (!prefix.equals(prefixes[j])) continue;
                    int index = j + this.m_prefixes.length;
                    for (int k = i - 1; k >= 0; --k) {
                        index += this.m_extensionPrefixes[k].length;
                    }
                    return index;
                }
            }
        }
        for (i = this.m_prefixes.length - 1; i >= 0; --i) {
            if (!prefix.equals(this.m_prefixes[i])) continue;
            return i;
        }
        return -1;
    }

    protected static String[][] growArray(String[][] base, String[] items) {
        if (base == null) {
            return new String[][]{items};
        }
        int length = base.length;
        String[][] grow = new String[length + 1][];
        System.arraycopy(base, 0, grow, 0, length);
        grow[length] = items;
        return grow;
    }

    protected static String[][] shrinkArray(String[][] base) {
        int length = base.length;
        if (length == 1) {
            return null;
        }
        String[][] shrink = new String[length - 1][];
        System.arraycopy(base, 0, shrink, 0, length - 1);
        return shrink;
    }

    public void pushExtensionNamespaces(String[] uris) {
        this.m_extensionUris = XMLWriterBase.growArray(this.m_extensionUris, uris);
        this.m_extensionPrefixes = XMLWriterBase.growArray(this.m_extensionPrefixes, new String[uris.length]);
    }

    public void popExtensionNamespaces() {
        this.m_extensionUris = XMLWriterBase.shrinkArray(this.m_extensionUris);
        this.m_extensionPrefixes = XMLWriterBase.shrinkArray(this.m_extensionPrefixes);
    }

    public String[][] getExtensionNamespaces() {
        return this.m_extensionUris;
    }

    private static class DeclarationInfo {
        public final int m_depth;
        public final int[] m_deltas;
        public final String[] m_priors;

        public DeclarationInfo(int depth, int[] deltas, String[] priors) {
            this.m_depth = depth;
            this.m_deltas = deltas;
            this.m_priors = priors;
        }
    }
}

