/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import org.metaqtl.EMCriteria;
import org.metaqtl.numrec.NumericalUtilities;

public class EMResult {
    public int k;
    public int n;
    public double rate;
    public double edist;
    public double[] mu;
    public double[] pi;
    public double[][] z;
    public double olog;
    public double clog;
    public double[][] dm;
    public double[][] ocov;
    public double[] ccov;
    public EMCriteria criteria;

    public EMResult() {
    }

    public EMResult(int n, int k) {
        this.n = n;
        this.k = k;
        this.mu = new double[k];
        this.pi = new double[k];
        this.z = new double[k][n];
        this.ocov = new double[k][k];
        this.dm = new double[k][k];
        this.ccov = new double[k];
        this.olog = Double.NEGATIVE_INFINITY;
        this.clog = Double.NEGATIVE_INFINITY;
        this.criteria = new EMCriteria();
        this.rate = 0.0;
        this.edist = 1.0;
    }

    public void sortCluster() {
        if (this.k > 1) {
            int i = 0;
            while (i < this.k - 1) {
                if (this.mu[i] > this.mu[i + 1]) break;
                ++i;
            }
            if (i < this.k - 1) {
                int[] idx = new int[this.k + 1];
                double[] muu = new double[this.k + 1];
                double[] pii = new double[this.k + 1];
                double[][] zz = new double[this.k + 1][];
                i = 0;
                while (i < this.k) {
                    muu[i + 1] = this.mu[i];
                    pii[i + 1] = this.pi[i];
                    zz[i + 1] = this.z[i];
                    ++i;
                }
                NumericalUtilities.indexx(this.k, muu, idx);
                i = 0;
                while (i < this.k) {
                    this.mu[i] = muu[idx[i + 1]];
                    this.pi[i] = pii[idx[i + 1]];
                    this.z[i] = zz[idx[i + 1]];
                    ++i;
                }
            }
        }
    }

    public static void copy(EMResult dest, EMResult src) {
        if (src == null) {
            return;
        }
        if (dest == null) {
            return;
        }
        if (dest.k != src.k) {
            return;
        }
        if (dest.n != src.n) {
            return;
        }
        int i = 0;
        while (i < src.k) {
            dest.mu[i] = src.mu[i];
            dest.pi[i] = src.pi[i];
            int j = 0;
            while (j < src.n) {
                dest.z[i][j] = src.z[i][j];
                ++j;
            }
            ++i;
        }
        dest.olog = src.olog;
        dest.clog = src.clog;
    }

    public void computeCriteria() {
        double nfp = 2.0 * (double)this.k - 1.0;
        if (this.k == this.n) {
            nfp = this.n;
        }
        this.criteria.aic = -2.0 * this.olog + 2.0 * nfp;
        this.criteria.aicc = (double)this.n - nfp > 1.0 ? -2.0 * this.olog + 2.0 * nfp + 2.0 * (nfp * (nfp + 1.0)) / ((double)this.n - nfp - 1.0) : -2.0 * this.olog + 2.0 * nfp;
        this.criteria.aic3 = -2.0 * this.olog + 3.0 * nfp;
        this.criteria.bic = -2.0 * this.olog + Math.log(this.n) * nfp;
        this.criteria.awe = -2.0 * this.clog + 2.0 * (1.5 + Math.log(this.n)) * nfp;
        double t = 0.0;
        double d = 1.0;
        int i = 0;
        while (i < this.k) {
            t += this.ocov[i][i];
            d *= this.ocov[i][i];
            ++i;
        }
        this.criteria.icomp = -2.0 * this.olog + 0.5 * nfp * Math.log(t / nfp) - 0.5 * Math.log(d);
        this.criteria.mir = 1.0 - this.rate;
    }

    public double getCriterion(int critIdx) {
        return this.criteria.getCriterion(critIdx);
    }

    public double[] getMahalanobis(double[] sd) {
        if (sd == null) {
            return null;
        }
        if (this.k == 1) {
            return null;
        }
        double[] d = new double[this.k - 1];
        double[] a = new double[this.k];
        double[] s = new double[this.k];
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.k) {
                int n = j;
                a[n] = a[n] + this.z[j][i] * sd[i];
                int n2 = j;
                s[n2] = s[n2] + this.z[j][i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.k) {
            int n = i;
            a[n] = a[n] / s[i];
            ++i;
        }
        i = 0;
        while (i < this.k - 1) {
            d[i] = (this.mu[i] - this.mu[i + 1]) * (this.mu[i] - this.mu[i + 1]);
            int n = i;
            d[n] = d[n] / (a[i] * a[i] + a[i + 1] * a[i + 1]);
            d[i] = Math.sqrt(d[i]);
            ++i;
        }
        return d;
    }

    public double[] getXPred() {
        double[] xp = new double[this.n];
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.k) {
                int n = i;
                xp[n] = xp[n] + this.z[j][i] * this.mu[j];
                ++j;
            }
            ++i;
        }
        return xp;
    }

    public double getSD(int i) {
        return Math.sqrt(this.ocov[i][i]);
    }

    public double getMu(int i) {
        return this.mu[i];
    }

    public int getK() {
        return this.k;
    }

    public double[] getZ(int i) {
        double[] zi = new double[this.k];
        int j = 0;
        while (j < this.k) {
            zi[j] = this.z[j][i];
            ++j;
        }
        return zi;
    }

    public double[] getEuclidean() {
        double[] d = new double[this.k - 1];
        int i = 0;
        while (i < this.k - 1) {
            d[i] = (this.mu[i] - this.mu[i + 1]) * (this.mu[i] - this.mu[i + 1]);
            d[i] = Math.sqrt(d[i]);
            ++i;
        }
        return d;
    }

    public double getPi(int i) {
        return this.pi[i];
    }

    public int getXPredIdx(int i) {
        double max = 0.0;
        int maxk = 0;
        int j = 0;
        while (j < this.k) {
            if (this.z[j][i] > max) {
                max = this.z[j][i];
                maxk = j;
            }
            ++j;
        }
        return maxk;
    }

    public double[] getXBestPred() {
        double[] xp = new double[this.n];
        int i = 0;
        while (i < this.n) {
            xp[i] = this.getMu(this.getXPredIdx(i));
            ++i;
        }
        return xp;
    }
}

