/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.adapter;

import org.metaqtl.EMResult;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlData;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.Qtl;
import org.metaqtl.QtlPartition;
import org.metaqtl.Tree;
import org.metaqtl.numrec.NumericalUtilities;

public class QtlPartitionAdapter {
    public static QtlPartition adapt(MetaQtlData qtlData) {
        if (qtlData == null) {
            return null;
        }
        QtlPartition qtlPart = new QtlPartition();
        qtlPart.nqtl = qtlData.getQtlNumber();
        qtlPart.np = qtlData.getTraitClusterNumber();
        qtlPart.pnames = qtlData.getTraitClusterNames();
        qtlPart.proba = new double[qtlPart.nqtl][qtlPart.np];
        qtlPart.qtlPos = new double[qtlPart.nqtl];
        qtlPart.qtlCI = new double[qtlPart.nqtl];
        qtlPart.qtlNames = new String[qtlPart.nqtl];
        int k = 0;
        int i = 0;
        while (i < qtlPart.np) {
            Double[][] X = qtlData.getDataPoints(i, false);
            int j = 0;
            while (j < qtlData.getTraitClusterSize(i)) {
                qtlPart.proba[k][i] = 1.0;
                qtlPart.qtlPos[k] = X[0][j];
                qtlPart.qtlCI[k] = X[1][j] * 3.92;
                Qtl qtl = qtlData.getQtl(i, j);
                qtlPart.qtlNames[k] = qtl.name != null ? qtl.name : new String("QTL_" + k);
                ++k;
                ++j;
            }
            ++i;
        }
        return qtlPart;
    }

    public static QtlPartition adapt(MetaQtlAnalysis analysis, String chrom, String trait, int k) {
        if (analysis == null) {
            return null;
        }
        int cidx = analysis.getChromIdx(chrom);
        MetaQtlResult result = analysis.getResult(cidx, trait);
        return QtlPartitionAdapter.adapt(result, analysis.qtlByChrom[cidx], k);
    }

    public static QtlPartition adapt(MetaQtlResult result, Qtl[] qtls, int k) {
        Tree tree;
        if (result == null) {
            return null;
        }
        if (k > result.nmqc) {
            k = result.nmqc;
        }
        if (k < 0) {
            k = 1;
        }
        QtlPartition qtlPart = new QtlPartition();
        qtlPart.nqtl = result.nqtl;
        qtlPart.np = k;
        qtlPart.pnames = new String[k];
        qtlPart.proba = new double[qtlPart.nqtl][k];
        qtlPart.qtlPos = new double[qtlPart.nqtl];
        qtlPart.qtlCI = new double[qtlPart.nqtl];
        qtlPart.qtlNames = new String[qtlPart.nqtl];
        int i = 0;
        while (i < result.nqtl) {
            qtlPart.qtlPos[i] = result.x[i];
            qtlPart.qtlCI[i] = NumericalUtilities.sd2ci(result.sd[i]);
            qtlPart.qtlNames[i] = qtls[result.qtlIdx[i]].name;
            ++i;
        }
        EMResult clustering = result.getClustering(k);
        if (clustering != null) {
            int i2 = 0;
            while (i2 < result.nqtl) {
                int j = 0;
                while (j < clustering.k) {
                    qtlPart.proba[i2][j] = clustering.z[j][i2];
                    ++j;
                }
                ++i2;
            }
        }
        if ((tree = result.getQtlTree()) != null) {
            qtlPart.setTree(tree);
        }
        return qtlPart;
    }
}

