(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38659,        917]
NotebookOptionsPosition[     37555,        878]
NotebookOutlinePosition[     38173,        900]
CellTagsIndexPosition[     38130,        897]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Partitioning a stoichiometric network into subnetworks", "Title",
 CellChangeTimes->{{3.399941196546875*^9, 3.399941245359375*^9}, {
  3.40036951296875*^9, 3.40036951365625*^9}, {3.400440955640625*^9, 
  3.400440967859375*^9}, {3.40045740109375*^9, 3.400457421140625*^9}, {
  3.401399787171875*^9, 3.401399824546875*^9}, {3.40510538684375*^9, 
  3.40510544021875*^9}},
 Background->RGBColor[1, 0, 1]],

Cell[CellGroupData[{

Cell["QUICK START", "Section"],

Cell[TextData[{
 "1. Run this notebook by choosing Evaluation/Evaluate Notebook from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " menu.\n2. On the Netslpitter control panel that appears, the default input \
path that appears in the box labelled  \"Stoichiometry matrix input file\" \
should point to the demonstration input file \"demo.tsv\". Alternatively, you \
can simply type the word \"demo\" in this box. Click the \"Split Network\" \
button at the bottom.\n3. In the externals selection dialogue that appears, \
you can simply accept all choices offered by pressing  \"Return\". It \
progresses to Round 2, where the matrix is clearly split into two (blue \
background) blocks. Pressing \[OpenCurlyDoubleQuote]Return\
\[CloseCurlyDoubleQuote] a few more times, the program will attempt further \
splitting until in Round 7 it can find no more candidate separation nodes and \
finishes automatically.\n4. Otherwise you could click \"Finish\" in any round \
to exit the externals selection process.\n5. Back in the Netsplitter control \
panel, you can now choose to inspect the printout or subnet diagrams, before \
and/or after merging blocks.\n6. For moire information, consult the user \
guide that is included as a Microsoft Word document file with the download."
}], "Text",
 CellChangeTimes->{{3.4856302907112217`*^9, 3.485630345990641*^9}, {
  3.4858260783720655`*^9, 3.485826117934312*^9}, {3.485826392151307*^9, 
  3.485826393088801*^9}, {3.499380228341653*^9, 3.499380519527238*^9}},
 FontFamily->"Times New Roman",
 FontSize->14]
}, Open  ]],

Cell[CellGroupData[{

Cell["Control Panel", "Section",
 CellChangeTimes->{{3.4840100447636304`*^9, 3.4840100483417783`*^9}, {
  3.4856298648482656`*^9, 3.4856298710189557`*^9}, {3.4856301023272834`*^9, 
  3.4856301252923584`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<\\\\Packages\>\""}], 
   "]"}], ";"}], "\n", 
 RowBox[{"Get", "[", "\"\<Netsplitter`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", "\"\<FileReadWrite`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<MatrixDisplay`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<BlockFinder`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<SubnetLayout`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<Printout`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<RandomWalkBlocker`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<SelectExternals`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LUlogo", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ulog\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<GZIP\>\"", ",", "\"\<GIF\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CFACSLogo", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<clog\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<GZIP\>\"", ",", "\"\<GIF\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.4856291888601055`*^9, {3.485629314284051*^9, 3.4856293466270657`*^9}, {
   3.4856293900582204`*^9, 3.485629400490443*^9}, {3.4856295754051647`*^9, 
   3.4856295836685677`*^9}, {3.48562962550107*^9, 3.485629631436974*^9}, {
   3.499452084853658*^9, 3.499452101260643*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Infile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<Demo.tsv\>\""}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Exfile", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";", 
  RowBox[{"Targetfile", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";", 
  RowBox[{"Fluxfile", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4840085232531233`*^9, 3.484008557878788*^9}, {
   3.4840086247232924`*^9, 3.484008652848472*^9}, 3.484342204199275*^9, {
   3.4843454083036003`*^9, 3.484345412975625*^9}, {3.4856294995505595`*^9, 
   3.4856295126251693`*^9}, {3.4994516978289933`*^9, 3.4994517124062786`*^9}, 
   3.499452071431182*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"keepup", "=", 
   RowBox[{"CreateDialog", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<What is happening? \>\"", "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"Dynamic", "[", "Status", "]"}], "]"}], ",", 
       RowBox[{"TextCell", "[", "\"\<  \>\"", "]"}]}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Netsplitter Status\>\""}], ",", 
     RowBox[{"WindowFloating", "\[Rule]", "True"}], ",", 
     RowBox[{"WindowMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"WindowClickSelect", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DialogInput", "[", 
   RowBox[{
    RowBox[{"Panel", "[", 
     RowBox[{
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TextCell", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<NetSplitter \>\"", ",", "\"\<Title\>\""}], "]"}], 
           "]"}], ",", "Null", ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"NSPLVersion", ",", "\"\<Subtitle\>\""}], "]"}], "]"}], 
          ",", 
          RowBox[{"TextCell", "[", "\"\< \>\"", "]"}], ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<Copyright under GNU General Public License V3:\\n\\tWynand \
S. Verwoerd\\n\\tCenter for Advanced Computational Solutions \\n\\tLincoln \
University, Christchurch\\n\\tNew Zealand \>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
             RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}], ",", 
             RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], "]"}], ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{"Style", "[", "\"\< \>\"", "]"}], "]"}], ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\< Contact: wynand.verwoerd@lincoln.ac.nz  \>\"", ",", 
             "\"\<Subsubtitle\>\""}], "]"}], "]"}], ",", 
          RowBox[{"GraphicsRow", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"LUlogo", ",", 
              RowBox[{"DefaultButton", "[", "]"}], ",", "CFACSLogo"}], "}"}], 
            ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"580", ",", "72"}], "}"}]}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"Darker", "[", "Purple", "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
      RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
    RowBox[{"WindowFloating", "\[Rule]", "True"}], ",", 
    RowBox[{"Background", "\[Rule]", "Magenta"}], ",", 
    RowBox[{"WindowSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"615", ",", "380"}], "}"}]}], ",", 
    RowBox[{"WindowFrameElements", "\[Rule]", 
     RowBox[{"{", "\"\<CloseBox\>\"", "}"}]}], ",", 
    RowBox[{"WindowElements", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], "]"}], ";", 
  RowBox[{"Onthetop", "=", 
   RowBox[{"Panel", "[", 
    RowBox[{
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Stoichiometry matrix input file: \>\"", ",", 
           RowBox[{"InputField", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "Infile", "]"}], ",", "String", ",", 
             RowBox[{"FieldSize", "\[Rule]", "40"}]}], "]"}], ",", 
           RowBox[{"Button", "[", 
            RowBox[{"\"\<Browse..\>\"", ",", 
             RowBox[{"DialogReturn", "[", 
              RowBox[{"buttonchoice", "=", "7"}], "]"}]}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Tooltip", "[", 
            RowBox[{
            "\"\<External metabolites input file: \>\"", ",", 
             "\"\<Optional; choose from Subnets directory to resume previous \
run\>\""}], "]"}], ",", 
           RowBox[{"InputField", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "Exfile", "]"}], ",", "String", ",", 
             RowBox[{"FieldSize", "\[Rule]", "40"}]}], "]"}], ",", 
           RowBox[{"Button", "[", 
            RowBox[{"\"\<Browse..\>\"", ",", 
             RowBox[{"DialogReturn", "[", 
              RowBox[{"buttonchoice", "=", "8"}], "]"}]}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Tooltip", "[", 
            RowBox[{
            "\"\<Flux values input file: \>\"", ",", "\"\<Optional\>\""}], 
            "]"}], ",", 
           RowBox[{"InputField", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "Fluxfile", "]"}], ",", "String", ",", 
             RowBox[{"FieldSize", "\[Rule]", "40"}]}], "]"}], ",", 
           RowBox[{"Button", "[", 
            RowBox[{"\"\<Browse..\>\"", ",", 
             RowBox[{"DialogReturn", "[", 
              RowBox[{"buttonchoice", "=", "10"}], "]"}]}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Tooltip", "[", 
            RowBox[{
            "\"\<Target metabolites input file: \>\"", ",", 
             "\"\<Optional\>\""}], "]"}], ",", 
           RowBox[{"InputField", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "Targetfile", "]"}], ",", "String", ",", 
             RowBox[{"FieldSize", "\[Rule]", "40"}]}], "]"}], ",", 
           RowBox[{"Button", "[", 
            RowBox[{"\"\<Browse..\>\"", ",", 
             RowBox[{"DialogReturn", "[", 
              RowBox[{"buttonchoice", "=", "9"}], "]"}]}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Tooltip", "[", 
            RowBox[{
             RowBox[{"Button", "[", 
              RowBox[{"\"\<Refresh Targets\>\"", ",", 
               RowBox[{"DialogReturn", "[", 
                RowBox[{"buttonchoice", "=", "5"}], "]"}], ",", 
               RowBox[{"Enabled", "\[Rule]", 
                RowBox[{"Dynamic", "[", "SplitDone", "]"}]}]}], "]"}], ",", 
             "\"\<Display a new set of targets in Merge/Printout\>\""}], 
            "]"}], ",", 
           RowBox[{"Tooltip", "[", 
            RowBox[{
             RowBox[{"Row", "[", 
              RowBox[{"{", 
               RowBox[{
               "\"\<             Expand reversible reactions  \>\"", ",", 
                RowBox[{"Checkbox", "[", 
                 RowBox[{"Dynamic", "[", "ReverseThem", "]"}], "]"}]}], "}"}],
               "]"}], ",", 
             "\"\<Reversible reactions will be duplicated in direction \
opposite to input specification\>\""}], "]"}], ",", 
           RowBox[{"Tooltip", "[", 
            RowBox[{
             RowBox[{"Button", "[", 
              RowBox[{"\"\<Convert input\>\"", ",", 
               RowBox[{"DialogReturn", "[", 
                RowBox[{"buttonchoice", "=", "11"}], "]"}]}], "]"}], ",", 
             "\"\<Only converts input file to alternative format (.tsv / \
.sbml )\>\""}], "]"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"Spacings", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Input Selection\>\"", ",", "\"\<Subtitle\>\""}], "]"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Inthemid", "=", 
   RowBox[{"Panel", "[", 
    RowBox[{
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Tooltip", "[", 
           RowBox[{
           "\"\<Omit reactions with ID containing:\>\"", ",", 
            "\"\<E.g., to leave out biomass reactions. Alternatives can \
optionally be given in a format like BIO|BC|Biom (no spaces) \>\""}], "]"}], 
          ",", 
          RowBox[{"InputField", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "Dropstring", "]"}], ",", "String", ",", 
            RowBox[{"FieldSize", "\[Rule]", "30"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<Vector similarity measure: \>\"", ",", 
          RowBox[{"PopupMenu", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "DistChoice", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"DiceDissimilarity", "\[Rule]", "\"\<Dice\>\""}], ",", 
              RowBox[{"JaccardDissimilarity", "\[Rule]", "\"\<Jaccard\>\""}], 
              ",", 
              RowBox[{
              "SokalSneathDissimilarity", "\[Rule]", 
               "\"\<Sokal-Sneath\>\""}]}], "}"}], ",", 
            "SokalSneathDissimilarity"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<Intergroup distance: \>\"", ",", 
          RowBox[{"PopupMenu", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "LinkChoice", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<Single\>\"", "\[Rule]", "\"\<Smallest\>\""}], ",", 
              "\"\<Average\>\"", ",", 
              RowBox[{"\"\<Complete\>\"", "\[Rule]", "\"\<Largest\>\""}], 
              ",", "\"\<Weighted\>\"", ",", "\"\<Centroid\>\"", ",", 
              "\"\<Median\>\"", ",", "\"\<Ward\>\""}], "}"}], ",", 
            "\"\<Single\>\""}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<Max connectivity for internal metabolites:\>\"", ",", 
          RowBox[{"InputField", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "ConnexMax", "]"}], ",", "Number", ",", 
            RowBox[{"FieldSize", "\[Rule]", "3"}]}], "]"}]}], "}"}]}], "}"}], 
      "]"}], ",", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Algorithmic Options\>\"", ",", "\"\<Subtitle\>\""}], 
      "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"suborfull", "=", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"If", "[", 
     RowBox[{
     "SplitDone", ",", "\"\<Subnet Diagram\>\"", ",", 
      "\"\<Full Network\>\""}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Onthebot", "=", 
   RowBox[{"Panel", "[", 
    RowBox[{
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"DefaultButton", "[", 
           RowBox[{"\"\<Split Network\>\"", ",", 
            RowBox[{"DialogReturn", "[", 
             RowBox[{"buttonchoice", "=", "1"}], "]"}]}], "]"}], ",", 
          RowBox[{"Button", "[", 
           RowBox[{"\"\<Merge Subnets\>\"", ",", 
            RowBox[{"DialogReturn", "[", 
             RowBox[{"buttonchoice", "=", "2"}], "]"}], ",", 
            RowBox[{"Enabled", "\[Rule]", 
             RowBox[{"Dynamic", "[", "SplitDone", "]"}]}]}], "]"}], ",", 
          RowBox[{"Button", "[", 
           RowBox[{"\"\<Save  Subnets\>\"", ",", 
            RowBox[{"DialogReturn", "[", 
             RowBox[{"buttonchoice", "=", "3"}], "]"}], ",", 
            RowBox[{"Enabled", "\[Rule]", 
             RowBox[{"Dynamic", "[", "SplitDone", "]"}]}]}], "]"}], ",", 
          RowBox[{"Button", "[", 
           RowBox[{"\"\<Printed Output\>\"", ",", 
            RowBox[{"DialogReturn", "[", 
             RowBox[{"buttonchoice", "=", "4"}], "]"}], ",", 
            RowBox[{"Enabled", "\[Rule]", 
             RowBox[{"Dynamic", "[", "SplitDone", "]"}]}]}], "]"}], ",", 
          RowBox[{"Button", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "suborfull", "]"}], ",", 
            RowBox[{"DialogReturn", "[", 
             RowBox[{"buttonchoice", "=", "6"}], "]"}]}], "]"}], ",", 
          RowBox[{"CancelButton", "[", 
           RowBox[{"\"\<Exit\>\"", ",", 
            RowBox[{"DialogReturn", "[", 
             RowBox[{"buttonchoice", "=", "12"}], "]"}]}], "]"}]}], "}"}], 
        "}"}], ",", 
       RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}], ",", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Actions\>\"", ",", "\"\<Subtitle\>\""}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"buttonchoice", "<", "12"}], ",", 
    RowBox[{
     RowBox[{"Status", "=", "\"\<Waiting for action\>\""}], ";", 
     RowBox[{"CalculationTime", "+=", 
      RowBox[{
       RowBox[{"TimeUsed", "[", "]"}], "-", "StartTime"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"DialogInput", "[", 
      RowBox[{
       RowBox[{"Column", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Onthetop", ",", "Inthemid", ",", "Onthebot"}], "}"}], ",", 
         RowBox[{"Spacer", "[", "20", "]"}]}], "]"}], ",", 
       RowBox[{
       "WindowTitle", "\[Rule]", "\"\<NetSplitter Control Panel \>\""}], ",", 
       RowBox[{"WindowSize", "\[Rule]", "All"}]}], "]"}], ";", 
     RowBox[{"StartTime", "=", 
      RowBox[{"TimeUsed", "[", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"buttonchoice", ",", "1", ",", 
       RowBox[{
        RowBox[{"CalculationTime", "=", "0"}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"GetInputS", "[", "]"}], ",", 
          RowBox[{
           RowBox[{"ExternalSearch", "[", "]"}], ";", 
           RowBox[{"SplitDone", "=", "True"}]}]}], "]"}]}], ",", "2", ",", 
       RowBox[{"Combine", "[", 
        RowBox[{"{", "}"}], "]"}], ",", "3", ",", 
       RowBox[{"SubExport", "[", "]"}], ",", "4", ",", 
       RowBox[{"Printout", "[", "]"}], ",", "5", ",", 
       RowBox[{
        RowBox[{"TargetCompounds", "=", 
         RowBox[{"{", "}"}]}], ";", 
        RowBox[{"Targetfile", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"StringLength", "[", "Targetfile", "]"}], "\[Equal]", 
            "0"}], ",", "\"\< \>\"", ",", "Targetfile"}], "]"}]}], ";", 
        RowBox[{"Targetmess", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"FileType", "[", "Targetfile", "]"}], "]"}], "\[Equal]", 
            "\"\<File\>\""}], ",", 
           RowBox[{"GetTargets", "[", "Targetfile", "]"}], ",", 
           "\"\<\\nNo target metabolites input file was read.\>\""}], "]"}]}],
         ";"}], ",", "6", ",", 
       RowBox[{"If", "[", 
        RowBox[{"SplitDone", ",", 
         RowBox[{
          RowBox[{"CheckedInput", "=", "False"}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"AscendList", "=", 
             RowBox[{"Sort", "@", 
              RowBox[{"Map", "[", 
               RowBox[{"Length", ",", 
                RowBox[{"Most", "@", "FinalBlocks"}]}], "]"}]}]}], ";", 
            RowBox[{"metanodes", "=", "30"}], ";", 
            RowBox[{"minblocksize", "=", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "AscendList", "]"}], ">", 
                "metanodes"}], ",", 
               RowBox[{"AscendList", "[", 
                RowBox[{"[", 
                 RowBox[{"-", "metanodes"}], "]"}], "]"}], ",", "1"}], 
              "]"}]}], ";"}], "*)"}], 
          RowBox[{"minblocksize", "=", "1"}], ";", 
          RowBox[{"showmax", "=", "ConnexMax"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Blockchoice", "=", 
           RowBox[{"Pick", "[", 
            RowBox[{
             RowBox[{"Range", "[", "FinalBlockCount", "]"}], ",", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", "#", "]"}], ">", "0"}], "&"}], ",", 
               "FinalBlocks"}], "]"}]}], "]"}]}], ";", 
          RowBox[{"PrependTo", "[", 
           RowBox[{"Blockchoice", ",", "0"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"While", "[", 
           RowBox[{
            RowBox[{"!", "CheckedInput"}], ",", 
            RowBox[{
             RowBox[{"Descript", "=", 
              RowBox[{"ConstantArray", "[", 
               RowBox[{"\"\<\>\"", ",", "BlockCount"}], "]"}]}], ";", 
             RowBox[{"PrependTo", "[", 
              RowBox[{
              "Descript", ",", "\"\<Subnet linking by shared externals\>\""}],
               "]"}], ";", 
             RowBox[{"AppendTo", "[", 
              RowBox[{
              "Descript", ",", "\"\<Subnets of size 1 (orphans) \>\""}], 
              "]"}], ";", 
             RowBox[{"Choicetext", "=", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "\[Rule]", 
                 RowBox[{"\"\<Subnet \>\"", "<>", 
                  RowBox[{"ToString", "[", "#", "]"}]}]}], "&"}], "/@", 
               "Blockchoice"}]}], ";", 
             RowBox[{"Choicetext", "=", 
              RowBox[{"ReplacePart", "[", 
               RowBox[{"Choicetext", ",", 
                RowBox[{"1", "\[Rule]", 
                 RowBox[{"0", "->", "\"\<Metanet\>\""}]}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IsolationBlock", "!=", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"Choicetext", "=", 
                RowBox[{"ReplacePart", "[", 
                 RowBox[{"Choicetext", ",", 
                  RowBox[{
                   RowBox[{"-", "1"}], "\[Rule]", 
                   RowBox[{
                   "FinalBlockCount", "\[Rule]", "\"\<Orphans\>\""}]}]}], 
                 "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"res", "=", 
              RowBox[{"DialogInput", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"name", "=", 
                   RowBox[{"Descript", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                  RowBox[{"blockno", "=", "0"}]}], "}"}], ",", 
                RowBox[{"Grid", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"TextCell", "[", "\"\<Block selection\>\"", "]"}],
                     ",", 
                    RowBox[{
                    "TextCell", "[", "\"\<Subnetwork Title (optional)\>\"", 
                    "]"}], ",", 
                    RowBox[{
                    "TextCell", "[", "\"\<Smallest Metanet block\>\"", "]"}], 
                    ",", 
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "minblocksize", "]"}], ",", 
                    "Number", ",", 
                    RowBox[{"FieldSize", "\[Rule]", "2"}]}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"PopupMenu", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{"blockno", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"blockno", "=", "#"}], ";", 
                    RowBox[{"name", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"#", "\[LessEqual]", "FinalBlockCount"}], ",", 
                    RowBox[{"Descript", "[", 
                    RowBox[{"[", 
                    RowBox[{"#", "+", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"Descript", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ")"}], 
                    "&"}]}], "]"}], ",", "Choicetext", ",", 
                    RowBox[{"FieldSize", "\[Rule]", "8"}]}], "]"}], ",", 
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "name", "]"}], ",", "String", ",", 
                    RowBox[{"FieldSize", "\[Rule]", "40"}]}], "]"}], ",", 
                    RowBox[{
                    "TextCell", "[", "\"\<Max Connectivity\>\"", "]"}], ",", 
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "showmax", "]"}], ",", "Number", 
                    ",", 
                    RowBox[{"FieldSize", "\[Rule]", "2"}]}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"TextCell", "[", "\"\<\>\"", "]"}], ",", 
                    RowBox[{"TextCell", "[", "\"\<\>\"", "]"}], ",", 
                    RowBox[{"DefaultButton", "[", 
                    RowBox[{"\"\<Draw subnetwork\>\"", ",", 
                    RowBox[{"DialogReturn", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "blockno", ",", "name", ",", "minblocksize", ",", 
                    "showmax"}], "}"}], "]"}]}], "]"}], ",", 
                    RowBox[{"CancelButton", "[", "]"}]}], "}"}]}], "}"}], ",", 
                  RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}], ",", 
                RowBox[{
                "WindowTitle", "\[Rule]", 
                 "\"\<Choose the block to be drawn\>\""}]}], "]"}]}], ";", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "res", "]"}], "\[Equal]", "4"}], ",", 
               RowBox[{"Which", "[", 
                RowBox[{
                 RowBox[{"Not", "[", 
                  RowBox[{"0", "\[LessEqual]", 
                   RowBox[{"res", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
                   "FinalBlockCount"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"DialogInput", "[", 
                   RowBox[{"DialogNotebook", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"TextCell", "[", 
                    RowBox[{"\"\<Invalid block number: \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"res", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", 
                    "\"\<\\nMust be between 0 and  \>\"", "<>", 
                    RowBox[{"ToString", "[", "FinalBlockCount", "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"Button", "[", 
                    RowBox[{"\"\<OK\>\"", ",", 
                    RowBox[{"DialogReturn", "[", "1", "]"}]}], "]"}]}], "}"}],
                     "]"}], "]"}], ";"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"res", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], "&&", 
                  RowBox[{
                   RowBox[{"Count", "[", 
                    RowBox[{
                    RowBox[{"Map", "[", 
                    RowBox[{"Length", ",", 
                    RowBox[{"Most", "@", "FinalBlocks"}]}], "]"}], ",", 
                    RowBox[{"x_", "/;", 
                    RowBox[{"x", ">", 
                    RowBox[{"res", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}]}], "]"}], "<", "2"}]}],
                  ",", 
                 RowBox[{
                  RowBox[{"DialogInput", "[", 
                   RowBox[{"DialogNotebook", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "TextCell", "[", 
                    "\"\<Cannot draw meta-network for fewer than two blocks. \
\\nTry reducing minimum block size\>\"", "]"}], ",", 
                    RowBox[{"Button", "[", 
                    RowBox[{"\"\<OK\>\"", ",", 
                    RowBox[{"DialogReturn", "[", "1", "]"}]}], "]"}]}], "}"}],
                     "]"}], "]"}], ";"}], ",", "True", ",", 
                 RowBox[{
                  RowBox[{"CheckedInput", "=", "True"}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"res", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"res", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "=", 
                    RowBox[{"minblocksize", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{"minblocksize", ",", "1"}], "]"}]}]}], ";", 
                    RowBox[{
                    RowBox[{"res", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "=", 
                    RowBox[{
                    RowBox[{"res", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "<>", 
                    "\"\<, showing blocks larger than \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"minblocksize", "-", "1"}], "]"}]}]}]}]}], "]"}], 
                  ";", 
                  RowBox[{"If", "[", 
                   RowBox[{"SafeDraw", ",", 
                    RowBox[{"SafeDrawSubnet", "@@", "res"}], ",", 
                    RowBox[{"DrawSubnet", "@@", "res"}]}], "]"}], ";"}]}], 
                "]"}], ",", 
               RowBox[{
                RowBox[{"CheckedInput", "=", "True"}], ";"}]}], "]"}]}]}], 
           "]"}]}], ",", 
         RowBox[{
          RowBox[{"buttonchoice", "=", "1"}], ";", 
          RowBox[{"GetInputS", "[", "]"}], ";", 
          RowBox[{"DrawFullnet", "[", "]"}]}]}], "]"}], ",", "7", ",", 
       RowBox[{
        RowBox[{"ret", "=", 
         RowBox[{"SystemDialogInput", "[", 
          RowBox[{"\"\<FileOpen\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"Infile", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Network (.sbml, .tsv)\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<*.sbml\>\"", ",", "\"\<*.tsv\>\""}], "}"}]}], 
               ",", 
               RowBox[{"\"\<All\>\"", "\[Rule]", 
                RowBox[{"{", "\"\<*.*\>\"", "}"}]}]}], "}"}]}], "}"}]}], 
          "]"}]}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ret", "\[NotEqual]", "\"\<$Canceled\>\""}], ",", 
          RowBox[{"Infile", "=", "ret"}]}], "]"}], ";", 
        RowBox[{"SplitDone", "=", "False"}], ";"}], ",", "8", ",", 
       RowBox[{
        RowBox[{"ret", "=", 
         RowBox[{"SystemDialogInput", "[", 
          RowBox[{"\"\<FileOpen\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"Exfile", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Text \>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<*.txt\>\"", ",", "\"\<*.tsv\>\"", ",", "\"\<*.\>\""}], 
                 "}"}]}], ",", 
               RowBox[{"\"\<All\>\"", "\[Rule]", 
                RowBox[{"{", "\"\<*.*\>\"", "}"}]}]}], "}"}]}], "}"}]}], 
          "]"}]}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ret", "\[NotEqual]", "\"\<$Canceled\>\""}], ",", 
          RowBox[{"Exfile", "=", "ret"}]}], "]"}], ";"}], ",", "9", ",", 
       RowBox[{
        RowBox[{"ret", "=", 
         RowBox[{"SystemDialogInput", "[", 
          RowBox[{"\"\<FileOpen\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"Targetfile", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Text \>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<*.txt\>\"", ",", "\"\<*.tsv\>\"", ",", "\"\<*.\>\""}], 
                 "}"}]}], ",", 
               RowBox[{"\"\<All\>\"", "\[Rule]", 
                RowBox[{"{", "\"\<*.*\>\"", "}"}]}]}], "}"}]}], "}"}]}], 
          "]"}]}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ret", "\[NotEqual]", "\"\<$Canceled\>\""}], ",", 
          RowBox[{"Targetfile", "=", "ret"}]}], "]"}], ";"}], ",", "10", ",", 
       RowBox[{
        RowBox[{"ret", "=", 
         RowBox[{"SystemDialogInput", "[", 
          RowBox[{"\"\<FileOpen\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"Fluxfile", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Spreadsheet (.xls, .dif, .csv)\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<*.xls\>\"", ",", "\"\<*.dif\>\"", ",", 
                  "\"\<*.csv\>\""}], "}"}]}], ",", 
               RowBox[{"\"\<Text \>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<*.txt\>\"", ",", "\"\<*.tsv\>\""}], "}"}]}], 
               ",", 
               RowBox[{"\"\<All\>\"", "\[Rule]", 
                RowBox[{"{", "\"\<*.*\>\"", "}"}]}]}], "}"}]}], "}"}]}], 
          "]"}]}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ret", "\[NotEqual]", "\"\<$Canceled\>\""}], ",", 
          RowBox[{"Fluxfile", "=", "ret"}]}], "]"}], ";"}], ",", "11", ",", 
       RowBox[{
        RowBox[{"Convert", "=", "True"}], ";", 
        RowBox[{"GetInputS", "[", "]"}], ";", 
        RowBox[{"Convert", "=", "False"}], ";"}]}], "]"}]}]}], "]"}], ";", 
  RowBox[{"NotebookClose", "[", "keepup", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.4840085232531233`*^9, 3.484008577097907*^9}, {
   3.4852073633018894`*^9, 3.485207363770645*^9}, 3.4854703358828444`*^9, {
   3.4856379910227766`*^9, 3.4856381673497725`*^9}, {3.485638557521055*^9, 
   3.4856385661926527`*^9}, {3.485638898631101*^9, 3.4856389046464186`*^9}, {
   3.485638968908753*^9, 3.4856389927200336`*^9}, 3.485639030639967*^9, 
   3.485639061138406*^9, {3.4856392290985556`*^9, 3.485639273252545*^9}, 
   3.4856393216094437`*^9, {3.4856396951591883`*^9, 3.4856397759704304`*^9}, 
   3.4856409026929708`*^9, 3.4856409542693305`*^9, 3.485641402314625*^9, 
   3.4910038579848795`*^9, {3.4982420650228887`*^9, 3.4982420985862474`*^9}, {
   3.4982452982015953`*^9, 3.498245298764157*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Part", "::", "partd"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Part specification \
\[NoBreak]\\!\\(FileReadWrite`Private`Reactions \[LeftDoubleBracket] \\(\\(1, \
2\\)\\) \[RightDoubleBracket]\\)\[NoBreak] is longer than depth of object. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/partd\\\", \
ButtonNote -> \\\"Part::partd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.499452318806531*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Part", "::", "partd"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Part specification \
\[NoBreak]\\!\\(FileReadWrite`Private`Reactions \[LeftDoubleBracket] \\(\\(1, \
2, 1, 1\\)\\) \[RightDoubleBracket]\\)\[NoBreak] is longer than depth of \
object. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/partd\\\", ButtonNote -> \
\\\"Part::partd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.499452318806531*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Part", "::", "partd"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Part specification \
\[NoBreak]\\!\\(FileReadWrite`Private`Reactions \[LeftDoubleBracket] \\(\\(1, \
2, 1, 2\\)\\) \[RightDoubleBracket]\\)\[NoBreak] is longer than depth of \
object. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/partd\\\", ButtonNote -> \
\\\"Part::partd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.499452318822157*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Part :: \
partd\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.499452318822157*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
InitializationCellEvaluation->True,
InitializationCellWarning->False,
WindowSize->{771, 578},
WindowMargins->{{38, Automatic}, {Automatic, 92}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{72.00000078, 72.00000078}, \
{54.000000584999995`, 54.000000584999995`}}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 406, 6, 153, "Title"],
Cell[CellGroupData[{
Cell[998, 32, 30, 0, 71, "Section"],
Cell[1031, 34, 1559, 24, 258, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2627, 63, 208, 3, 71, "Section"],
Cell[2838, 68, 1495, 34, 252, "Input"],
Cell[4336, 104, 781, 18, 72, "Input"],
Cell[5120, 124, 833, 21, 72, "Input"],
Cell[CellGroupData[{
Cell[5978, 149, 29325, 670, 2552, "Input"],
Cell[35306, 821, 552, 11, 70, "Message"],
Cell[35861, 834, 560, 12, 70, "Message"],
Cell[36424, 848, 560, 12, 70, "Message"],
Cell[36987, 862, 528, 11, 70, "Message"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
