(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6805,        174]
NotebookOptionsPosition[      5946,        142]
NotebookOutlinePosition[      6564,        164]
CellTagsIndexPosition[      6521,        161]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Partitioning a stoichiometric network into subnetworks", "Title",
 CellChangeTimes->{{3.399941196546875*^9, 3.399941245359375*^9}, {
  3.40036951296875*^9, 3.40036951365625*^9}, {3.400440955640625*^9, 
  3.400440967859375*^9}, {3.40045740109375*^9, 3.400457421140625*^9}, {
  3.401399787171875*^9, 3.401399824546875*^9}, {3.40510538684375*^9, 
  3.40510544021875*^9}},
 Background->RGBColor[1, 0, 1]],

Cell[CellGroupData[{

Cell["QUICK START", "Section"],

Cell[TextData[{
 "1. Run this notebook by choosing Evaluation/Evaluate Notebook from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " menu.\n2. On the Netslpitter control panel that appears, the default input \
path that appears in the box labelled  \"Stoichiometry matrix input file\" \
should point to the demonstration input file \"demo.tsv\". Alternatively, you \
can simply type the word \"demo\" in this box. Click the \"Split Network\" \
button at the bottom.\n3. In the externals selection dialogue that appears, \
you can simply accept all choices offered by pressing  \"Return\". It \
progresses to Round 1, where (depending on the demo input chosen) a single \
blue background block shows that the matrix is not split yet. Pressing \
\[OpenCurlyDoubleQuote]Return\[CloseCurlyDoubleQuote] a few more times, the \
appearance of two or more blue background blocks shows when splitting has \
been achieved. The program will attempt further splitting in subsequent \
rounds until it can find no more candidate separation nodes and finishes \
automatically.\n4. Otherwise you could click \"Finish\" in any round to exit \
the externals selection process.\n5. Back in the Netsplitter control panel, \
you can now choose to inspect the printout or subnet diagrams, before and/or \
after merging blocks.\n6. For more information, consult the user guide that \
is included as a PDF or Microsoft Word document file with the download."
}], "Text",
 CellChangeTimes->{{3.4856302907112217`*^9, 3.485630345990641*^9}, {
   3.4858260783720655`*^9, 3.485826117934312*^9}, {3.485826392151307*^9, 
   3.485826393088801*^9}, {3.499380228341653*^9, 3.499380519527238*^9}, 
   3.5045501525361977`*^9, {3.504550361576364*^9, 3.504550581200539*^9}, {
   3.5045506119353075`*^9, 3.504550695483252*^9}, {3.50455072618677*^9, 
   3.504550741483841*^9}},
 FontFamily->"Times New Roman",
 FontSize->14]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load and Execute", "Subtitle",
 CellChangeTimes->{{3.5044699482697487`*^9, 3.5044699548790817`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<\\\\Packages\>\""}], 
   "]"}], ";"}], "\n", 
 RowBox[{"Get", "[", "\"\<Netsplitter`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", "\"\<FileReadWrite`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<MatrixDisplay`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<BlockFinder`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<SubnetLayout`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<Printout`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<RandomWalkBlocker`\>\"", "]"}], "\n", 
 RowBox[{"Get", "[", "\"\<SelectExternals`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", "\"\<MainDialog`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LUlogo", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ulog\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<GZIP\>\"", ",", "\"\<GIF\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CFACSLogo", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<clog\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<GZIP\>\"", ",", "\"\<GIF\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.4856291888601055`*^9, {3.485629314284051*^9, 3.4856293466270657`*^9}, {
   3.4856293900582204`*^9, 3.485629400490443*^9}, {3.4856295754051647`*^9, 
   3.4856295836685677`*^9}, {3.48562962550107*^9, 3.485629631436974*^9}, {
   3.499452084853658*^9, 3.499452101260643*^9}, {3.504484536596473*^9, 
   3.504484551173292*^9}, {3.504485660567091*^9, 3.5044856686612034`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Infile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<Demo.tsv\>\""}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Exfile", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";", 
  RowBox[{"Targetfile", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";", 
  RowBox[{"Fluxfile", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4840085232531233`*^9, 3.484008557878788*^9}, {
   3.4840086247232924`*^9, 3.484008652848472*^9}, 3.484342204199275*^9, {
   3.4843454083036003`*^9, 3.484345412975625*^9}, {3.4856294995505595`*^9, 
   3.4856295126251693`*^9}, {3.4994516978289933`*^9, 3.4994517124062786`*^9}, 
   3.499452071431182*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Splash", "[", 
   RowBox[{"LUlogo", ",", "CFACSLogo"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StatusWindow", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ControlPanel", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5045489559451585`*^9, 3.5045490015857835`*^9}, {
  3.504549860694316*^9, 3.50454987027238*^9}}]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
InitializationCellEvaluation->True,
InitializationCellWarning->False,
WindowSize->{771, 578},
WindowMargins->{{38, Automatic}, {Automatic, 92}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{72.00000078, 72.00000078}, \
{54.000000584999995`, 54.000000584999995`}}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 406, 6, 153, "Title"],
Cell[CellGroupData[{
Cell[998, 32, 30, 0, 71, "Section"],
Cell[1031, 34, 1894, 29, 277, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2962, 68, 106, 1, 49, "Subtitle"],
Cell[3071, 71, 1668, 36, 272, "Input"],
Cell[4742, 109, 781, 18, 72, "Input"],
Cell[5526, 129, 392, 9, 72, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
