(* Mathematica Package *)

(* COPYRIGHT (C) 2010 Wynand Verwoerd 
under the terms of the GNU General Public License V3
This program is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
See the GNU General Public License for more details.
*)

BeginPackage["MatrixDisplay`",{"NetSplitter`"}]
(* Exported symbols added here with SymbolName::usage *)  
BlockSelection::usage="Routine to handle interactive selection of a block by clicking on the matrix plot"
PinkBlue::usage="Produces coloured background blocks on matrix plots"
Candidates::usage="Finds candidate metabolites to be made external"
TickSpec::usage="Specify ticks on matrix plots"
Eff::usage="Calculates efficacy of a partitioning into blocks and orphans"

Begin["`Private`"] (* Begin Private Context *) 

BlockSelection[CBlock_]:=Complement[SelectedBlocks\[Union]CBlock,SelectedBlocks\[Intersection]CBlock]

BlockPlot[Offset_,ChooseBlocks_]:=Module[{BBlocks=ConstantArray[0,{Sources+Offset, Sinks}],Tinge},
	For[i=1,i<= BlockCount,i++,
		Tinge=If[MemberQ[ChooseBlocks,i],6,4];
		BBlocks[[CrossBlocks[[2,i,1]]+Offset;;Max[CrossBlocks[[2,i,2]],CrossBlocks[[2,i,1]]]+Offset,CrossBlocks[[1,i,1]];;CrossBlocks[[1,i,2]]]]=Tinge;];
BBlocks]

Pinkblock[Offset_,Targets_]:=Module[{rows,cols,TT=ConstantArray[0,{Sources+Offset, Sinks}]},
	If[Targets!= {},
		{cols,rows}=Which[First[Targets]>Sinks,{{},Targets},
			Last[Targets]<= Sinks,{Targets,{}},
			True,Split[Targets,!(#1<= Sinks&&#2>Sinks)&]];
			Do[TT[[1;;,cols[[i]]]]=2,{i,1,Length[cols]}];
			Do[TT[[rows[[i]]-Sinks+Offset,1;;]]=2,{i,1,Length[rows]}]];
TT];

PinkBlue[Ofset_,Targets_,ChooseBlocks_]:=
	If[Sinks>0 && Sources>0,MapThread[Max,{BlockPlot[Ofset,ChooseBlocks],Pinkblock[Ofset,Targets]},2],{{0}}];

Candidates[Chosen_]:=Module[{BB=ConstantArray[0,{Sources,Sinks}],CompNo},
For[i=1,i<= Length[Chosen],i++,CompNo=Chosen[[i]];
	If[CompNo<= Sinks,BB[[All,CompNo]]=ConsolBlocking[[All,CompNo]],BB[[CompNo-Sinks]]=ConsolBlocking[[CompNo-Sinks]]]];
BB]

TickSpec[Chosen_]:=Module[{HT,VT,LefTicks,RiTicks,BotTicks,TopTicks},
	LefTicks=Table[{i,i+Sinks},{i,1,Sources,Max[5,Floor[Sources/20,10]]}];
	BotTicks=Table[i,{i,1,Sinks,Max[Floor[Sinks/7,5],5]}];
	HT=Select[Chosen,#<= Sinks&];PrependTo[HT,1];
	TopTicks=AppendTo[HT,Sinks];
	VT=Select[Chosen,#>Sinks&]-Sinks;PrependTo[VT,1];AppendTo[VT,Sources];
	RiTicks=Map[{#,#+Sinks}&,VT];
{{LefTicks,RiTicks},{BotTicks,TopTicks}}]

HorizontalTickSpec[Chosen_]:=Module[{HT,VT,LefTicks,RiTicks,BotTicks,TopTicks},
	LefTicks=Table[{i,i+Sinks},{i,1,Sources,Max[5,Floor[Sources/20,10]]}];
	BotTicks=Table[i,{i,1,Sinks,Max[Floor[Sinks/7,5],5]}];
	HT=Select[Chosen,#<= Sinks&];PrependTo[HT,1];
	TopTicks=AppendTo[HT,Sinks];
	VT=Select[Chosen,#>Sinks&]-Sinks;PrependTo[VT,1];AppendTo[VT,Sources];
	RiTicks=Map[{#,#+Sinks}&,VT];
{{BotTicks,TopTicks},{LefTicks,RiTicks}}]

Eff[p_, FoundBlocks_] := 
 Module[{NodeCount, InternalCounts, Blockcount, OrphanCount, k}, 
  OrphanCount = Length[IsolationBlock]; 
  InternalCounts = 
   Join[Total[
     Map[Flatten@Differences[#, {0, 1}] + 1 &, CrossBlocks, 1]], 
    Length /@ FoundBlocks]; 
  InternalCounts = DeleteCases[InternalCounts, 0]; (* 
  Remove dummy placeholder blocks*)
  Blockcount = Length[InternalCounts]; k = Blockcount + OrphanCount;
  NodeCount = Total[InternalCounts] + OrphanCount;
  Round[100*(
    Log[NodeCount^p] - 
     If[k > 1, Log[k^p + 1/k (Total[InternalCounts^p] + OrphanCount)],
       Log[NodeCount^p]])/(Log[NodeCount^p] - Log[2 NodeCount^(p/2)])]
  ]
  
End[] (* End Private Context *)

EndPackage[]