(* ::Package:: *)

(* Mathematica Package *)

(* COPYRIGHT (C) 2010 Wynand Verwoerd 
under the terms of the GNU General Public License V3
This program is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
See the GNU General Public License for more details.
*)

(* This package run by init.m declares and/or initialises variables semi-globally for 
   use in all packages used by NetSplitter.
   Remember to add the context {"NetSplitter`"} as a second argument of BeginPackage
   in all packages that use any of them. *)

BeginPackage["NetSplitter`"]
(* SymbolName::usage="text" adds a hover message *) 

(* Configurations *)
Foundtinge::usage="Background colour of blocks that were found "
Chosentinge::usage="Background colour of selected blocks"
Targetinge::usage="Background colour of target metabolites"
PrintColumns::usage="No of columns in metabolite listings"
Effpower::usage="Power law exponent for calculating split efficacy"

NSPLVersion=" Version 1.2.3  January 2011  ";
Foundtinge=Lighter[Blue,0.7];Chosentinge=Lighter[Green,0.6];Targetinge=Lighter[Magenta,0.8];
PrintColumns=3; PrintMultHorPages=True; SafeDraw=False;
Effpower := 0.25 (CNodes - Length[StructuralExternalrows])^0.5; (* OR 2<const<8 *)
SetAttributes[StringSplit,Listable];

(* Main dialog choices *)
DistChoice=SokalSneathDissimilarity;LinkChoice="Single";ReverseThem=False;
Manygreys=1; GreyMax=0.5;GreyLimit;GroupLevel;GroupLevelRange={0.3,0.7};ConnexMax=8;

(* Startup state specification *)
StartTime=0;CalculationTime=0;Iterationcount;
SplitDone = False; Convert = False; Dropstring = "";
Refusals={};Stepcount=0;RepeatMerge=False;OldMerge={};
Status = "Waiting for action";DecisionTrace;MergeTrace;

(* Files and data *)
Infile; Exfile; Targetfile; Fluxfile;Inpath;
Outfile="ExternalMetabolites.txt";
S;CR;RC;Complist;CompNames;CompIDs;Reactlist;Reversibles;CNodes;RNodes;
Externals;Externalrows;StExrows;InputExternalrows={};OutputExternalrows={};
StructuralExternalrows;ConnectionExternalrows;
BasicExternals;StoichioExternals;
PreMergeExternals;ChosenExternals;
Internalrows;InternalComplist;InternalCNodes;Connex;
DropComps;OrphanRows;
TargetCompounds;TargetIDs;
Compartlist;CompartIDs;


(* Blocking variables *)
Nameseq;Sinks;Sources;CrossBlocks;IsolationBlock;
SelectedBlocks;
ShuffleDAG;ConsolBlocking;
FinalBlocks;FinalBlockCount;BlockCount;
IntrowsperBlock;ColsperBlock;DAG;
Sourceseq;Sinkseq;
NewExternals;
BlockSinks;BlockChoice;
StartEff;PreMergeEff;PostMergeEff;

EndPackage[]

