//   Copyright   Oliver Blechert   2021   //

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "main_win.h"

#include "analyse_walking_win_result.h"
#include "analyse_walking_win_pairend_result.h"


   extern char **sequence_string;
   extern char **sam_sequence;
   extern int *sam_position;
   extern int *sam_contig;
   extern int sam_line;
   const char *text;
   extern int chromosome;
   extern int position;
   extern char **sequence;

   char **fastq_sequence_01;
   char **fastq_sequence_02;
   int sequence_amount;
   int **index_fastq_frag;
   int *index_counter;
   int *index_counter;
   int index_query();
   char **sequence;
   int query_fragment_amount;
   extern char *text01;
   extern char *text02;
   extern char *text03;
   extern char *text04;
   extern char *text05;
   extern int **fastq_fragment_loop;
   int **fastq_fragment_loop_read01_position;
   int **fastq_fragment_loop_read02_position;
   extern int *fragment_per_loop;

   int added_counter;
   int fragment_loop_counter;

   int *fastq_number;
   int *fastq_number_position;
   const int max_result_display=500; 
   const int max_store_fragment=100;

int fastq_matched_fragments (int fastq_fragment, int fastq_position, int loop_counter) {
   int alignment_to_display;
   char *ptr04;

   alignment_to_display=strtol(text04, &ptr04, 10);
   if (fragment_loop_counter<max_store_fragment) {
      fastq_fragment_loop[loop_counter][fragment_loop_counter]=fastq_fragment; 
      fragment_loop_counter++; 
   *(fragment_per_loop+(loop_counter))=*(fragment_per_loop+(loop_counter))+1; }            // store matched fragments 
   if (alignment_to_display==loop_counter && alignment_to_display!=0){
      if (added_counter<max_result_display) {
         *(fastq_number+added_counter)=fastq_fragment;
         *(fastq_number_position+added_counter)=fastq_position-(25*loop_counter);
         *(*(fastq_fragment_loop_read01_position+added_counter)+loop_counter)==fastq_position-(25*loop_counter);
         added_counter++; } }
return 0; }

int align_pairend (int fastq_pairend_number) {
   int i;
   int i1;
   int similarity_value;
   int similarity_threshold;
   similarity_threshold=25;
   int align_position; 
   align_position=0;
   int loop_amount;
   loop_amount=0;
   if (strlen(*sequence)>0) { 
      loop_amount=strlen(*sequence); }
   for (i=0; i<loop_amount; i++){
      similarity_value=0;
      if (strlen(*sequence)+i>101){
      for (i1=0;i1<100;i1++) {
         if (sequence[0][i1+i] == fastq_sequence_02[fastq_pairend_number][i1]) {
            ++similarity_value; }
         if (sequence[0][i1+i] != fastq_sequence_02[fastq_pairend_number][i1]) {
            similarity_value=0; }
         if (similarity_value==25) { 
            if (i-i1>0)
               align_position=i-i1; } } } }
return align_position; }


extern char **elongate() {
   added_counter=0;
   fragment_loop_counter=0;
   fastq_number=malloc(500 * sizeof(int));
   fastq_number_position=malloc(500 * sizeof(int));

   query_fragment_amount=1;
   const int match_score_half=25;
   char query_fragment[1][51]={"ATGGCGTCGAGATCTCAGGTCTCGTACGGGGACCGTGCAAAGACACACCC"};
   char query_fragment_cuped[7];
   int index_query_fragment_cuped;
   int fastq_fragment_tmp;
   int repeat_loop=5;
   int query_length; 
   int *sequence_length; 
   sequence_length=malloc(query_fragment_amount * sizeof(int *));
   int match; match=0; 
   int match_score;
   int base_count_max;
   int base_max;
   int base_total;
   int base_result_threshold=0;                  // threshold in percent
   int align[query_fragment_amount][25][4]; 
   int i; i=0;
   int i1; i1=0;
   int i2; i2=0;
   int i3; i3=0;
   int i_repeat_loop; i_repeat_loop=0;
   int i_query_fragment; i_query_fragment=0;
   int i_query_length; i_query_length=0;
   int i_fastq_fragment; i_fastq_fragment=0; 
   int i_fastq_length; i_fastq_length=0; 
   char *ptr01;
   repeat_loop=strtol(text01, &ptr01, 10);

   char *ptr02;
   base_result_threshold=strtol(text02, &ptr02, 10);


   fastq_fragment_loop=malloc(repeat_loop*sizeof(int *));
   fastq_fragment_loop_read01_position=malloc(repeat_loop*sizeof(int *));
   fastq_fragment_loop_read02_position=malloc(repeat_loop*sizeof(int *));
   for (i=0;i<repeat_loop;i++) {
      *(fastq_fragment_loop+i)=malloc(max_store_fragment*sizeof(int)); 
      *(fastq_fragment_loop_read01_position+i)=malloc(max_store_fragment*sizeof(int));
      *(fastq_fragment_loop_read02_position+i)=malloc(max_store_fragment*sizeof(int)); }

   fragment_per_loop=malloc(repeat_loop*sizeof(int *));
   for (i=0;i<repeat_loop;i++) {*(fragment_per_loop+i)=0; }
   added_counter=0;
   for (i=0;i<50;i++) { 
      query_fragment[0][i]=(char)*(text03+i); }
   query_fragment[0][50]='\0';
   query_length=strlen(query_fragment[0]);
   for (i=0;i<query_fragment_amount;i++) {
      *(sequence_length+i) = query_length; }       
   match_score = match_score_half*2;
   sequence = (char **) malloc((1) * sizeof(int *));                       //only one query fragment
   for (i = 0; i < query_fragment_amount; i++) {
      *(sequence+i) = (char *) malloc(50 * sizeof(char)); }
   for (i1=0;i1<query_fragment_amount; i1++) {                 
       *(sequence_length+i)=query_length+1; } 
   for (i1=0;i1<query_fragment_amount; i1++) {                 
      for (i=0;i<*sequence_length;i++) {
         *(*(sequence+i1)+i)=query_fragment[i1][i]; } }
   int fastq_string_length; fastq_string_length=0; 
   fastq_string_length=strlen (*fastq_sequence_01);
   for (i_query_fragment=0;i_query_fragment<query_fragment_amount;i_query_fragment++) {    
      for (i_repeat_loop=0;i_repeat_loop<repeat_loop;i_repeat_loop++){
         fragment_loop_counter=0;
         for (i=0;i<7;i++) { 
            query_fragment_cuped[i]=query_fragment[i_query_fragment][i]; }
         index_query_fragment_cuped=index_query(query_fragment_cuped);
         for (i1=0;i1<match_score_half;i1++){
            for (i2=0;i2<4;i2++){
               align[i_query_fragment][i1][i2]=0; } } 
         for (i_fastq_fragment=0; i_fastq_fragment< *(index_counter+index_query_fragment_cuped); i_fastq_fragment++) {   
            fastq_fragment_tmp=index_fastq_frag[index_query_fragment_cuped][i_fastq_fragment];
            for(i_fastq_length=0; i_fastq_length<fastq_string_length-(match_score); i_fastq_length++) {
               match=0;   
               for (i_query_length=0; i_query_length<match_score; ++i_query_length){
                  if (query_fragment[i_query_fragment][i_query_length] == fastq_sequence_01[fastq_fragment_tmp][i_fastq_length+i_query_length]) {
                     ++match; }
                  else {
                     break; }
                  if (match==match_score) {
                     fastq_matched_fragments (fastq_fragment_tmp, i_fastq_length, i_repeat_loop);                 //for displaying alignment
                     for (i=0;i<match_score_half;i++) {
                        if (fastq_sequence_01[fastq_fragment_tmp][i_fastq_length+i_query_length+i+1]=='A'){++align[i_query_fragment][i][0]; }
                        if (fastq_sequence_01[fastq_fragment_tmp][i_fastq_length+i_query_length+i+1]=='C'){++align[i_query_fragment][i][1]; }
                        if (fastq_sequence_01[fastq_fragment_tmp][i_fastq_length+i_query_length+i+1]=='G'){++align[i_query_fragment][i][2]; }
                        if (fastq_sequence_01[fastq_fragment_tmp][i_fastq_length+i_query_length+i+1]=='T'){++align[i_query_fragment][i][3]; } } } } } } 
      for (i1=0;i1<match_score_half;i1++) {
         query_fragment[i_query_fragment][i1]=query_fragment[i_query_fragment][i1+match_score_half]; }
      *(sequence+i_query_fragment) = (char *)realloc(*(sequence+i_query_fragment), (*(sequence_length+i_query_fragment)+match_score_half) * sizeof(char));
      for (i1=0;i1<match_score_half;i1++){
         base_total=0;
         base_max=0;
         base_count_max=align[i_query_fragment][i1][0];
         base_total=align[i_query_fragment][i1][0];
         for (i3=0;i3<4;i3++) {
            base_total=base_total+align[i_query_fragment][i1][i3];
            if (align[i_query_fragment][i1][i3]>base_count_max) {
               base_count_max=align[i_query_fragment][i1][i3];
               base_max=i3; } } 

   if (base_count_max>(base_total*base_result_threshold)/100 && base_count_max>5) {
      if (base_max==0) { query_fragment[i_query_fragment][i1+match_score_half]='A'; *(*(sequence+i_query_fragment)+*(sequence_length+i_query_fragment)+i1)='A'; }            
      if (base_max==1) { query_fragment[i_query_fragment][i1+match_score_half]='C'; *(*(sequence+i_query_fragment)+*(sequence_length+i_query_fragment)+i1)='C'; }            
      if (base_max==2) { query_fragment[i_query_fragment][i1+match_score_half]='G'; *(*(sequence+i_query_fragment)+*(sequence_length+i_query_fragment)+i1)='G'; }            
      if (base_max==3) { query_fragment[i_query_fragment][i1+match_score_half]='T'; *(*(sequence+i_query_fragment)+*(sequence_length+i_query_fragment)+i1)='T'; } }
      else { query_fragment[i_query_fragment][i1+match_score_half]='N'; *(*(sequence+i_query_fragment)+*(sequence_length+i_query_fragment)+i1)='N'; } }
      *(sequence_length+i_query_fragment)=*(sequence_length+i_query_fragment)+match_score_half; } } 
return sequence; }

void pairend_read01 () {
   call_analyse_pairend01_result(); }

void pairend_read02 () {
   call_analyse_pairend02_result(); }

void walkingresult_win (GtkWidget *widget, gpointer data) {

   GtkWidget *window;
   GtkWidget *box;
   GtkWidget *menubar;
   GtkWidget *filemenu;
   GtkWidget *file;

   GtkWidget *quit;
   GtkWidget *helpabout;
   GtkWidget *helpmenu;
   GtkWidget *help;
   GtkWidget *about;

   GtkEntryBuffer *buffer;
   GtkWidget *entry;

   GtkWidget *sw;
   GtkTextIter start, end;
   GtkTextTag *tag;
   GtkWidget *view=NULL;
   GtkTextBuffer *buffer_entry;
   GtkWidget *frame;
   GtkWidget *bbox;

   GtkWidget *box02;
   GtkWidget *frame02;
   GtkWidget *bbox02;
   GtkWidget *button02;
   GtkEntryBuffer *buffer02;
   GtkWidget *entry02;
   GtkWidget *view02=NULL;
   GtkWidget *buffer_entry02;

   GtkWidget *button;

   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

   sw = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 
   menubar = gtk_menu_bar_new();
   filemenu = gtk_menu_new();
   file = gtk_menu_item_new_with_label("File");
   quit = gtk_menu_item_new_with_label("Quit");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), filemenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(filemenu), quit);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), file);

   g_signal_connect_swapped (quit, "activate", G_CALLBACK (gtk_widget_destroy), window);

   helpmenu = gtk_menu_new();
   helpabout = gtk_menu_item_new_with_label("Help");
   help = gtk_menu_item_new_with_label("Help");
   about = gtk_menu_item_new_with_label("About");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(helpabout), helpmenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), help);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), about);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), helpabout);

   box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 5);
   gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, FALSE, 3);

   gtk_container_add (GTK_CONTAINER (window), box);

   frame = gtk_frame_new ("Result");
   frame02 = gtk_frame_new ("Pairend");

   bbox = gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
   bbox02 = gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);

   gtk_container_set_border_width (GTK_CONTAINER (bbox), 5);
   gtk_container_set_border_width (GTK_CONTAINER (bbox02), 5);

   gtk_container_add (GTK_CONTAINER (box), frame);
   gtk_container_add (GTK_CONTAINER (box), frame02);

   gtk_container_add (GTK_CONTAINER (frame), bbox);
   gtk_container_add (GTK_CONTAINER (frame02), bbox02);

   gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_START);
   gtk_box_set_spacing (GTK_BOX (bbox), 40);
   button = gtk_button_new_with_label (("Analyse"));

   gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox02), GTK_BUTTONBOX_START);
   gtk_box_set_spacing (GTK_BOX (bbox02), 40);
   button02 = gtk_button_new_with_label (("Analyse"));

   buffer = gtk_entry_buffer_new (NULL, 0);
   entry = gtk_entry_new_with_buffer (buffer);
   gtk_box_pack_start (GTK_BOX (bbox), entry, FALSE, FALSE, 0);

   buffer02 = gtk_entry_buffer_new (NULL, 0);
   entry02 = gtk_entry_new_with_buffer (buffer02);
   gtk_box_pack_start (GTK_BOX (bbox02), entry02, FALSE, FALSE, 0);

   gtk_entry_set_text (GTK_ENTRY (entry),"8");
   text04=gtk_entry_get_text (GTK_ENTRY (entry));

   gtk_entry_set_text (GTK_ENTRY (entry02),"8");
   text05=gtk_entry_get_text (GTK_ENTRY (entry02));

   g_signal_connect(button,"clicked",G_CALLBACK (pairend_read01), NULL);
   gtk_box_pack_start(GTK_BOX(bbox),button,0,0,0);

   g_signal_connect(button02,"clicked",G_CALLBACK (pairend_read02), NULL);
   gtk_box_pack_start(GTK_BOX(bbox02),button02,0,0,0);

   view = gtk_text_view_new_with_buffer ((GtkTextBuffer *)buffer);

   gtk_box_pack_start (GTK_BOX (box), sw, TRUE, TRUE, 0);
   gtk_container_add (GTK_CONTAINER (sw), view);

   buffer_entry =  gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));

   gtk_text_buffer_set_text (buffer_entry, *sequence, -1);

   tag=gtk_text_buffer_create_tag (buffer_entry, "Monospace", "family", "Monospace", NULL); 
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &start, 0);
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &end, -1);
   gtk_text_buffer_apply_tag (buffer_entry, tag, &start, &end); 
   gtk_window_set_title (GTK_WINDOW (window), "Result Walking");
   gtk_window_set_default_size (GTK_WINDOW (window), 1200, 400);
   gtk_widget_show_all (window); }

extern void call_analyse_walking_result () {
   elongate();
   walkingresult_win (NULL, NULL); }







