package GQ::Server::DB::Adaptor::ChatAdaptor;
use strict;
use Carp;
use DBI;

use vars qw( @ISA );
@ISA=qw(Tk::MainWindow);

{
    my $msgindex;

    sub msgindex {
	my ($self,$newindex)=@_;
	if (defined $newindex) {
	    return $msgindex=$newindex;
	} else {
	    return $msgindex;
	}
    }

}

sub new {
    my ($class, %args)=@_;
    my $self = bless {}, $class;
    $self->{dbh}=$args{dbh};
    $self->{context}=$args{context};
    $self->{user}=$args{context}->user;
    return $self;
}

sub withdraw_user {
    my ($self)=@_;
    my $sth_sel=$self->{dbh}->prepare("SELECT status FROM Chat_user WHERE user like ?");
    $sth_sel->execute($self->{user});
    my ($mode)=$sth_sel->fetchrow_array;
    if ($mode eq 'online') {
	my $sth=$self->{dbh}->prepare("REPLACE INTO Chat_user VALUES (?,'offline')");
	$sth->execute($self->{user});
	$self->{context}->commit;
    }
}

sub read_msg {
    my ($self)=@_;
    my @list;
    my $idstring;
    if (defined $self->msgindex) {
	$idstring='AND id>? '
    } else {
	$idstring='';
    }
    my $sth=$self->{dbh}->prepare('SELECT user,message,target,id FROM Chat '.
				  "WHERE (target=? or user=?) $idstring".
				  'ORDER BY id');
    if (defined $self->msgindex) {
        $sth->execute($self->{user},$self->{user},$self->msgindex);
    } else {
	$sth->execute($self->{user},$self->{user});
    }
    while (my ($from,$message,$target,$id)=$sth->fetchrow_array) {
	push @list,[$from,$message,$target,$id];
    }
    return @list;
}

sub take_msg {
    my ($self,$chat,$message)=@_;
    my $sth=$self->{dbh}->prepare('INSERT INTO Chat (user,message,target) '.
				  'VALUES (?,?,?)');
    foreach (keys %{$chat->{target}}) {
	if ($chat->{target}{$_}) {
	    $sth->execute($self->{user},$message,$_);
	    $self->{context}->commit;
	}
    }
}

sub find_possible_targets {
    my ($self)=@_;
    my @targets;
    my $sth=$self->{dbh}->prepare("REPLACE INTO Chat_user VALUES (?,'online')");
    $sth->execute($self->{user});
    $self->{context}->commit;
    $sth=$self->{dbh}->prepare("SELECT user FROM Chat_user WHERE status='online'");
    $sth->execute;
    while (my ($user)=$sth->fetchrow_array) {
       push @targets, $user;
    }
    return @targets;
}


1;





