package GQ::Server::GBFlat::Adaptor::ContainerAdaptor;
use strict;

use vars qw( $AUTOLOAD @ISA );  #Keep 'use strict' happy

use Carp;
use DBI;
use Storable qw(dclone);
use GQ::Root;
use GQ::Server::GBFlat::Adaptor::GenericFeatureAdaptor;
@ISA = qw (GQ::Server::GBFlat::Adaptor::GenericFeatureAdaptor);


{
#Encapsulated class data
#replace with your column names, and sensible defaults

    GQ::Root->create();
}

### write in any custom subroutines here

=head2 update_discard

 Title   : update_discard
 Usage   : if ($self->adaptor->update_discard($self)) {
 Function: move a copy of the current contents of the persistent version of a feature
           into a discard location so that the feature's history is preserved
 Returns : 1 on success, die with an error message on failure
 Args    : the feature that is about to be updated


=cut

sub update_discard {
    my ($self,$feat)=@_;

	return 1;

}

=head2 diff

 Title   : diff
 Usage   : my $difference=$self->adaptor->diff($self,$feature);
 Function: find the distance between the abs_start values of the contigs
           of two features from different contigs
 Returns : a number
 Args    : the two features whose contig abs_start difference you are looking for
 Note    : Could be replaced by
              $self->context->contig_by_id($self->contig_id)->abs_start -
              $feat->context->contig_by_id($feat->contig_id)->abs_start
           to avoid a further database call...

=cut

sub diff {
    my ($self,$feat,$feature)=@_;
	# I am guessing that this should return zero, since a GB file will have only one contig
    return 0;
}

=head2 add_element

 Title   : add_element
 Usage   : $self->add_element($fea,$new);
 Function: associate an element with a container feature
 Example : a gene has Transcript A.  Annotator finds a new Transcript,
           Transcript B, that is associated with that gene.  B is added to the
           gene in memory, and the adaptor makes it permanent:
           $gene->adaptor->add_element($gene,$TranscriptB);
 Returns : nothing
 Args    : the parent feature, and the element feature


=cut

sub add_element {
    my ($self,$fea,$new)=@_;
	#this could be made much mre sophisticated if we started adding features to the genbank object in memory
	return 0;
	}

=head2 remove_element

 Title   : remove_element
 Usage   : $self->remove_element($fea,$old);
 Function: disassociate an element from a container feature
 Example : The above Transcript B was an error, and must be removed
           from the gene:
           $gene->adaptor->remove_element($gene,$TranscriptB);
 Returns : nothing
 Args    : the parent feature, and the element feature


=cut

sub remove_element {
    my ($self,$fea,$old)=@_;
	# this could also be made more complex, but is more difficult with BioPerl Sequence objects as they are "immutable"
	return 0
}



1;
