package GQ::Server::GBFlat::Adaptor::ContigAdaptor;
use strict;
use vars qw(@ISA $AUTOLOAD);
use Carp;
use DBI;
use GQ::Root;
use GQ::Server::GBFlat::Adaptor::ObjectAdaptor;
@ISA=qw(GQ::Server::GBFlat::Adaptor::ObjectAdaptor);


{
#Encapsulated class data

    GQ::Root->create();

}

=head2 initialize

 Title   : initialize
 Usage   : my ($length,$VC_start,$VC_length,$abs_start,$id,$assembly)=$self->adaptor->initialize($self);
 Function: get the basic information from the persistent store about the given contig
 Returns : length, VC_start, VC_length, absolute start(assembly coordinates), contig id, and assembly id of the contig
           For details about the above attributes, see the DatabaseAPI.pod file.
 Args    : the contig object, which should have a name and not much else known about it


=cut

sub initialize {
    my ($self,$contig_object)=@_;
	#length,VC_start,VC_length,abs_start,ContigAssembly.id,assembly
	my $GB = $contig_object->context->GBobj;
	return ($GB->length,  # contig length
			1,			  # virtual contig start (in this case, just start of the contig)
			$GB->length,  # length of the virtual contig (in this case, length of the contig)
			1,            # absolute start (in this case, start of the contig)
			$contig_object->context->DEFAULT_ID,  	# ID for this contig, or some default
			$contig_object->context->DEFAULT_VERSION # assembly version number, or some default
			);
}

=head2 sequence

 Title   : sequence
 Usage   : $self->{sequence}=$self->adaptor->sequence($self);
 Function: return the sequence of the contig
 Returns : the sequence as a string
 Args    : the contig whose sequence is to be found


=cut

sub sequence {
    my ($self,$contig_obj)=@_;    
    return $contig_obj->context->GBobj->seq;
}

1;
